<?php
require_once("inc/protecao-admin.php");

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Administra&ccedil;&atilde;o</title>
  <link rel="stylesheet" href="/inc/materialdesignicons.min.css">
  <link rel="stylesheet" href="/inc/font-awesome.min.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.base.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.addons.css">
  <link rel="stylesheet" href="/inc/theme.css">
  <link rel="shortcut icon" href="/img/favicon.ico">
  <script type="text/javascript" src="/admin/inc/ajax.js"></script>
  <script type="text/javascript" src="/admin/inc/javascript.js"></script>
</head>

<body>
  <div class="container-scroller">
      <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <a class="navbar-brand brand-logo" href="/admin/admin-configuracoes"><span>Administra&ccedil;&atilde;o</span></a>
        <a class="navbar-brand brand-logo-mini" href="/admin/admin-configuracoes"><img src="/img/icones/img-icone-logo.png" title="Painel" width="32" height="32" border="0"></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end justify-content-lg-start">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
        <li class="nav-item nav-search d-none d-lg-block">
            <div class="input-group">
              <div class="input-group-prepend">
                <span class="input-group-text" id="search">
                  <i class="mdi mdi-magnify"></i>
                </span>
              </div>
              <input type="text" class="form-control" id="busca_chave" placeholder="Busca" aria-label="search" aria-describedby="search">
            </div>
          </li>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item">
            <a class="nav-link" href="/admin/sair"><i class="mdi mdi-logout f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Sair/logout"></i></a>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
      </div>
    </nav>

    <!-- modal -->                
      <div class="modal fade" id="log-sistema" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body" id="log-sistema-conteudo" style="text-align:center"><img src="/img/ajax-loader.gif" /></div>
            </div>
        </div>
      </div>
      
    <div class="container-fluid page-body-wrapper">      
    <?php require_once("menu-admin.php"); ?>
      <div class="main-panel">
        <div class="content-wrapper">
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo lang_pagina_tutoriais_titulo; ?></header>
                                        <div class="card-header-right">
                                            <button type="button" class="btn btn-info" onClick="window.location = '/admin/admin-cadastrar-tutorial';"><i class="ik ik-file-plus"></i><?php echo lang_botao_titulo_cadastrar; ?></button>
                                        </div>
                  </div>
                <div class="card-body">
                    <table id="data_table" class="table dataTable no-footer table-hover" role="grid" aria-describedby="data_table_info">
                                                <thead>
                                                    <tr role="row">
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_tutoriais_tutorial_titulo; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_tutoriais_data; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_tutoriais_visualizacoes; ?></th>
                                                        <th><?php echo lang_pagina_avisos_acoes; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
$sql = mysqli_query($conexao,"SELECT *, DATE_FORMAT(data,'%d/%m/%Y') AS data FROM tutoriais ORDER by codigo ASC");
while ($dados_tutorial = mysqli_fetch_array($sql)) {

$tutorial_code = code_decode($dados_tutorial["codigo"],"E");

echo "<tr id='".$tutorial_code."'>
<td height='25' align='left' scope='col'>&nbsp;".$dados_tutorial["titulo"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_tutorial["data"]."</td>
<td height='25' align='center' scope='col'>&nbsp;".$dados_tutorial["vizualizacoes"]."</td>
<td height='25' align='left' scope='col'>&nbsp;<a href='/admin/admin-tutorial-vizualizar/".$tutorial_code."' target='_blank'><i class='fa fa-eye f-16 text-blue'></i></a>&nbsp;<a href='/admin/admin-editar-tutorial/".$tutorial_code."'><i class='fa fa-pencil f-16 text-green'></i></a>&nbsp;<a href='javascript:remover_tutorial(\"".$tutorial_code."\");'><i class='fa fa-trash-o f-16 text-red'></i></a></td>
</tr>";

}
?>
                                                </tbody>
                                            </table>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>      

    </div>
  </div>
  <script src="/inc/vendor.bundle.base.js"></script>
  <script src="/inc/vendor.bundle.addons.js"></script>
  <script src="/inc/theme.js"></script>
  <script>
  $('#busca_chave').keypress(function (e) {
    if (e.which == 13) {
       window.location = "/admin/admin-streamings/resultado/"+document.getElementById("busca_chave").value;
    }
  }); 
        $(document).ready(function() {

            var table = $('#data_table').DataTable({
                responsive: true,
                "lengthMenu": [[25, 50, 100, 200, -1], [25, 50, 100, 200, "Todos/All"]],
                language: {
                    "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/<?php echo $lang_sortable; ?>.json"
                },
                select: true,
                'aoColumnDefs': [{
                    'bSortable': false,
                    'aTargets': ['nosort']
                }]
            });
            $('#data_table tbody').on( 'click', 'tr', function() {
                if ( $(this).hasClass('selected') ) {
                    $(this).removeClass('selected');
                }
                else {
                    table.$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            });

        });
  </script>
</body>
</html>