/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import org.farng.mp3.object.AbstractMP3Object;

public class ObjectBooleanString
extends AbstractMP3Object {
    public ObjectBooleanString(String string) {
        this.identifier = string;
    }

    public ObjectBooleanString(ObjectBooleanString objectBooleanString) {
        super(objectBooleanString);
    }

    public int getSize() {
        return 1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ObjectBooleanString)) {
            return false;
        }
        return super.equals(object);
    }

    public void readString(String string, int n) {
        if (string == null) {
            throw new NullPointerException("String is null");
        }
        if (n < 0 || n >= string.length()) {
            throw new IndexOutOfBoundsException("Offset to image string is out of bounds: offset = " + n + ", string.length()" + string.length());
        }
        char c = string.charAt(n);
        this.value = new Boolean(c != '0');
    }

    public String toString() {
        return "" + this.value;
    }

    public String writeString() {
        if (this.value == null) {
            return "0";
        }
        return (Boolean)this.value != false ? "1" : "0";
    }
}

