/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import org.farng.mp3.object.AbstractMP3Object;

public class ObjectID3v2LyricLine
extends AbstractMP3Object {
    String text = "";
    long timeStamp = 0L;

    public ObjectID3v2LyricLine(String string) {
        this.identifier = string;
    }

    public ObjectID3v2LyricLine(ObjectID3v2LyricLine objectID3v2LyricLine) {
        super(objectID3v2LyricLine);
        this.text = new String(objectID3v2LyricLine.text);
        this.timeStamp = objectID3v2LyricLine.timeStamp;
    }

    public int getSize() {
        return this.text.length() + 1 + 4;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public void setTimeStamp(long l) {
        this.timeStamp = l;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ObjectID3v2LyricLine)) {
            return false;
        }
        ObjectID3v2LyricLine objectID3v2LyricLine = (ObjectID3v2LyricLine)object;
        if (!this.text.equals(objectID3v2LyricLine.text)) {
            return false;
        }
        if (this.timeStamp != objectID3v2LyricLine.timeStamp) {
            return false;
        }
        return super.equals(object);
    }

    public void readByteArray(byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (n < 0 || n >= byArray.length) {
            throw new IndexOutOfBoundsException("Offset to byte array is out of bounds: offset = " + n + ", array.length = " + byArray.length);
        }
        this.text = new String(byArray, n, byArray.length - n - 4);
        this.timeStamp = 0L;
        for (int i = byArray.length - 4; i < byArray.length; ++i) {
            this.timeStamp <<= 8;
            this.timeStamp += (long)byArray[i];
        }
    }

    public String toString() {
        return this.timeStamp + " " + this.text;
    }

    public byte[] writeByteArray() {
        byte[] byArray = new byte[this.getSize()];
        for (int i = 0; i < this.text.length(); ++i) {
            byArray[i] = (byte)this.text.charAt(i);
        }
        byArray[i++] = 0;
        byArray[i++] = (byte)((this.timeStamp & 0xFFFFFFFFFF000000L) >> 24);
        byArray[i++] = (byte)((this.timeStamp & 0xFF0000L) >> 16);
        byArray[i++] = (byte)((this.timeStamp & 0xFF00L) >> 8);
        byArray[i] = (byte)(this.timeStamp & 0xFFL);
        return byArray;
    }
}

