/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.collection.module;

import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.util.ModuleUtils;

public class ModuleBlockDuplicateStreamNames
extends ModuleBase {
    IApplicationInstance appInstance = null;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
    }

    public void publish(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = this.extractStreamName(iClient, requestFunction, aMFDataList);
        if (this.isDuplicateStream(iClient, string)) {
            ModuleBlockDuplicateStreamNames.getLogger().info("ModuleBlockDuplicateStreamNames.publish[" + this.appInstance.getContextStr() + "]: Stream name is already in use: " + string);
            IMediaStream iMediaStream = ModuleBlockDuplicateStreamNames.getStream((IClient)iClient, (RequestFunction)requestFunction);
            ModuleBlockDuplicateStreamNames.sendStreamOnStatusError((IMediaStream)iMediaStream, (String)"NetStream.Publish.BadName", (String)("Stream name is already in use: " + string));
        } else {
            this.invokePrevious(iClient, requestFunction, aMFDataList);
        }
    }

    public void releaseStream(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = this.extractStreamName(iClient, requestFunction, aMFDataList);
        if (!this.isDuplicateStream(iClient, string)) {
            this.invokePrevious(iClient, requestFunction, aMFDataList);
        }
    }

    public String extractStreamName(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = aMFDataList.getString(3);
        if (string != null) {
            String string2 = "flv";
            String[] stringArray = ModuleUtils.decodeStreamExtension((String)string, (String)string2);
            string = stringArray[0];
            string2 = stringArray[1];
            string = string.split("\\?")[0];
        }
        return string;
    }

    public boolean isDuplicateStream(IClient iClient, String string) {
        if (string != null) {
            return iClient.getAppInstance().getStreams().getStream(string) != null;
        }
        return false;
    }
}

