/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.collection.module;

import com.wowza.util.StringUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.livedvr.ILiveStreamDvrRecorderControl;

public class ModuleDvrRecorderControl
extends ModuleBase {
    private String suffixes = "*";
    private boolean matchAllow = true;
    private boolean noMatchAllow = false;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.suffixes = iApplicationInstance.getProperties().getPropertyStr("dvrRecorderControlSuffixes", this.suffixes);
        this.matchAllow = iApplicationInstance.getProperties().getPropertyBoolean("dvrRecorderControlMatchAllow", this.matchAllow);
        this.noMatchAllow = iApplicationInstance.getProperties().getPropertyBoolean("dvrRecorderControlNoMatchAllow", this.noMatchAllow);
        iApplicationInstance.setLiveStreamDvrRecorderControl((ILiveStreamDvrRecorderControl)new DvrRecorderControl());
    }

    private class DvrRecorderControl
    implements ILiveStreamDvrRecorderControl {
        private DvrRecorderControl() {
        }

        public boolean shouldDvrRecord(String string, IMediaStream iMediaStream) {
            String[] stringArray;
            ModuleDvrRecorderControl.getLogger().info("DvrRecorderControl.shouldDvrRecord [" + string + " : " + iMediaStream.getName() + " : " + ModuleDvrRecorderControl.this.suffixes + "]", iMediaStream);
            if (ModuleDvrRecorderControl.this.suffixes.equals("*")) {
                ModuleDvrRecorderControl.getLogger().info("DvrRecorderControl.shouldDvrRecord [" + string + " : " + iMediaStream.getName() + " :  suffixes is wildcard. returning " + ModuleDvrRecorderControl.this.matchAllow + "]", iMediaStream);
                return ModuleDvrRecorderControl.this.matchAllow;
            }
            if (StringUtils.isEmpty((String)ModuleDvrRecorderControl.this.suffixes)) {
                ModuleDvrRecorderControl.getLogger().info("DvrRecorderControl.shouldDvrRecord [" + string + " : " + iMediaStream.getName() + " : suffixes is empty. returning " + ModuleDvrRecorderControl.this.noMatchAllow + "]", iMediaStream);
                return ModuleDvrRecorderControl.this.noMatchAllow;
            }
            for (String string2 : stringArray = ModuleDvrRecorderControl.this.suffixes.split(",")) {
                if (!iMediaStream.getName().endsWith(string2.trim())) continue;
                ModuleDvrRecorderControl.getLogger().info("DvrRecorderControl.shouldDvrRecord [" + string + " : " + iMediaStream.getName() + " : match found : " + string2.trim() + " : returning " + ModuleDvrRecorderControl.this.matchAllow + "]", iMediaStream);
                return ModuleDvrRecorderControl.this.matchAllow;
            }
            ModuleDvrRecorderControl.getLogger().info("DvrRecorderControl.shouldDvrRecord [" + string + " : " + iMediaStream.getName() + " : No match found : returning " + ModuleDvrRecorderControl.this.noMatchAllow + "]", iMediaStream);
            return ModuleDvrRecorderControl.this.noMatchAllow;
        }
    }
}

