/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.collection.module;

import com.wowza.util.IOPerformanceCounter;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamActionNotify2;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class ModuleLimitPublishedStreamBandwidth
extends ModuleBase {
    int MAXBITRATE = 800;
    int SUSTAINED = 10;
    int INTERVAL = 5000;
    Boolean logging = true;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.MAXBITRATE = iApplicationInstance.getProperties().getPropertyInt("MaxBitrate", this.MAXBITRATE);
        this.logging = iApplicationInstance.getProperties().getPropertyBoolean("StreamMonitorLogging", true);
        this.SUSTAINED = iApplicationInstance.getProperties().getPropertyInt("Sustained", this.SUSTAINED);
        ModuleLimitPublishedStreamBandwidth.getLogger().info("ModuleLimitPublishedStreamBandwidth MaxBitrate: " + this.MAXBITRATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStreamCreate(IMediaStream iMediaStream) {
        WMSProperties wMSProperties;
        ModuleLimitPublishedStreamBandwidth.getLogger().info("StreamCreate Name: " + iMediaStream.getName());
        StreamListener streamListener = new StreamListener();
        WMSProperties wMSProperties2 = wMSProperties = iMediaStream.getProperties();
        synchronized (wMSProperties2) {
            wMSProperties.put((Object)"streamActionNotifier", (Object)streamListener);
        }
        iMediaStream.addClientListener((IMediaStreamActionNotify2)streamListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStreamDestroy(IMediaStream iMediaStream) {
        WMSProperties wMSProperties;
        ModuleLimitPublishedStreamBandwidth.getLogger().info("StreamDestroy: " + iMediaStream.getName());
        IMediaStreamActionNotify2 iMediaStreamActionNotify2 = null;
        WMSProperties wMSProperties2 = wMSProperties = iMediaStream.getProperties();
        synchronized (wMSProperties2) {
            iMediaStreamActionNotify2 = (IMediaStreamActionNotify2)iMediaStream.getProperties().get((Object)"streamActionNotifier");
        }
        if (iMediaStreamActionNotify2 != null) {
            iMediaStream.removeClientListener(iMediaStreamActionNotify2);
            ModuleLimitPublishedStreamBandwidth.getLogger().info("removeClientListener: " + iMediaStream.getSrc());
        }
        iMediaStream.removeClientListener(iMediaStreamActionNotify2);
    }

    private class MonitorStream {
        public Timer mTimer;
        public TimerTask mTask;
        public IMediaStream stream;

        public MonitorStream(IMediaStream iMediaStream) {
            this.stream = iMediaStream;
            this.mTask = new TimerTask(){

                public void run() {
                    if (MonitorStream.this.stream == null) {
                        MonitorStream.this.stop();
                    }
                    IOPerformanceCounter iOPerformanceCounter = MonitorStream.this.stream.getMediaIOPerformance();
                    Double d = iOPerformanceCounter.getMessagesInBytesRate() * 8.0 * 0.001;
                    if (ModuleLimitPublishedStreamBandwidth.this.logging.booleanValue()) {
                        ModuleLimitPublishedStreamBandwidth.getLogger().info("Stream '" + MonitorStream.this.stream.getName() + "' BitRate: " + Math.round(Math.floor(d)) + "kbs, MaxBitrate:" + ModuleLimitPublishedStreamBandwidth.this.MAXBITRATE);
                    }
                    if (d > (double)ModuleLimitPublishedStreamBandwidth.this.MAXBITRATE && ModuleLimitPublishedStreamBandwidth.this.MAXBITRATE > 0) {
                        ModuleLimitPublishedStreamBandwidth.getLogger().info("Sent NetStream.Publish.Rejected to " + MonitorStream.this.stream.getClientId() + " stream name: " + MonitorStream.this.stream.getName());
                        ModuleLimitPublishedStreamBandwidth.sendStreamOnStatusError((IMediaStream)MonitorStream.this.stream, (String)"NetStream.Publish.Rejected", (String)"bitrate too high");
                        MonitorStream.this.stream.getClient().setShutdownClient(true);
                    }
                }
            };
            this.mTimer = new Timer();
        }

        public void start() {
            if (this.mTimer == null) {
                this.mTimer = new Timer();
            }
            this.mTimer.scheduleAtFixedRate(this.mTask, new Date(), (long)ModuleLimitPublishedStreamBandwidth.this.INTERVAL);
        }

        public void stop() {
            if (this.mTimer != null) {
                this.mTimer.cancel();
                this.mTimer = null;
            }
        }
    }

    class StreamListener
    implements IMediaStreamActionNotify2 {
        StreamListener() {
        }

        public void onPlay(IMediaStream iMediaStream, String string, double d, double d2, int n) {
        }

        public void onMetaData(IMediaStream iMediaStream, AMFPacket aMFPacket) {
        }

        public void onPauseRaw(IMediaStream iMediaStream, boolean bl, double d) {
        }

        public void onSeek(IMediaStream iMediaStream, double d) {
        }

        public void onStop(IMediaStream iMediaStream) {
        }

        public void onPause(IMediaStream iMediaStream, boolean bl, double d) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onUnPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
            MonitorStream monitorStream;
            WMSProperties wMSProperties;
            ModuleLimitPublishedStreamBandwidth.getLogger().info("unPublish Stream: " + iMediaStream.getName());
            WMSProperties wMSProperties2 = wMSProperties = iMediaStream.getProperties();
            synchronized (wMSProperties2) {
                monitorStream = (MonitorStream)wMSProperties.get((Object)"monitor");
            }
            if (monitorStream != null) {
                monitorStream.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
            WMSProperties wMSProperties;
            MonitorStream monitorStream = new MonitorStream(iMediaStream);
            WMSProperties wMSProperties2 = wMSProperties = iMediaStream.getProperties();
            synchronized (wMSProperties2) {
                wMSProperties.put((Object)"monitor", (Object)monitorStream);
            }
            monitorStream.start();
        }
    }
}

