/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.collection.module;

import com.wowza.util.SystemUtils;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.authentication.IAuthenticateUsernamePasswordProvider;
import com.wowza.wms.authentication.file.AuthenticationPasswordFiles;
import com.wowza.wms.client.IClient;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.util.AuthenticationUtils;
import com.wowza.wms.vhost.IVHost;
import java.io.File;
import java.util.HashMap;

public class ModuleOnConnectAuthenticate2
extends ModuleBase {
    public static final String AUTHPASSWORDFILEPATH = "${com.wowza.wms.context.VHostConfigHome}/conf/connect.password";
    private File passwordFile = null;
    private String usernamePasswordProviderClass = null;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        WMSProperties wMSProperties = iApplicationInstance.getProperties();
        String string = wMSProperties.getPropertyStr("rtmpAuthenticateFile", AUTHPASSWORDFILEPATH);
        this.usernamePasswordProviderClass = wMSProperties.getPropertyStr("usernamePasswordProviderClass", this.usernamePasswordProviderClass);
        if (string != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            IVHost iVHost = iApplicationInstance.getVHost();
            hashMap.put("com.wowza.wms.context.VHost", iVHost.getName());
            hashMap.put("com.wowza.wms.context.VHostConfigHome", iVHost.getHomePath());
            hashMap.put("com.wowza.wms.context.Application", iApplicationInstance.getApplication().getName());
            hashMap.put("com.wowza.wms.context.ApplicationInstance", iApplicationInstance.getName());
            string = SystemUtils.expandEnvironmentVariables((String)string, hashMap);
            this.passwordFile = new File(string);
        }
        if (this.passwordFile != null) {
            ModuleOnConnectAuthenticate2.getLogger().info("ModuleOnConnectAuthenticate: Authorization password file: " + this.passwordFile.getAbsolutePath());
        }
        if (this.usernamePasswordProviderClass != null) {
            ModuleOnConnectAuthenticate2.getLogger().info("ModuleOnConnectAuthenticate: Authorization password class: " + this.usernamePasswordProviderClass);
        }
    }

    public void onConnect(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        boolean bl = false;
        String string = null;
        String string2 = null;
        try {
            ModuleOnConnectAuthenticate2.getLogger().info("size: " + aMFDataList.size());
            String[] stringArray = iClient.getQueryStr().split("&");
            string = stringArray[0];
            string2 = stringArray[1];
            if (string != null && string2 != null) {
                IAuthenticateUsernamePasswordProvider iAuthenticateUsernamePasswordProvider = null;
                if (this.usernamePasswordProviderClass != null) {
                    iAuthenticateUsernamePasswordProvider = AuthenticationUtils.createUsernamePasswordProvider((String)this.usernamePasswordProviderClass);
                } else if (this.passwordFile != null) {
                    iAuthenticateUsernamePasswordProvider = AuthenticationPasswordFiles.getInstance().getPasswordFile(this.passwordFile);
                }
                if (iAuthenticateUsernamePasswordProvider != null) {
                    iAuthenticateUsernamePasswordProvider.setClient(iClient);
                    String string3 = iAuthenticateUsernamePasswordProvider.getPassword(string);
                    if (string3 != null && string3.equals(string2)) {
                        bl = true;
                    }
                }
            }
        }
        catch (Exception exception) {
            ModuleOnConnectAuthenticate2.getLogger().error("ModuleOnConnectAuthenticate.onConnect: " + exception.toString());
            bl = false;
        }
        if (!bl) {
            iClient.rejectConnection("Authentication Failed[" + iClient.getClientId() + "]: " + string);
        } else {
            iClient.acceptConnection();
        }
    }
}

