/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.collection.module;

import com.wowza.util.StringUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizerControl;

public class ModulePacketizerControl
extends ModuleBase {
    private String suffixes = "*";
    private boolean matchAllow = true;
    private boolean noMatchAllow = false;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.suffixes = iApplicationInstance.getProperties().getPropertyStr("packetizerControlSuffixes", this.suffixes);
        this.matchAllow = iApplicationInstance.getProperties().getPropertyBoolean("packetizerControlMatchAllow", this.matchAllow);
        this.noMatchAllow = iApplicationInstance.getProperties().getPropertyBoolean("packetizerControlNoMatchAllow", this.noMatchAllow);
        iApplicationInstance.setLiveStreamPacketizerControl((ILiveStreamPacketizerControl)new PacketizerControl());
    }

    private class PacketizerControl
    implements ILiveStreamPacketizerControl {
        private PacketizerControl() {
        }

        public boolean isLiveStreamPacketize(String string, IMediaStream iMediaStream) {
            String[] stringArray;
            ModulePacketizerControl.getLogger().info("PacketizerControl.isLiveStreamPacketize [" + string + " : " + iMediaStream.getName() + " : " + ModulePacketizerControl.this.suffixes + "]", iMediaStream);
            if (ModulePacketizerControl.this.suffixes.equals("*")) {
                ModulePacketizerControl.getLogger().info("PacketizerControl.isLiveStreamPacketize [" + string + " : " + iMediaStream.getName() + " :  suffixes is wildcard. returning " + ModulePacketizerControl.this.matchAllow + "]", iMediaStream);
                return ModulePacketizerControl.this.matchAllow;
            }
            if (StringUtils.isEmpty((String)ModulePacketizerControl.this.suffixes)) {
                ModulePacketizerControl.getLogger().info("PacketizerControl.isLiveStreamPacketize [" + string + " : " + iMediaStream.getName() + " : suffixes is empty. returning " + ModulePacketizerControl.this.noMatchAllow + "]", iMediaStream);
                return ModulePacketizerControl.this.noMatchAllow;
            }
            for (String string2 : stringArray = ModulePacketizerControl.this.suffixes.split(",")) {
                if (!iMediaStream.getName().endsWith(string2.trim())) continue;
                ModulePacketizerControl.getLogger().info("PacketizerControl.isLiveStreamPacketize [" + string + " : " + iMediaStream.getName() + " : match found : " + string2.trim() + " : returning " + ModulePacketizerControl.this.matchAllow + "]", iMediaStream);
                return ModulePacketizerControl.this.matchAllow;
            }
            ModulePacketizerControl.getLogger().info("PacketizerControl.isLiveStreamPacketize [" + string + " : " + iMediaStream.getName() + " : No match found : returning " + ModulePacketizerControl.this.noMatchAllow + "]", iMediaStream);
            return ModulePacketizerControl.this.noMatchAllow;
        }
    }
}

