/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.collection.oldcode;

import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.stream.publish.IStreamActionNotify;
import com.wowza.wms.stream.publish.Playlist;
import com.wowza.wms.stream.publish.PlaylistItem;
import com.wowza.wms.stream.publish.Stream;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModuleStreamPublisher
extends ModuleBase {
    Map<String, Stream> streamMap = new HashMap<String, Stream>();
    Map<String, Playlist> playlistMap = new HashMap<String, Playlist>();
    String ret = "";

    public void loadSchedule(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        ModuleStreamPublisher.getLogger().info("loadSchedule");
        Boolean bl = iClient.getAppInstance().getProperties().getPropertyBoolean("PassthruMetaData", true);
        String string = iClient.getAppInstance().getStreamStorageDir();
        try {
            NodeList nodeList;
            Object object;
            Node node;
            String string2 = string + "/streamschedule.smil";
            File file = new File(string2);
            if (!file.exists()) {
                ModuleStreamPublisher.getLogger().info("ServerListenerStreamPublisher: Could not find playlist file: " + string2);
                return;
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = null;
            Document document = null;
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
                document = documentBuilder.parse("file:///" + string2);
            }
            catch (Exception exception) {
                ModuleStreamPublisher.getLogger().info("ServerListenerStreamPublisher: XML Parse failed");
                this.ret = "ServerListenerStreamPublisher: XML Parse failed";
                return;
            }
            document.getDocumentElement().normalize();
            NodeList nodeList2 = document.getElementsByTagName("stream");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node2 = nodeList2.item(i);
                if (node2.getNodeType() != 1) continue;
                node = (Element)node2;
                object = node.getAttribute("name");
                ModuleStreamPublisher.getLogger().info("ServerListenerStreamPublisher: Stream name is '" + (String)object + "'");
                nodeList = Stream.createInstance((IApplicationInstance)iClient.getAppInstance(), (String)object);
                this.streamMap.put((String)object, (Stream)nodeList);
                iClient.getAppInstance().getProperties().setProperty((String)object, (Object)nodeList);
            }
            NodeList nodeList3 = document.getElementsByTagName("playlist");
            if (nodeList3.getLength() == 0) {
                ModuleStreamPublisher.getLogger().info("ServerListenerStreamPublisher: No playlists defined in smil file");
                return;
            }
            for (int i = 0; i < nodeList3.getLength(); ++i) {
                Object object2;
                Object object3;
                String string3;
                Object object4;
                Object object5;
                node = nodeList3.item(i);
                if (node.getNodeType() != 1) continue;
                object = (Element)node;
                nodeList = object.getElementsByTagName("video");
                if (nodeList.getLength() == 0) {
                    ModuleStreamPublisher.getLogger().info("ServerListenerStreamPublisher: No videos defined in stream");
                    return;
                }
                String string4 = object.getAttribute("playOnStream");
                if (string4.length() == 0) continue;
                Playlist playlist = new Playlist(string4);
                playlist.setRepeat(!object.getAttribute("repeat").equals("false"));
                this.playlistMap.put(object.getAttribute("name"), playlist);
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    object5 = nodeList.item(j);
                    if (object5.getNodeType() != 1) continue;
                    object4 = (Element)object5;
                    string3 = object4.getAttribute("src");
                    object3 = Integer.parseInt(object4.getAttribute("start"));
                    object2 = Integer.parseInt(object4.getAttribute("length"));
                    playlist.addItem(string3, ((Integer)object3).intValue(), ((Integer)object2).intValue());
                }
                String string5 = object.getAttribute("scheduled");
                object5 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                object4 = null;
                try {
                    object4 = ((DateFormat)object5).parse(string5);
                }
                catch (Exception exception) {
                    ModuleStreamPublisher.getLogger().info("Parsing schedule time failed.");
                    return;
                }
                string3 = this.streamMap.get(string4);
                string3.setSendOnMetadata(bl.booleanValue());
                object3 = new ScheduledItem((Date)object4, playlist, (Stream)string3);
                ((ScheduledItem)object3).start();
                object2 = new StreamListener(iClient.getAppInstance());
                string3.addListener((IStreamActionNotify)object2);
                ModuleStreamPublisher.getLogger().info("ServerListenerStreamPublisher Scheduled: " + string3.getName() + " for: " + string5);
            }
        }
        catch (Exception exception) {
            ModuleStreamPublisher.getLogger().info("ServerListenerStreamPublisher: Error from playlist manager is '" + exception.getMessage() + "'");
        }
        if (this.ret == "") {
            this.ret = "DONE!";
        }
        ModuleStreamPublisher.sendResult((IClient)iClient, (AMFDataList)aMFDataList, (String)this.ret);
    }

    class StreamListener
    implements IStreamActionNotify {
        StreamListener(IApplicationInstance iApplicationInstance) {
        }

        public void onPlaylistItemStop(Stream stream, PlaylistItem playlistItem) {
            if (playlistItem.getIndex() == stream.getPlaylist().size() - 1 && !stream.getRepeat()) {
                stream.close();
                WMSLoggerFactory.getLogger(null).info("ServerListenerStreamPublisher: closing stream: " + stream.getName());
            }
        }

        public void onPlaylistItemStart(Stream stream, PlaylistItem playlistItem) {
            try {
                String string = stream.getCurrentItem().getName();
                WMSLoggerFactory.getLogger(null).info("ServerListenerStreamPublisher PlayList Item Start: " + string);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(null).info("ServerListenerStreamPublisher Get Item error: " + exception.getMessage());
            }
        }
    }

    private class ScheduledItem {
        public Timer mTimer;
        public TimerTask mTask;
        public Date mStart;
        public Playlist mPL;
        public Stream mStream;

        public ScheduledItem(Date date, Playlist playlist, Stream stream) {
            this.mStart = date;
            this.mPL = playlist;
            this.mStream = stream;
            this.mTask = new TimerTask(){

                public void run() {
                    ScheduledItem.this.mPL.open(ScheduledItem.this.mStream);
                    ModuleStreamPublisher.getLogger().info("ServerListenerStreamPublisher Scheduled stream is now live: " + ScheduledItem.this.mStream.getName());
                }
            };
            this.mTimer = new Timer();
        }

        public void start() {
            if (this.mTimer == null) {
                this.mTimer = new Timer();
            }
            this.mTimer.schedule(this.mTask, this.mStart);
            ModuleStreamPublisher.getLogger().info("scheduled playlist: " + this.mPL.getName() + " on stream: " + this.mStream.getName() + " for:" + this.mStart.toString());
        }

        public void stop() {
            if (this.mTimer != null) {
                this.mTimer.cancel();
                this.mTimer = null;
                ModuleStreamPublisher.getLogger().info("cancelled playlist: " + this.mPL.getName() + " on stream: " + this.mStream.getName() + " for:" + this.mStart.toString());
            }
        }
    }
}

