/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.collection.serverlistener;

import com.wowza.util.StringUtils;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.IApplicationInstanceNotify;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.IServerNotify2;
import com.wowza.wms.server.Server;
import com.wowza.wms.stream.publish.IStreamActionNotify;
import com.wowza.wms.stream.publish.Playlist;
import com.wowza.wms.stream.publish.PlaylistItem;
import com.wowza.wms.stream.publish.Stream;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServerListenerStreamPublisher
implements IServerNotify2 {
    public static final String PROP_STREAMPUBLISHER = "serverListenerStreamPublisher";
    private WMSLogger log = WMSLoggerFactory.getLogger(null);
    private Object lock = new Object();

    public void onServerCreate(IServer iServer) {
        iServer.getProperties().setProperty(PROP_STREAMPUBLISHER, (Object)this);
    }

    public void onServerInit(IServer iServer) {
        this.log.info("ServerListenerStreamPublisher Started.");
        IVHost iVHost = null;
        IApplication iApplication = null;
        IApplicationInstance iApplicationInstance = null;
        String string = iServer.getProperties().getPropertyStr("PublishToVHost", "_defaultVHost_");
        string = iServer.getProperties().getPropertyStr("streamPublisherVHost", string);
        if (StringUtils.isEmpty((String)string)) {
            this.log.info("ServerListenerStreamPublisher: publishToVHost is empty. Can not run.");
            return;
        }
        try {
            iVHost = VHostSingleton.getInstance((String)string);
        }
        catch (Exception exception) {
            this.log.info("ServerListenerStreamPublisher: Failed to get Vhost can not run.");
            return;
        }
        String string2 = iServer.getProperties().getPropertyStr("PublishToApplication", "live/_definst_");
        string2 = iServer.getProperties().getPropertyStr("streamPublisherApplication", string2);
        if (StringUtils.isEmpty((String)string2)) {
            this.log.info("ServerListenerStreamPublisher: publishToApplication empty. Can not run.");
            return;
        }
        String[] stringArray = string2.split("/");
        String string3 = stringArray[0];
        String string4 = stringArray.length > 1 ? stringArray[1] : "_definst_";
        try {
            iApplication = iVHost.getApplication(string3);
        }
        catch (Exception exception) {
            this.log.info("ServerListenerStreamPublisher: Failed to get Application can not run.");
            return;
        }
        AppInstanceListener appInstanceListener = (AppInstanceListener)iApplication.getProperties().get((Object)"streamPublisherAppInstanceListener");
        if (appInstanceListener == null) {
            appInstanceListener = new AppInstanceListener();
            iApplication.addApplicationInstanceListener((IApplicationInstanceNotify)appInstanceListener);
            iApplication.getProperties().setProperty("streamPublisherAppInstanceListener", (Object)appInstanceListener);
        }
        try {
            iApplicationInstance = iApplication.getAppInstance(string4);
        }
        catch (Exception exception) {
            this.log.info("ServerListenerStreamPublisher: Failed to get Application Instance can not run.");
            return;
        }
        if (iApplicationInstance.getProperties().getPropertyBoolean("streamPublisherScheduleLoaded", false)) {
            this.log.info("ServerListenerStreamPublisher: Schedule loaded by module.");
        } else {
            String string5 = this.loadSchedule(iApplicationInstance);
            this.log.info("ServerListenerStreamPublisher: " + string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadSchedule(IApplicationInstance iApplicationInstance) {
        WMSProperties wMSProperties = Server.getInstance().getProperties();
        WMSProperties wMSProperties2 = iApplicationInstance.getProperties();
        String string = "";
        Object object = this.lock;
        synchronized (object) {
            boolean bl = wMSProperties.getPropertyBoolean("streamPublisherSwitchLog", true);
            bl = wMSProperties2.getPropertyBoolean("streamPublisherSwitchLog", bl);
            boolean bl2 = wMSProperties.getPropertyBoolean("PassthruMetaData", true);
            bl2 = wMSProperties.getPropertyBoolean("streamPublisherPassMetaData", bl2);
            bl2 = wMSProperties2.getPropertyBoolean("PassthruMetaData", bl2);
            bl2 = wMSProperties2.getPropertyBoolean("streamPublisherPassMetaData", bl2);
            String string2 = wMSProperties.getPropertyStr("streamPublisherSmilFile", "streamschedule.smil");
            string2 = wMSProperties2.getPropertyStr("streamPublisherSmilFile", string2);
            String string3 = iApplicationInstance.getStreamStorageDir();
            try {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                String string4 = string3 + "/" + string2.replace("..", "");
                File file = new File(string4);
                if (!file.exists()) {
                    return "Could not find playlist file: " + string4;
                }
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = null;
                Document document = null;
                try {
                    documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    document = documentBuilder.parse("file:///" + string4);
                }
                catch (Exception exception) {
                    return "XML Parse failed";
                }
                document.getDocumentElement().normalize();
                NodeList nodeList = document.getElementsByTagName("stream");
                HashMap<Object, Object> hashMap = (HashMap<Object, Object>)wMSProperties2.getProperty("streamPublisherStreams");
                if (hashMap == null) {
                    hashMap = new HashMap<Object, Object>();
                    wMSProperties2.setProperty("streamPublisherStreams", hashMap);
                }
                HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
                hashMap2.putAll(hashMap);
                hashMap.clear();
                HashMap hashMap3 = (HashMap)wMSProperties2.getProperty("streamPublisherSchedules");
                if (hashMap3 == null) {
                    hashMap3 = new HashMap();
                    wMSProperties2.setProperty("streamPublisherSchedules", hashMap3);
                }
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    object5 = (Element)node;
                    object4 = object5.getAttribute("name");
                    this.log.info("ServerListenerStreamPublisher: Stream name is '" + (String)object4 + "'");
                    object3 = (Stream)hashMap2.get(object4);
                    if (object3 == null) {
                        object3 = Stream.createInstance((IApplicationInstance)iApplicationInstance, (String)object4);
                        if (object3 == null) {
                            this.log.error("ServerListenerStreamPublisher cannot create stream: " + (String)object4);
                            continue;
                        }
                        object2 = (IStreamActionNotify)wMSProperties2.get((Object)"streamPublisherStreamListener");
                        if (object2 == null) {
                            object2 = new StreamListener(iApplicationInstance);
                            wMSProperties2.setProperty("streamPublisherStreamListener", object2);
                        }
                        object3.addListener((IStreamActionNotify)object2);
                    }
                    hashMap2.remove(object4);
                    hashMap.put(object4, object3);
                    wMSProperties2.setProperty((String)object4, object3);
                }
                for (Node node : hashMap2.values()) {
                    this.shutdownStream(iApplicationInstance, (Stream)node);
                }
                hashMap2.clear();
                for (Node node : hashMap.values()) {
                    object5 = (List)hashMap3.remove(node.getName());
                    if (object5 == null) continue;
                    object4 = object5.iterator();
                    while (object4.hasNext()) {
                        object3 = (ScheduledItem)object4.next();
                        ((ScheduledItem)object3).stop();
                    }
                    object5.clear();
                }
                NodeList nodeList2 = document.getElementsByTagName("playlist");
                if (nodeList2.getLength() == 0) {
                    return "No playlists defined in smil file";
                }
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    Object object6;
                    List<Object> list;
                    String string5;
                    Object object7;
                    Object object8;
                    object5 = nodeList2.item(i);
                    if (object5.getNodeType() != 1) continue;
                    object4 = (Element)object5;
                    object3 = object4.getElementsByTagName("video");
                    if (object3.getLength() == 0) {
                        return "No videos defined in stream";
                    }
                    object2 = object4.getAttribute("playOnStream");
                    if (((String)object2).length() == 0) continue;
                    Playlist playlist = new Playlist((String)object2);
                    playlist.setRepeat(!object4.getAttribute("repeat").equals("false"));
                    for (int j = 0; j < object3.getLength(); ++j) {
                        object8 = object3.item(j);
                        if (object8.getNodeType() != 1) continue;
                        object7 = (Element)object8;
                        string5 = object7.getAttribute("src");
                        list = Integer.parseInt(object7.getAttribute("start"));
                        object6 = Integer.parseInt(object7.getAttribute("length"));
                        playlist.addItem(string5, ((Integer)((Object)list)).intValue(), ((Integer)object6).intValue());
                    }
                    String string6 = object4.getAttribute("scheduled");
                    object8 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    object7 = null;
                    try {
                        object7 = ((DateFormat)object8).parse(string6);
                    }
                    catch (Exception exception) {
                        return "Parsing schedule time failed.";
                    }
                    string5 = (Stream)hashMap.get(object2);
                    if (string5 == null) {
                        this.log.warn("ServerListenerStreamPublisher Stream does not exist for playlist: " + object4.getAttribute("name") + " : " + (String)object2);
                        continue;
                    }
                    list = (List)hashMap3.get(object2);
                    if (list == null) {
                        list = new ArrayList<Object>();
                        hashMap3.put(object2, list);
                    }
                    string5.setSendOnMetadata(bl2);
                    string5.setSwitchLog(bl);
                    object6 = new ScheduledItem(iApplicationInstance, (Date)object7, playlist, (Stream)string5);
                    ((ScheduledItem)object6).start();
                    list.add(object6);
                    this.log.info("ServerListenerStreamPublisher Scheduled: " + string5.getName() + " for: " + string6);
                }
            }
            catch (Exception exception) {
                return "Error from playlist manager is '" + exception.getMessage() + "'";
            }
            return "DONE!";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownStream(IApplicationInstance iApplicationInstance, Stream stream) {
        if (stream == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            List list;
            WMSProperties wMSProperties = iApplicationInstance.getProperties();
            Map map = (Map)wMSProperties.get((Object)"streamPublisherSchedules");
            if (map != null && (list = (List)map.remove(stream.getName())) != null) {
                for (ScheduledItem scheduledItem : list) {
                    scheduledItem.stop();
                }
            }
            wMSProperties.remove((Object)stream.getName());
            stream.closeAndWait();
            list = stream.getPublisher();
            if (list != null) {
                list.unpublish();
                list.close();
            }
            this.log.info("ServerListenerStreamPublisher: Stream shut down : " + stream.getName());
        }
    }

    public void onServerShutdownComplete(IServer iServer) {
    }

    public void onServerShutdownStart(IServer iServer) {
    }

    public void onServerConfigLoaded(IServer iServer) {
    }

    private class AppInstanceListener
    implements IApplicationInstanceNotify {
        private AppInstanceListener() {
        }

        public void onApplicationInstanceCreate(IApplicationInstance iApplicationInstance) {
        }

        public void onApplicationInstanceDestroy(IApplicationInstance iApplicationInstance) {
            WMSProperties wMSProperties = iApplicationInstance.getProperties();
            Map map = (Map)wMSProperties.remove((Object)"streamPublisherStreams");
            if (map != null) {
                for (Stream stream : map.values()) {
                    ServerListenerStreamPublisher.this.shutdownStream(iApplicationInstance, stream);
                }
            }
        }
    }

    private class StreamListener
    implements IStreamActionNotify {
        private IApplicationInstance appInstance;

        StreamListener(IApplicationInstance iApplicationInstance) {
            this.appInstance = iApplicationInstance;
        }

        public void onPlaylistItemStart(Stream stream, PlaylistItem playlistItem) {
            try {
                String string = playlistItem.getName();
                this.appInstance.broadcastMsg("PlaylistItemStart", new Object[]{string});
                if (stream.isSwitchLog()) {
                    WMSLoggerFactory.getLogger(null).info("ServerListenerStreamPublisher PlayList Item Start: " + string);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(null).info("ServerListenerStreamPublisher Get Item error: " + exception.getMessage());
            }
        }

        public void onPlaylistItemStop(Stream stream, PlaylistItem playlistItem) {
            if (stream.getPlaylist().contains(playlistItem) && playlistItem.getIndex() == stream.getPlaylist().size() - 1 && !stream.getRepeat()) {
                Map map = (Map)this.appInstance.getProperties().get((Object)"streamPublisherStreams");
                if (map != null) {
                    map.remove(stream.getName());
                }
                ServerListenerStreamPublisher.this.shutdownStream(this.appInstance, stream);
                WMSLoggerFactory.getLogger(null).info("ServerListenerStreamPublisher: closing stream: " + stream.getName());
            }
        }
    }

    private class ScheduledItem {
        private IApplicationInstance appInstance;
        private Timer timer;
        private Date start;
        private Playlist playlist;
        private Stream stream;

        public ScheduledItem(IApplicationInstance iApplicationInstance, Date date, Playlist playlist, Stream stream) {
            this.appInstance = iApplicationInstance;
            this.start = date;
            this.playlist = playlist;
            this.stream = stream;
            this.timer = new Timer();
        }

        public void start() {
            this.timer.schedule(new TimerTask(){

                public void run() {
                    ScheduledItem.this.playlist.open(ScheduledItem.this.stream);
                    ServerListenerStreamPublisher.this.log.info("ServerListenerStreamPublisher Scheduled stream is now live: " + ScheduledItem.this.stream.getName());
                    ScheduledItem.this.removeFromList();
                    ScheduledItem.this.timer = null;
                }
            }, this.start);
            ServerListenerStreamPublisher.this.log.info("scheduled playlist: " + this.playlist.getName() + " on stream: " + this.stream.getName() + " for:" + this.start.toString());
        }

        public void stop() {
            if (this.timer != null) {
                this.timer.cancel();
                ServerListenerStreamPublisher.this.log.info("cancelled playlist: " + this.playlist.getName() + " on stream: " + this.stream.getName() + " for:" + this.start.toString());
                this.removeFromList();
                this.timer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeFromList() {
            Object object = ServerListenerStreamPublisher.this.lock;
            synchronized (object) {
                List list;
                Map map = (Map)this.appInstance.getProperties().get((Object)"streamPublisherSchedules");
                if (map != null && (list = (List)map.get(this.stream.getName())) != null) {
                    list.remove(this);
                }
            }
        }
    }
}

