/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.publish;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.publish.IPublishingProvider;
import com.wowza.wms.stream.publish.IStreamActionNotify;
import com.wowza.wms.stream.publish.PlaylistItem;
import com.wowza.wms.stream.publish.Publisher;
import com.wowza.wms.stream.publish.PublishingProviderBase;
import com.wowza.wms.stream.publish.PublishingProviderLive;
import com.wowza.wms.stream.publish.PublishingProviderMediaReader;
import com.wowza.wms.vhost.IVHost;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stream
implements Runnable {
    private boolean switchLog = true;
    private Publisher mPub = null;
    private IPublishingProvider mProv = null;
    private String mName = null;
    private boolean mDone = false;
    private Thread mThread = null;
    private List<PlaylistItem> mList = new ArrayList<PlaylistItem>();
    private PlaylistItem mCurrItem = null;
    private PlaylistItem mSwitchToItem = null;
    private boolean mRepeat = true;
    private int pollingInterval = 75;
    private Object lock = new Object();
    private List<IStreamActionNotify> listeners = new ArrayList<IStreamActionNotify>();
    private boolean doStartPlay = true;
    private boolean sendOnMetadata = false;

    public static Stream createInstance(IVHost iVHost, String string, String string2) {
        return Stream.createInstance(iVHost, string, "_definst_", string2);
    }

    public static Stream createInstance(IVHost iVHost, String string, String string2, String string3) {
        Stream stream = null;
        Publisher publisher = Publisher.createInstance(iVHost, string, string2);
        if (publisher != null) {
            stream = new Stream();
            stream.init(publisher, string3);
        }
        return stream;
    }

    public Object getLock() {
        return this.lock;
    }

    public static Stream createInstance(IApplicationInstance iApplicationInstance, String string) {
        Stream stream = null;
        Publisher publisher = Publisher.createInstance(iApplicationInstance);
        if (publisher != null) {
            stream = new Stream();
            stream.init(publisher, string);
        }
        return stream;
    }

    private void init(Publisher publisher, String string) {
        this.pollingInterval = publisher.getAppInstance().getStreamProperties().getPropertyInt("streamSwitchPI", this.pollingInterval);
        this.mName = string;
        this.mPub = publisher;
        this.mPub.publish(this.mName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Publisher publisher;
        Object object;
        Object object2;
        try {
            while (true) {
                object2 = null;
                boolean bl = false;
                object = null;
                Object object3 = this.lock;
                synchronized (object3) {
                    bl = true;
                    if (this.mSwitchToItem != null) {
                        object2 = this.mSwitchToItem;
                        object = this.mCurrItem;
                        this.mCurrItem = object2;
                        this.mSwitchToItem = null;
                    } else if (this.mCurrItem == null) {
                        if (this.mList.size() > 0) {
                            if (this.doStartPlay || this.mRepeat) {
                                object2 = this.mList.get(0);
                                object = this.mCurrItem;
                                this.mCurrItem = object2;
                            } else {
                                bl = false;
                            }
                        } else {
                            bl = false;
                        }
                    }
                }
                if (object != null) {
                    this.notifyPlaylistItemStop((PlaylistItem)object);
                }
                if (bl) {
                    if (object2 != null) {
                        this._switchItem((PlaylistItem)object2);
                    }
                } else {
                    Thread.sleep(this.pollingInterval);
                    continue;
                }
                this.doStartPlay = false;
                object2 = null;
                publisher = null;
                object = this.lock;
                synchronized (object) {
                    if (this.mDone) {
                        break;
                    }
                    object2 = this.mProv;
                    publisher = this.mPub;
                }
                if (publisher != null && object2 != null) {
                    boolean bl2 = object2.play(publisher);
                    if (!bl2) {
                        object3 = null;
                        PlaylistItem playlistItem = null;
                        Object object4 = this.lock;
                        synchronized (object4) {
                            if (this.mCurrItem != null) {
                                int n = this.mCurrItem.getIndex() + 1;
                                if (n >= this.mList.size()) {
                                    if (this.mList.size() > 0 && this.mRepeat) {
                                        object3 = this.mList.get(0);
                                        playlistItem = this.mCurrItem;
                                        this.mCurrItem = object3;
                                    } else {
                                        playlistItem = this.mCurrItem;
                                        this.mCurrItem = null;
                                    }
                                } else {
                                    object3 = this.mList.get(n);
                                    playlistItem = this.mCurrItem;
                                    this.mCurrItem = object3;
                                }
                            }
                        }
                        if (playlistItem != null) {
                            this.notifyPlaylistItemStop(playlistItem);
                        }
                        if (object3 == null) continue;
                        this._switchItem((PlaylistItem)object3);
                        continue;
                    }
                    Thread.sleep(this.pollingInterval);
                    continue;
                }
                Thread.sleep(this.pollingInterval);
            }
        }
        catch (InterruptedException interruptedException) {
            this.mDone = true;
        }
        object2 = null;
        publisher = null;
        object = this.lock;
        synchronized (object) {
            object2 = this.mProv;
            publisher = this.mPub;
            this.mList.clear();
            this.mProv = null;
            this.mPub = null;
            this.mList = null;
        }
        if (object2 != null) {
            object2.close();
        }
        if (publisher != null) {
            publisher.publish(null);
            publisher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PlaylistItem> getPlaylist() {
        ArrayList<PlaylistItem> arrayList = new ArrayList<PlaylistItem>();
        Object object = this.lock;
        synchronized (object) {
            arrayList.addAll(this.mList);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlaylistItem getCurrentItem() {
        Object object = this.lock;
        synchronized (object) {
            return this.mCurrItem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean play(String string, int n, int n2, boolean bl) {
        boolean bl2 = false;
        PlaylistItem playlistItem = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.mDone) {
                return false;
            }
            if (bl) {
                this.mList.clear();
                playlistItem = this.mCurrItem;
                this.mCurrItem = null;
                this.doStartPlay = true;
            }
            int n3 = this.mList.size();
            this.mList.add(new PlaylistItem(string, n, n2, n3));
            if (this.mThread == null) {
                this.mThread = new Thread(this);
                bl2 = true;
            }
        }
        if (playlistItem != null) {
            this.notifyPlaylistItemStop(playlistItem);
        }
        if (bl2) {
            this.mThread.start();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToPlaylist(int n, String string, int n2, int n3) {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.mDone) {
                return false;
            }
            if (n < 0) {
                n = 0;
            } else if (n > this.mList.size()) {
                n = this.mList.size();
            }
            this.mList.add(n, new PlaylistItem(string, n2, n3, n));
            int n4 = this.mList.size();
            for (int i = n; i < n4; ++i) {
                this.mList.get(i).setIndex(i);
            }
            if (this.mThread == null) {
                this.mThread = new Thread(this);
                bl = true;
            }
        }
        if (bl) {
            this.mThread.start();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToPlaylist(String string, String string2, int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        Object object = this.lock;
        synchronized (object) {
            PlaylistItem playlistItem;
            int n3;
            int n4 = this.mList.size();
            for (n3 = 0; n3 < n4 && !(playlistItem = this.mList.get(n3)).getName().equals(string2); ++n3) {
            }
            if (n3 < n4) {
                this.mList.add(++n3, new PlaylistItem(string2, n, n2, n3));
                bl2 = true;
                for (int i = n3; i < n4; ++i) {
                    this.mList.get(i).setIndex(i);
                }
                if (this.mThread == null) {
                    this.mThread = new Thread(this);
                    bl = true;
                }
            }
        }
        if (bl) {
            this.mThread.start();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFromPlaylist(String string) {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            int n = this.mCurrItem == null ? -1 : this.mCurrItem.getIndex();
            int n2 = this.mSwitchToItem == null ? -1 : this.mSwitchToItem.getIndex();
            int n3 = 0;
            for (int i = 0; i < this.mList.size(); ++i) {
                PlaylistItem playlistItem = this.mList.get(i);
                if (playlistItem.getName().equals(string)) {
                    if (i == n || i == n2) {
                        WMSLoggerFactory.getLogger(Stream.class).error("Stream.removeFromPlaylist: Cannot remove currently playing item from the list[" + i + "]: " + string);
                        playlistItem.setIndex(n3);
                        ++n3;
                        continue;
                    }
                    this.mList.remove(i);
                    bl = true;
                    continue;
                }
                playlistItem.setIndex(n3);
                ++n3;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean play(String string) {
        try {
            Object object;
            File file = new File(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            Element element = document.getDocumentElement();
            String string2 = element.getAttribute("repeat");
            if (string2.length() > 0) {
                object = this.lock;
                synchronized (object) {
                    if (string2.equalsIgnoreCase("yes")) {
                        this.mRepeat = true;
                    } else if (string2.equalsIgnoreCase("no")) {
                        this.mRepeat = false;
                    }
                }
            }
            if ((object = document.getElementsByTagName("file")).getLength() == 0) {
                return false;
            }
            for (int i = 0; i < object.getLength(); ++i) {
                Node node = object.item(i);
                if (node.getNodeType() != 1) continue;
                Element element2 = (Element)node;
                String string3 = element2.getAttribute("name");
                String string4 = element2.getAttribute("start");
                String string5 = element2.getAttribute("length");
                if (this.play(string3, string4.length() > 0 ? Integer.parseInt(string4) : 0, string5.length() > 0 ? Integer.parseInt(string5) : -1, i == 0)) continue;
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.mDone = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        Object object = this.lock;
        synchronized (object) {
            return this.mName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getRepeat() {
        Object object = this.lock;
        synchronized (object) {
            return this.mRepeat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRepeat(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.mRepeat = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(int n) {
        PlaylistItem playlistItem = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.mDone) {
                return;
            }
            int n2 = n % this.mList.size();
            if (n2 >= 0 && n2 < this.mList.size()) {
                this.mSwitchToItem = playlistItem = this.mList.get(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void next(int n) {
        PlaylistItem playlistItem = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.mDone) {
                return;
            }
            int n2 = 0;
            n2 = this.mCurrItem != null ? (this.mCurrItem.getIndex() + n) % this.mList.size() : 0;
            if (n2 >= 0 && n2 < this.mList.size()) {
                this.mSwitchToItem = playlistItem = this.mList.get(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void next() {
        PlaylistItem playlistItem = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.mDone) {
                return;
            }
            int n = 0;
            n = this.mCurrItem != null ? (this.mCurrItem.getIndex() + 1) % this.mList.size() : 0;
            if (n >= 0 && n < this.mList.size()) {
                this.mSwitchToItem = playlistItem = this.mList.get(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void previous() {
        PlaylistItem playlistItem = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.mDone) {
                return;
            }
            int n = 0;
            if (this.mCurrItem != null) {
                n = this.mCurrItem.getIndex() - 1;
                if (n < 0) {
                    n = this.mList.size() - 1;
                }
            } else {
                n = this.mList.size() - 1;
            }
            if (n >= 0 && n < this.mList.size()) {
                this.mSwitchToItem = playlistItem = this.mList.get(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void previous(int n) {
        PlaylistItem playlistItem = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.mDone) {
                return;
            }
            int n2 = 0;
            if (this.mCurrItem != null) {
                n2 = this.mCurrItem.getIndex() - n;
                if (n2 < 0) {
                    n2 = this.mList.size() - 1;
                }
            } else {
                n2 = this.mList.size() - 1;
            }
            if (n2 >= 0 && n2 < this.mList.size()) {
                this.mSwitchToItem = playlistItem = this.mList.get(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _switchItem(PlaylistItem playlistItem) {
        Object object;
        long l = System.currentTimeMillis();
        PublishingProviderBase publishingProviderBase = null;
        Publisher publisher = null;
        Object object2 = this.lock;
        synchronized (object2) {
            publisher = this.mPub;
        }
        if (publisher != null && playlistItem != null) {
            object2 = publisher.getAppInstance().getContextStr() + "/" + this.mName;
            object = playlistItem.getName();
            int n = playlistItem.getStart();
            int n2 = playlistItem.getLength();
            int n3 = playlistItem.getIndex();
            if (n <= -2) {
                if (this.switchLog) {
                    WMSLoggerFactory.getLogger(Stream.class).info("Stream.switch[" + (String)object2 + "]: index: " + n3 + " name:" + (String)object + " start:" + n + " length:" + n2);
                }
                publishingProviderBase = new PublishingProviderLive(publisher, publisher.getMaxTimecode(), playlistItem.getName());
                publishingProviderBase.setSendOnMetadata(this.sendOnMetadata);
                publishingProviderBase.setRealTimeStartTime(l);
                if (n2 > 0) {
                    publishingProviderBase.setDuration(n2 * 1000);
                }
            } else if (n == -1) {
                if (this.switchLog) {
                    WMSLoggerFactory.getLogger(Stream.class).info("Stream.switch[" + (String)object2 + "]: index: " + n3 + " name:" + (String)object + " start:" + n + " length:" + n2);
                }
                publishingProviderBase = new PublishingProviderMediaReader(publisher, publisher.getMaxTimecode(), playlistItem.getName());
                publishingProviderBase.setSendOnMetadata(this.sendOnMetadata);
                publishingProviderBase.setRealTimeStartTime(l);
                if (n2 > 0) {
                    publishingProviderBase.setDuration(n2 * 1000);
                }
            } else {
                if (this.switchLog) {
                    WMSLoggerFactory.getLogger(Stream.class).info("Stream.switch[" + (String)object2 + "]: index: " + n3 + " name:" + (String)object + " start:" + n + " length:" + n2);
                }
                publishingProviderBase = new PublishingProviderMediaReader(publisher, publisher.getMaxTimecode(), playlistItem.getName());
                publishingProviderBase.setSendOnMetadata(this.sendOnMetadata);
                publishingProviderBase.setRealTimeStartTime(l);
                if (n > 0) {
                    publishingProviderBase.seek(n * 1000);
                }
                if (n2 > 0) {
                    publishingProviderBase.setDuration(n2 * 1000);
                }
            }
        }
        object2 = null;
        object = this.lock;
        synchronized (object) {
            object2 = this.mProv;
            this.mProv = publishingProviderBase;
        }
        if (object2 != null) {
            object2.close();
        }
        this.notifyPlaylistItemStart(playlistItem);
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(int n) {
        this.pollingInterval = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Publisher getPublisher() {
        Object object = this.lock;
        synchronized (object) {
            return this.mPub;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IStreamActionNotify iStreamActionNotify) {
        List<IStreamActionNotify> list = this.listeners;
        synchronized (list) {
            this.listeners.add(iStreamActionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IStreamActionNotify iStreamActionNotify) {
        List<IStreamActionNotify> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(iStreamActionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPlaylistItemStart(PlaylistItem playlistItem) {
        ArrayList<IStreamActionNotify> arrayList = new ArrayList<IStreamActionNotify>();
        List<IStreamActionNotify> list = this.listeners;
        synchronized (list) {
            arrayList.addAll(this.listeners);
        }
        for (IStreamActionNotify iStreamActionNotify : arrayList) {
            iStreamActionNotify.onPlaylistItemStart(this, playlistItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPlaylistItemStop(PlaylistItem playlistItem) {
        ArrayList<IStreamActionNotify> arrayList = new ArrayList<IStreamActionNotify>();
        List<IStreamActionNotify> list = this.listeners;
        synchronized (list) {
            arrayList.addAll(this.listeners);
        }
        for (IStreamActionNotify iStreamActionNotify : arrayList) {
            iStreamActionNotify.onPlaylistItemStop(this, playlistItem);
        }
    }

    public boolean isSwitchLog() {
        return this.switchLog;
    }

    public void setSwitchLog(boolean bl) {
        this.switchLog = bl;
    }

    public boolean isSendOnMetadata() {
        return this.sendOnMetadata;
    }

    public void setSendOnMetadata(boolean bl) {
        this.sendOnMetadata = bl;
    }
}

