/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.io;

import com.wowza.io.IRandomAccessReader;
import com.wowza.io.ITrackRandomAccessReaderPerformance;
import com.wowza.io.WowzaRandomAccessFile;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DirectRandomAccessReader
implements IRandomAccessReader,
ITrackRandomAccessReaderPerformance {
    private String basePath = "";
    private String mediaName = "";
    private String mediaExtension = "";
    private String fullPath = "";
    private File file = null;
    private RandomAccessFile randomFile = null;
    private Object randomFileLock = new Object();
    private int direction = 1;
    private boolean sentSeekError = false;
    private IOPerformanceCounter streamIOPerformanceCounter = null;
    private IOPerformanceCounter clientIOPerformanceCounter = null;

    public void init(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2, String string3) {
        this.basePath = string;
        this.mediaName = string2;
        this.mediaExtension = string3;
        this.file = iMediaStream.getStreamFileForRead(string2, string3, iMediaStream.getQueryStr());
        this.fullPath = this.file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFilePointer() {
        try {
            Object object = this.randomFileLock;
            synchronized (object) {
                if (this.randomFile != null) {
                    return this.randomFile.getFilePointer();
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(DirectRandomAccessReader.class).error("getFilePointer: " + exception.toString());
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seek(long l) {
        block9: {
            try {
                if (l < 0L) {
                    l = 0L;
                }
                Object object = this.randomFileLock;
                synchronized (object) {
                    if (this.randomFile != null) {
                        this.randomFile.seek(l);
                    }
                }
            }
            catch (Exception exception) {
                if (this.sentSeekError) break block9;
                String string = "unknown";
                Exception exception2 = exception;
                if (exception2 != null) {
                    StackTraceElement[] stackTraceElementArray = exception2.getStackTrace();
                    if (stackTraceElementArray != null && stackTraceElementArray.length > 0) {
                        string = stackTraceElementArray[0].getClassName() + "." + stackTraceElementArray[0].getMethodName() + "(" + stackTraceElementArray[0].getFileName() + ":" + stackTraceElementArray[0].getLineNumber() + ")";
                    }
                    string = exception2.toString() + " (" + string + ")";
                }
                WMSLoggerFactory.getLogger(DirectRandomAccessReader.class).error("DirectRandomAccessReader.seek[" + this.mediaName + "," + string + "]: " + exception.toString());
                exception.printStackTrace();
                this.sentSeekError = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n, int n2) {
        try {
            int n3;
            long l = 0L;
            long l2 = 0L;
            Object object = this.randomFileLock;
            synchronized (object) {
                if (this.randomFile != null) {
                    l = this.randomFile.getFilePointer();
                    l2 = this.randomFile.length();
                }
            }
            if (l2 <= 0L) {
                return 0;
            }
            int n4 = 0;
            int n5 = n2;
            do {
                n3 = 0;
                Object object2 = this.randomFileLock;
                synchronized (object2) {
                    if (this.randomFile != null) {
                        n3 = this.randomFile.read(byArray, n + n4, n5);
                    }
                }
            } while (n3 > 0 && (n5 -= n3) > 0 && l + (long)(n4 += n3) < l2);
            if (this.streamIOPerformanceCounter != null) {
                this.streamIOPerformanceCounter.incrementFileIn(n4);
            }
            if (this.clientIOPerformanceCounter != null) {
                this.clientIOPerformanceCounter.incrementFileIn(n4);
            }
            return n4;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(DirectRandomAccessReader.class).error("DirectRandomAccessReader.read: " + exception.toString());
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        Object object = this.randomFileLock;
        synchronized (object) {
            if (this.randomFile != null) {
                this.close();
            }
            this.randomFile = new WowzaRandomAccessFile(new File(this.fullPath), "r");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.randomFileLock;
        synchronized (object) {
            if (this.randomFile != null) {
                this.randomFile.close();
            }
            this.randomFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.randomFileLock;
        synchronized (object) {
            return this.randomFile != null;
        }
    }

    public int getDirecton() {
        return this.direction;
    }

    public void setDirecton(int n) {
        this.direction = this.direction;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getMediaName() {
        return this.mediaName;
    }

    public String getMediaExtension() {
        return this.mediaExtension;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public long lastModified() {
        try {
            return this.file.lastModified();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(DirectRandomAccessReader.class).error("lastModified: " + exception.toString());
            return 0L;
        }
    }

    public long length() {
        try {
            return this.file.length();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(DirectRandomAccessReader.class).error("length: " + exception.toString());
            return 0L;
        }
    }

    public String getPath() {
        return this.fullPath;
    }

    public void setClientIOTracker(IOPerformanceCounter iOPerformanceCounter) {
        this.clientIOPerformanceCounter = iOPerformanceCounter;
    }

    public void setStreamIOTracker(IOPerformanceCounter iOPerformanceCounter) {
        this.streamIOPerformanceCounter = iOPerformanceCounter;
    }
}

