/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

import com.wowza.util.IFasterByteArrayDynamicStreaming;
import com.wowza.util.IFasterByteArrayOutputStream;
import com.wowza.util.IFasterByteArrayWriteReference;
import com.wowza.wms.request.IRTMPEncrypt;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.mina.common.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FasterByteArrayOutputStream
extends IFasterByteArrayOutputStream
implements IFasterByteArrayWriteReference,
IFasterByteArrayDynamicStreaming {
    protected List<BufferHolder> buffers = new ArrayList<BufferHolder>();
    protected int blockSize = 16384;
    protected int firstBlockSize = 4000;
    protected int count = 0;
    protected ByteBuffer currBuffer = null;
    protected byte[] currBytes = null;
    protected int currPos = 0;
    protected int currLimit = 0;
    private byte[] tmpWorkBuffer = new byte[3];
    private List<ByteBuffer> beforeBlocks = null;
    private List<ByteBuffer> afterBlocks = null;

    public FasterByteArrayOutputStream() {
        this(32768);
    }

    public FasterByteArrayOutputStream(int n) {
    }

    private ByteBuffer addBuffer(boolean bl) {
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)(bl ? this.firstBlockSize : this.blockSize), (boolean)false);
        this.buffers.add(new BufferHolder(byteBuffer));
        return byteBuffer;
    }

    private void nextBuffer(boolean bl) {
        if (this.currBuffer != null) {
            this.currBuffer.position(this.currPos);
        }
        this.currBuffer = this.addBuffer(bl);
        this.currBytes = null;
        try {
            this.currBytes = this.currBuffer.array();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.currPos = 0;
        this.currLimit = this.currBuffer.limit();
    }

    private void closeCurrentBuffer() {
        if (this.currBuffer != null) {
            if (this.currPos <= 0) {
                BufferHolder bufferHolder = this.buffers.remove(this.buffers.size() - 1);
                bufferHolder.buffer.release();
            } else {
                this.currBuffer.position(this.currPos);
            }
            this.currBuffer = null;
            this.currBytes = null;
            this.currPos = 0;
            this.currLimit = 0;
        }
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2, boolean bl) {
        if (!bl) {
            this.write(byArray, n, n2);
            return;
        }
        this.closeCurrentBuffer();
        ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])byArray, (int)n, (int)n2);
        byteBuffer.position(n + n2);
        this.count += n2;
        this.buffers.add(new BufferHolder(byteBuffer, bl, n, n2));
    }

    @Override
    public synchronized int write(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        if (this.currBuffer == null) {
            this.nextBuffer(true);
        }
        byte by = 0;
        int n8 = 0;
        if (n4 >= 64) {
            n7 = n4 - 64;
            n8 = n7 > 255 ? 3 : 2;
            this.tmpWorkBuffer[0] = (byte)(192 + (n8 - 2));
            this.tmpWorkBuffer[1] = (byte)(0xFF & n7);
            if (n8 == 3) {
                this.tmpWorkBuffer[2] = (byte)(0xFF & n7 >> 8);
            }
        } else {
            by = (byte)(0xFF & n4 | 0xC0);
        }
        n7 = 0;
        int n9 = 0;
        int n10 = n2;
        do {
            if ((n6 = n5 - n3 % n5) == n5 && n3 > 0) {
                if (n8 > 0) {
                    this.write(this.tmpWorkBuffer, 0, n8);
                    n7 += n8;
                } else {
                    if (this.currLimit - this.currPos == 0) {
                        this.nextBuffer(false);
                    }
                    if (this.currBytes != null) {
                        this.currBytes[this.currPos] = by;
                    } else {
                        this.currBuffer.put(by);
                    }
                    ++this.count;
                    ++this.currPos;
                    ++n7;
                }
            }
            n6 = n6 > n10 ? n10 : n6;
            this.write(byArray, n + n9, n6);
            n9 += n6;
            n3 += n6;
            n7 += n6;
        } while ((n10 -= n6) != 0);
        return n7;
    }

    @Override
    public synchronized void write(byte[] byArray) {
        if (byArray != null) {
            this.write(byArray, 0, byArray.length);
        }
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) {
        if (this.currBuffer == null) {
            this.nextBuffer(true);
        }
        int n3 = 0;
        int n4 = n2;
        while (true) {
            int n5;
            int n6;
            int n7 = n6 = n4 > (n5 = this.currLimit - this.currPos) ? n5 : n4;
            if (this.currBytes != null) {
                System.arraycopy(byArray, n3 + n, this.currBytes, this.currPos, n6);
            } else {
                this.currBuffer.put(byArray, n3 + n, n6);
            }
            n3 += n6;
            this.count += n6;
            this.currPos += n6;
            if ((n4 -= n6) == 0) break;
            this.nextBuffer(false);
        }
    }

    @Override
    public synchronized void write(int n) {
        this.write(new byte[]{(byte)n}, 0, 1);
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public synchronized void reset() {
        this.buffers.clear();
        this.count = 0;
        this.currBuffer = null;
        this.currBytes = null;
        this.currPos = 0;
        this.currLimit = 0;
    }

    @Override
    public synchronized byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        if (this.currBuffer != null) {
            this.currBuffer.position(this.currPos);
        }
        int n = 0;
        int n2 = this.count;
        for (BufferHolder bufferHolder : this.buffers) {
            ByteBuffer byteBuffer = bufferHolder.buffer;
            if (bufferHolder.reference) {
                System.arraycopy(byteBuffer.array(), bufferHolder.offset, byArray, n, bufferHolder.len);
                n += bufferHolder.len;
                continue;
            }
            System.arraycopy(byteBuffer.array(), 0, byArray, n, byteBuffer.position());
            n += byteBuffer.position();
        }
        return byArray;
    }

    @Override
    public synchronized ByteBuffer toByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)this.count);
        if (this.currBuffer != null) {
            this.currBuffer.position(this.currPos);
        }
        for (BufferHolder bufferHolder : this.buffers) {
            ByteBuffer byteBuffer2 = bufferHolder.buffer;
            if (bufferHolder.reference) {
                byteBuffer.put(byteBuffer2.array(), bufferHolder.offset, bufferHolder.len);
                continue;
            }
            byteBuffer.put(byteBuffer2.array(), 0, byteBuffer2.position());
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.toByteArray(), string);
    }

    @Override
    public synchronized int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public synchronized void setBlockSize(int n) {
        this.blockSize = n;
        this.firstBlockSize = n;
    }

    @Override
    public synchronized List<ByteBuffer> getBuffers() {
        if (this.currBuffer != null) {
            this.currBuffer.position(this.currPos);
        }
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
        for (BufferHolder bufferHolder : this.buffers) {
            if (bufferHolder.reference) {
                bufferHolder.buffer.position(bufferHolder.offset);
                bufferHolder.buffer.limit(bufferHolder.offset + bufferHolder.len);
            } else {
                bufferHolder.buffer.flip();
            }
            arrayList.add(bufferHolder.buffer);
        }
        return arrayList;
    }

    @Override
    public void encrypt(IRTMPEncrypt iRTMPEncrypt, boolean bl) {
        if (this.currBuffer != null) {
            this.currBuffer.position(this.currPos);
        }
        for (BufferHolder bufferHolder : this.buffers) {
            ByteBuffer byteBuffer = bufferHolder.buffer;
            if (bufferHolder.reference) {
                ByteBuffer byteBuffer2 = ByteBuffer.allocate((int)bufferHolder.len, (boolean)false);
                iRTMPEncrypt.encrypt(byteBuffer.array(), bufferHolder.offset, byteBuffer2.array(), 0, bufferHolder.len);
                byteBuffer2.position(bufferHolder.len);
                bufferHolder.buffer = byteBuffer2;
                bufferHolder.reference = false;
            } else {
                int n = bl ? 1 : 0;
                int n2 = byteBuffer.position() - n;
                if (n2 > 0) {
                    iRTMPEncrypt.encrypt(byteBuffer.array(), n, n2);
                }
            }
            bl = false;
        }
    }

    @Override
    public void addBeforeBlock(byte[] byArray) {
        if (this.beforeBlocks == null) {
            this.beforeBlocks = new ArrayList<ByteBuffer>();
        }
        this.beforeBlocks.add(ByteBuffer.wrap((byte[])byArray));
    }

    @Override
    public void addAfterBlock(byte[] byArray) {
        if (this.afterBlocks == null) {
            this.afterBlocks = new ArrayList<ByteBuffer>();
        }
        this.afterBlocks.add(ByteBuffer.wrap((byte[])byArray));
    }

    @Override
    public List<ByteBuffer> getBeforeBlocks() {
        return this.beforeBlocks;
    }

    @Override
    public List<ByteBuffer> getAfterBlocks() {
        return this.afterBlocks;
    }

    class BufferHolder {
        ByteBuffer buffer = null;
        boolean reference = false;
        int offset = 0;
        int len = 0;

        public BufferHolder(ByteBuffer byteBuffer) {
            this.buffer = byteBuffer;
        }

        public BufferHolder(ByteBuffer byteBuffer, boolean bl, int n, int n2) {
            this.buffer = byteBuffer;
            this.reference = bl;
            this.offset = n;
            this.len = n2;
        }
    }
}

