/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

import com.wowza.util.IGenericPoolFactory;
import java.util.LinkedList;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPool<T> {
    private Object lock = new Object();
    private IGenericPoolFactory<T> factory = null;
    private int maxSize = 1;
    private Queue<T> waiting = new LinkedList<T>();
    private Queue<T> active = new LinkedList<T>();

    public GenericPool(IGenericPoolFactory<T> iGenericPoolFactory, int n) {
        this.factory = iGenericPoolFactory;
        this.maxSize = n;
    }

    public GenericPool(IGenericPoolFactory<T> iGenericPoolFactory) {
        this.factory = iGenericPoolFactory;
    }

    public T acquire() throws InterruptedException {
        return this.acquire(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T acquire(long l) throws InterruptedException {
        T t = null;
        Object object = this.lock;
        synchronized (object) {
            while ((t = (T)this.waiting.poll()) == null) {
                if (this.active.size() < this.maxSize) {
                    t = this.factory.createInstance();
                }
                if (t != null || l <= 0L) break;
                this.lock.wait(l);
            }
            if (t != null) {
                this.active.add(t);
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T acquire(boolean bl) throws InterruptedException {
        T t = null;
        Object object = this.lock;
        synchronized (object) {
            while ((t = (T)this.waiting.poll()) == null) {
                if (this.active.size() < this.maxSize) {
                    t = this.factory.createInstance();
                }
                if (t != null || !bl) break;
                this.lock.wait();
            }
            if (t != null) {
                this.active.add(t);
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(T t) {
        Object object = this.lock;
        synchronized (object) {
            int n = this.active.size() + this.waiting.size();
            this.active.remove(t);
            if (n <= this.maxSize) {
                this.waiting.add(t);
                this.lock.notify();
            } else {
                this.factory.destroyInstance(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.active.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWaitingCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.waiting.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.waiting.size() + this.active.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxSize() {
        int n = 0;
        Object object = this.lock;
        synchronized (object) {
            n = this.maxSize;
        }
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSize(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.maxSize = n;
        }
    }
}

