/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class RandomIdGenerator {
    public static final long TIMEOUT = 36000000L;
    private long randomIdGeneratorTimeout = 36000000L;
    private int maxValue = Integer.MAX_VALUE;
    private Set<Integer> values = new HashSet<Integer>();
    private Map<Integer, IdHolder> recycle = new HashMap<Integer, IdHolder>();
    private List<IdHolder> recycleDelay = new ArrayList<IdHolder>();
    private Random rnd = null;

    public RandomIdGenerator() {
    }

    public RandomIdGenerator(int n) {
        this.maxValue = n;
    }

    public void init(WMSProperties wMSProperties) {
        this.rnd = new Random(System.currentTimeMillis());
        this.randomIdGeneratorTimeout = wMSProperties.getPropertyLong("randomIdGeneratorTimeout", this.randomIdGeneratorTimeout);
        if (this.randomIdGeneratorTimeout <= 0L) {
            WMSLoggerFactory.getLogger(RandomIdGenerator.class).info("RandomIdGenerator.init: ID recycling is turned off");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tryToGetId(int n) {
        Integer n2 = new Integer(n);
        RandomIdGenerator randomIdGenerator = this;
        synchronized (randomIdGenerator) {
            if (!this.values.contains(n2)) {
                IdHolder idHolder;
                this.values.add(n2);
                if (this.randomIdGeneratorTimeout > 0L && (idHolder = this.recycle.remove(n2)) != null) {
                    this.recycleDelay.remove(idHolder);
                }
            } else {
                n = -1;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextId() {
        int n = -1;
        while (true) {
            RandomIdGenerator randomIdGenerator;
            if ((n = this.rnd.nextInt(this.maxValue)) <= 0) {
                continue;
            }
            Integer n2 = new Integer(n);
            if (this.randomIdGeneratorTimeout > 0L) {
                randomIdGenerator = this;
                synchronized (randomIdGenerator) {
                    if (!this.values.contains(n2) && !this.recycle.containsKey(n2)) {
                        this.values.add(n2);
                        break;
                    }
                }
            }
            randomIdGenerator = this;
            synchronized (randomIdGenerator) {
                if (!this.values.contains(n2)) {
                    this.values.add(n2);
                    break;
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseId(int n) {
        Object object;
        Integer n2 = new Integer(n);
        if (this.randomIdGeneratorTimeout > 0L) {
            object = new IdHolder();
            ((IdHolder)object).idObj = n2;
            ((IdHolder)object).time = System.currentTimeMillis();
            RandomIdGenerator randomIdGenerator = this;
            synchronized (randomIdGenerator) {
                this.recycle.put(n2, (IdHolder)object);
                this.recycleDelay.add((IdHolder)object);
            }
        }
        object = this;
        synchronized (object) {
            this.values.remove(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecycleSize() {
        RandomIdGenerator randomIdGenerator = this;
        synchronized (randomIdGenerator) {
            return this.recycle.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecycleDelaySize() {
        RandomIdGenerator randomIdGenerator = this;
        synchronized (randomIdGenerator) {
            return this.recycleDelay.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIdle() {
        if (this.randomIdGeneratorTimeout > 0L) {
            ArrayList<IdHolder> arrayList = new ArrayList<IdHolder>();
            RandomIdGenerator randomIdGenerator = this;
            synchronized (randomIdGenerator) {
                arrayList.addAll(this.recycleDelay);
            }
            long l = System.currentTimeMillis();
            for (IdHolder idHolder : arrayList) {
                if (idHolder.time + this.randomIdGeneratorTimeout >= l) break;
                RandomIdGenerator randomIdGenerator2 = this;
                synchronized (randomIdGenerator2) {
                    this.recycle.remove(idHolder.idObj);
                    this.recycleDelay.remove(idHolder);
                }
            }
        }
    }

    public long getRandomIdGeneratorTimeout() {
        return this.randomIdGeneratorTimeout;
    }

    public void setRandomIdGeneratorTimeout(long l) {
        this.randomIdGeneratorTimeout = l;
    }

    class IdHolder {
        long time = -1L;
        Integer idObj = null;

        IdHolder() {
        }
    }
}

