/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.admin;

import com.wowza.wms.admin.AdminAgent;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.Server;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamNotify;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.vhost.IVHost;
import org.apache.commons.modeler.Registry;

public class AdminMediaStreamListener
implements IMediaStreamNotify {
    public static final String MEDIASTREAM_OBJECTNAME = "mediaStreams=MediaStreams,mediaStreamId=";
    public static final String MEDIASTREAM_FILTERNAME = "MediaStream";
    private AdminAgent adminAgent = null;
    private IVHost vhost = null;
    private IApplication application = null;
    private IApplicationInstance applicationInstance = null;
    private boolean isActive = true;

    public AdminMediaStreamListener(AdminAgent adminAgent, IVHost iVHost, IApplication iApplication, IApplicationInstance iApplicationInstance) {
        this.adminAgent = adminAgent;
        this.vhost = iVHost;
        this.application = iApplication;
        this.applicationInstance = iApplicationInstance;
        this.isActive = Server.getInstance().getAdminInterfaceObjectList().contains(MEDIASTREAM_FILTERNAME.toLowerCase());
    }

    private String getObjectName(IMediaStream iMediaStream) {
        String string = iMediaStream.getSrc() + "";
        IClient iClient = iMediaStream.getClient();
        if (iClient != null) {
            string = iClient.getClientId() + "-" + string;
        }
        return "WowzaMediaServerPro:vHosts=VHosts,vHostName=" + this.vhost.getName() + "," + "applications=Applications,applicationName=" + this.application.getName() + "," + "applicationInstances=ApplicationInstances,applicationInstanceName=" + this.applicationInstance.getName() + "," + MEDIASTREAM_OBJECTNAME + string;
    }

    public void onMediaStreamCreate(IMediaStream iMediaStream) {
        try {
            if (this.isActive) {
                String string = this.getObjectName(iMediaStream);
                Registry.getRegistry(null, null).registerComponent((Object)iMediaStream, string + ",name=ClassBase", iMediaStream.getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iMediaStream.getMediaIOPerformance(), string + ",name=MediaIOPerformance", iMediaStream.getMediaIOPerformance().getClass().getName());
                Registry.getRegistry(null, null).registerComponent((Object)iMediaStream.getProperties(), string + ",name=Properties", iMediaStream.getProperties().getClass().getName());
                IMediaStreamPlay iMediaStreamPlay = iMediaStream.getPlayer();
                if (iMediaStreamPlay != null) {
                    Registry.getRegistry(null, null).registerComponent((Object)iMediaStreamPlay, string + ",name=ClassPlay", iMediaStreamPlay.getClass().getName());
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminMediaStreamListener.class).error("onMediaStreamCreate: " + exception.toString());
        }
    }

    public void onMediaStreamDestroy(IMediaStream iMediaStream) {
        try {
            if (this.isActive) {
                String string = this.getObjectName(iMediaStream);
                Registry.getRegistry(null, null).unregisterComponent(string + ",name=ClassBase");
                Registry.getRegistry(null, null).unregisterComponent(string + ",name=MediaIOPerformance");
                Registry.getRegistry(null, null).unregisterComponent(string + ",name=Properties");
                IMediaStreamPlay iMediaStreamPlay = iMediaStream.getPlayer();
                if (iMediaStreamPlay != null) {
                    Registry.getRegistry(null, null).unregisterComponent(string + ",name=ClassPlay");
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AdminMediaStreamListener.class).error("onMediaStreamDestroy: " + exception.toString());
        }
    }
}

