/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.amf;

import com.wowza.util.BufferUtils;
import com.wowza.wms.amf.AMF3Utils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataContextDeserialize;
import com.wowza.wms.amf.AMFDataContextSerialize;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;

public class AMFDataMixedArray
extends AMFDataObj {
    public AMFDataMixedArray() {
        this.type = 8;
    }

    public AMFDataMixedArray(byte[] byArray) {
        this.type = 8;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.deserialize(byteBuffer);
    }

    public AMFDataMixedArray(byte[] byArray, int n, int n2) {
        this.type = 8;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        this.deserialize(byteBuffer);
    }

    public AMFDataMixedArray(ByteBuffer byteBuffer) {
        this.type = 8;
        this.deserialize(byteBuffer);
    }

    public AMFDataMixedArray(ByteBuffer byteBuffer, AMFDataContextDeserialize aMFDataContextDeserialize) {
        this.type = 8;
        this.deserialize(byteBuffer, aMFDataContextDeserialize);
    }

    public void deserialize(ByteBuffer byteBuffer) {
        this.deserialize(byteBuffer, AMFData.createContextDeserialize());
    }

    public void deserialize(ByteBuffer byteBuffer, AMFDataContextDeserialize aMFDataContextDeserialize) {
        try {
            if (!aMFDataContextDeserialize.isAMF0()) {
                AMFData aMFData;
                String string;
                int n;
                int n2 = n = aMFDataContextDeserialize.isIntData() ? aMFDataContextDeserialize.clearIntData() : AMF3Utils.deserializeInt(byteBuffer);
                if ((n & 1) == 0) {
                    WMSLoggerFactory.getLogger(AMFDataObj.class).error("AMFDataMixedArray.deserialize: DECODE_OBJ_REF: Cannot decode reference in AMFDataMixedArray constructor.");
                }
                n >>= 1;
                aMFDataContextDeserialize.addObject(this);
                while ((string = AMF3Utils.deserializeString(byteBuffer, aMFDataContextDeserialize)).length() != 0) {
                    aMFData = AMFData.deserializeInnerObject(byteBuffer, aMFDataContextDeserialize);
                    if (aMFData == null) continue;
                    this.members.put(string, aMFData);
                    this.order.remove(string);
                    this.order.add(string);
                }
                for (int i = 0; i < n; ++i) {
                    aMFData = AMFData.deserializeInnerObject(byteBuffer, aMFDataContextDeserialize);
                    if (aMFData == null) continue;
                    String string2 = new String(i + "");
                    this.members.put(string2, aMFData);
                    this.order.remove(string2);
                    this.order.add(i, string2);
                }
            } else {
                int n;
                aMFDataContextDeserialize.addObject(this);
                int n3 = byteBuffer.getInt();
                while (!(byteBuffer.remaining() < 3 || (n = BufferUtils.getUnsignedShort(byteBuffer)) == 0 && AMFDataMixedArray.isObjEnd(byteBuffer, aMFDataContextDeserialize))) {
                    Object object;
                    String string = null;
                    if (n > 0) {
                        object = new byte[n];
                        byteBuffer.get((byte[])object);
                        string = new String((byte[])object, "UTF-8");
                    } else {
                        string = new String();
                    }
                    object = AMFData.deserializeInnerObject(byteBuffer, aMFDataContextDeserialize);
                    if (object != null) {
                        this.members.put(string, object);
                        this.order.add(string);
                        continue;
                    }
                    WMSLoggerFactory.getLogger(AMFDataMixedArray.class).error("AMFDataMixedArray.deserialize: no object");
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataMixedArray.class).error("AMFDataMixedArray.deserialize[" + byteBuffer.capacity() + ":" + byteBuffer.position() + "]: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void serialize(DataOutputStream dataOutputStream) {
        this.serialize(dataOutputStream, AMFData.createContextSerialize(0));
    }

    public void serialize(DataOutputStream dataOutputStream, int n) {
        this.serialize(dataOutputStream, AMFData.createContextSerialize(n));
    }

    public void serialize(DataOutputStream dataOutputStream, AMFDataContextSerialize aMFDataContextSerialize) {
        try {
            if (!aMFDataContextSerialize.isAMF0()) {
                dataOutputStream.write(9);
                int n = aMFDataContextSerialize.getObjectReference(this);
                if (n >= 0) {
                    AMF3Utils.serializeInt(dataOutputStream, n <<= 1);
                } else {
                    Object object;
                    Object object2;
                    int n2;
                    ArrayList arrayList = new ArrayList(this.order);
                    int n3 = 0;
                    int n4 = arrayList.size();
                    for (n2 = 0; n2 < n4 && arrayList.contains(object2 = "" + n2); ++n2) {
                        arrayList.remove(object2);
                        ++n3;
                    }
                    n2 = n3;
                    n2 <<= 1;
                    AMF3Utils.serializeInt(dataOutputStream, n2 |= 1);
                    for (String string : arrayList) {
                        aMFDataContextSerialize.writeString(dataOutputStream, string);
                        object = (AMFData)this.members.get(string);
                        ((AMFData)object).serialize(dataOutputStream, aMFDataContextSerialize);
                    }
                    AMF3Utils.serializeZeroLengthString(dataOutputStream);
                    for (int i = 0; i < n3; ++i) {
                        object = "" + i;
                        AMFData aMFData = (AMFData)this.members.get(object);
                        aMFData.serialize(dataOutputStream, aMFDataContextSerialize);
                    }
                }
            } else {
                dataOutputStream.write(8);
                boolean bl = false;
                int n = 0;
                for (String string : this.order) {
                    try {
                        int n5 = Integer.parseInt(string);
                        if (n5 > n) {
                            n = n5;
                        }
                        bl = true;
                    }
                    catch (Exception exception) {}
                }
                if (bl) {
                    ++n;
                }
                dataOutputStream.writeInt(n);
                for (String string : this.order) {
                    dataOutputStream.writeUTF(string);
                    AMFData aMFData = (AMFData)this.members.get(string);
                    aMFData.serialize(dataOutputStream, aMFDataContextSerialize);
                }
                dataOutputStream.writeShort(0);
                dataOutputStream.write(9);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataMixedArray.class).error("serialize: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{MixedArray: ");
        Iterator iterator = this.order.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            AMFData aMFData = (AMFData)this.members.get(e);
            if (n > 0) {
                stringBuffer.append(", ");
            }
            int n2 = aMFData.getType();
            switch (n2) {
                default: {
                    stringBuffer.append(e + ": " + aMFData.toString());
                    break;
                }
                case 2: 
                case 11: 
                case 15: 
                case 34: {
                    stringBuffer.append(e + ": \"" + aMFData.toString() + "\"");
                }
            }
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

