/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.amf;

import com.wowza.util.BufferUtils;
import com.wowza.wms.amf.AMF3Utils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataContextDeserialize;
import com.wowza.wms.amf.AMFDataContextSerialize;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataTrait;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AMFDataObj
extends AMFData {
    public static final int DECODE_UNDEFINED = 0;
    public static final int DECODE_OBJ_REF = 1;
    public static final int DECODE_TRAITS_REF = 2;
    public static final int DECODE_TRAITS_EXT = 3;
    public static final int DECODE_TRAITS = 4;
    protected Map<String, AMFData> members = new HashMap<String, AMFData>();
    protected List<String> order = new ArrayList<String>();
    protected AMFDataTrait trait = null;

    public AMFDataObj() {
        this.type = 3;
    }

    public AMFDataObj(byte[] byArray) {
        this.type = 3;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.deserialize(byteBuffer);
    }

    public AMFDataObj(byte[] byArray, int n, int n2) {
        this.type = 3;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        this.deserialize(byteBuffer);
    }

    public AMFDataObj(ByteBuffer byteBuffer) {
        this.type = 3;
        this.deserialize(byteBuffer);
    }

    public AMFDataObj(ByteBuffer byteBuffer, AMFDataContextDeserialize aMFDataContextDeserialize) {
        this.type = 3;
        this.deserialize(byteBuffer, aMFDataContextDeserialize);
    }

    public int size() {
        return this.members.size();
    }

    public boolean containsKey(String string) {
        return this.members.containsKey(string);
    }

    public void put(String string, AMFData aMFData) {
        try {
            this.members.put(string, aMFData);
            this.order.remove(string);
            this.order.add(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataObj.class).error("put: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void put(String string, String string2) {
        try {
            this.members.put(string, new AMFDataItem(string2));
            this.order.remove(string);
            this.order.add(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataObj.class).error("put: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void put(String string, double d) {
        try {
            this.members.put(string, new AMFDataItem(d));
            this.order.remove(string);
            this.order.add(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataObj.class).error("put: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void put(String string, int n) {
        try {
            this.members.put(string, new AMFDataItem(n));
            this.order.remove(string);
            this.order.add(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataObj.class).error("put: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void put(String string, long l) {
        try {
            this.members.put(string, new AMFDataItem(l));
            this.order.remove(string);
            this.order.add(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataObj.class).error("put: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void put(String string, Date date) {
        try {
            this.members.put(string, new AMFDataItem(date));
            this.order.remove(string);
            this.order.add(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataObj.class).error("put: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void put(String string, boolean bl) {
        try {
            this.members.put(string, new AMFDataItem(bl));
            this.order.remove(string);
            this.order.add(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataObj.class).error("put: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public List getKeys() {
        return new ArrayList<String>(this.order);
    }

    public String getKey(int n) {
        try {
            return this.order.get(n);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataObj.class).error("get: " + exception.toString());
            exception.printStackTrace();
            return null;
        }
    }

    public AMFData get(String string) {
        try {
            return this.members.get(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataObj.class).error("get: " + exception.toString());
            exception.printStackTrace();
            return null;
        }
    }

    public AMFData get(int n) {
        try {
            String string = this.order.get(n);
            return string != null ? this.members.get(string) : null;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataObj.class).error("get: " + exception.toString());
            exception.printStackTrace();
            return null;
        }
    }

    public AMFData remove(String string) {
        AMFData aMFData = null;
        try {
            this.order.remove(string);
            aMFData = this.members.remove(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataObj.class).error("remove: " + exception.toString());
            exception.printStackTrace();
        }
        return aMFData;
    }

    public AMFData remove(int n) {
        AMFData aMFData = null;
        try {
            String string = this.order.remove(n);
            aMFData = string != null ? this.members.remove(string) : null;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataObj.class).error("remove: " + exception.toString());
            exception.printStackTrace();
        }
        return aMFData;
    }

    public String getString(String string) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(string);
        return aMFDataItem != null ? aMFDataItem.toString() : null;
    }

    public int getInt(String string) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(string);
        return aMFDataItem != null ? aMFDataItem.intValue() : 0;
    }

    public long getLong(String string) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(string);
        return aMFDataItem != null ? aMFDataItem.longValue() : 0L;
    }

    public short getShort(String string) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(string);
        return aMFDataItem != null ? aMFDataItem.shortValue() : (short)0;
    }

    public double getDouble(String string) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(string);
        return aMFDataItem != null ? aMFDataItem.doubleValue() : 0.0;
    }

    public float getFloat(String string) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(string);
        return aMFDataItem != null ? aMFDataItem.floatValue() : 0.0f;
    }

    public byte getByte(String string) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(string);
        return aMFDataItem != null ? aMFDataItem.byteValue() : (byte)0;
    }

    public boolean getBoolean(String string) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(string);
        return aMFDataItem != null ? aMFDataItem.booleanValue() : false;
    }

    public Date getDate(String string) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(string);
        return (Date)(aMFDataItem != null ? (aMFDataItem.getType() == 11 ? aMFDataItem.getValue() : null) : null);
    }

    public AMFDataObj getObject(String string) {
        return (AMFDataObj)this.get(string);
    }

    public String getString(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.toString() : null;
    }

    public int getInt(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.intValue() : 0;
    }

    public long getLong(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.longValue() : 0L;
    }

    public short getShort(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.shortValue() : (short)0;
    }

    public byte getByte(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.byteValue() : (byte)0;
    }

    public double getDouble(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.doubleValue() : 0.0;
    }

    public float getFloat(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.floatValue() : 0.0f;
    }

    public boolean getBoolean(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return aMFDataItem != null ? aMFDataItem.booleanValue() : false;
    }

    public Date getDate(int n) {
        AMFDataItem aMFDataItem = (AMFDataItem)this.get(n);
        return (Date)(aMFDataItem != null ? (aMFDataItem.getType() == 11 ? aMFDataItem.getValue() : null) : null);
    }

    public AMFDataObj getObject(int n) {
        AMFDataObj aMFDataObj = (AMFDataObj)this.get(n);
        return aMFDataObj;
    }

    public void deserialize(ByteBuffer byteBuffer) {
        this.deserialize(byteBuffer, AMFData.createContextDeserialize());
    }

    public void deserialize(ByteBuffer byteBuffer, AMFDataContextDeserialize aMFDataContextDeserialize) {
        try {
            if (!aMFDataContextDeserialize.isAMF0()) {
                String string;
                AMFData aMFData;
                int n = aMFDataContextDeserialize.isIntData() ? aMFDataContextDeserialize.clearIntData() : AMF3Utils.deserializeInt(byteBuffer);
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                boolean bl = false;
                if ((n & 1) == 0) {
                    n4 = 1;
                    n2 = n >> 1;
                } else if (((n >>= 1) & 1) == 0) {
                    n4 = 2;
                    n2 = n >> 1;
                } else if (((n >>= 1) & 1) == 1) {
                    n4 = 3;
                } else {
                    n4 = 4;
                    bl = ((n >>= 1) & 1) == 1;
                    n3 = n >>= 1;
                }
                boolean bl2 = true;
                switch (n4) {
                    case 1: {
                        WMSLoggerFactory.getLogger(AMFDataObj.class).error("AMFDataObj.deserialize: DECODE_OBJ_REF: Cannot decode reference in AMFDataObj constructor.");
                        bl2 = false;
                        break;
                    }
                    case 2: {
                        this.trait = aMFDataContextDeserialize.getTrait(n2);
                        break;
                    }
                    case 3: {
                        this.trait = new AMFDataTrait();
                        aMFDataContextDeserialize.addTrait(this.trait);
                        String string2 = AMF3Utils.deserializeString(byteBuffer, aMFDataContextDeserialize);
                        this.trait.setClassName(string2);
                        aMFData = AMFData.deserializeInnerObject(byteBuffer, aMFDataContextDeserialize);
                        if (aMFData == null) break;
                        this.trait.setInnerObj(aMFData);
                        break;
                    }
                    case 4: {
                        this.trait = new AMFDataTrait();
                        aMFDataContextDeserialize.addTrait(this.trait);
                        this.trait.setDynamic(bl);
                        String string2 = AMF3Utils.deserializeString(byteBuffer, aMFDataContextDeserialize);
                        this.trait.setClassName(string2);
                        for (int i = 0; i < n3; ++i) {
                            string = AMF3Utils.deserializeString(byteBuffer, aMFDataContextDeserialize);
                            this.trait.addMember(string);
                        }
                        break;
                    }
                }
                if (bl2) {
                    aMFDataContextDeserialize.addObject(this);
                    if (this.trait != null) {
                        n3 = this.trait.getMemberCount();
                        for (int i = 0; i < n3; ++i) {
                            aMFData = AMFData.deserializeInnerObject(byteBuffer, aMFDataContextDeserialize);
                            if (aMFData == null) continue;
                            string = this.trait.getMember(i);
                            this.members.put(string, aMFData);
                            this.order.remove(string);
                            this.order.add(string);
                        }
                        if (this.trait.isDynamic()) {
                            String string3;
                            while ((string3 = AMF3Utils.deserializeString(byteBuffer, aMFDataContextDeserialize)).length() != 0) {
                                aMFData = AMFData.deserializeInnerObject(byteBuffer, aMFDataContextDeserialize);
                                if (aMFData == null) continue;
                                this.members.put(string3, aMFData);
                                this.order.remove(string3);
                                this.order.add(string3);
                            }
                        }
                    }
                }
            } else {
                int n;
                aMFDataContextDeserialize.addObject(this);
                while (!(byteBuffer.remaining() < 3 || (n = BufferUtils.getUnsignedShort(byteBuffer)) == 0 && AMFDataObj.isObjEnd(byteBuffer, aMFDataContextDeserialize))) {
                    Object object;
                    String string = null;
                    if (n > 0) {
                        object = new byte[n];
                        byteBuffer.get((byte[])object);
                        string = new String((byte[])object, "UTF-8");
                    } else {
                        string = new String();
                    }
                    object = AMFData.deserializeInnerObject(byteBuffer, aMFDataContextDeserialize);
                    if (object != null) {
                        this.members.put(string, (AMFData)object);
                        this.order.remove(string);
                        this.order.add(string);
                        continue;
                    }
                    WMSLoggerFactory.getLogger(AMFDataObj.class).error("AMFDataObj.deserialize: no object");
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataObj.class).error("AMFDataObj.deserialize[" + byteBuffer.capacity() + ":" + byteBuffer.position() + "]: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void serialize(DataOutputStream dataOutputStream) {
        this.serialize(dataOutputStream, AMFData.createContextSerialize(0));
    }

    public void serialize(DataOutputStream dataOutputStream, int n) {
        this.serialize(dataOutputStream, AMFData.createContextSerialize(n));
    }

    public void serialize(DataOutputStream dataOutputStream, AMFDataContextSerialize aMFDataContextSerialize) {
        try {
            if (!aMFDataContextSerialize.isAMF0()) {
                dataOutputStream.write(10);
                int n = aMFDataContextSerialize.getObjectReference(this);
                if (n >= 0) {
                    AMF3Utils.serializeInt(dataOutputStream, n <<= 1);
                } else {
                    Object object;
                    int n2;
                    boolean bl = false;
                    int n3 = 0;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.addAll(this.order);
                    int n4 = -1;
                    if (this.trait != null) {
                        bl = this.trait.isDynamic();
                        n3 = this.trait.getMemberCount();
                        for (n2 = 0; n2 < n3; ++n2) {
                            String string = this.trait.getMember(n2);
                            arrayList.remove(string);
                        }
                        if (arrayList.size() > 0) {
                            bl = true;
                        }
                        if (this.trait.isDynamic() != bl) {
                            this.trait = this.trait.clone();
                            this.trait.setDynamic(bl);
                        }
                        n4 = aMFDataContextSerialize.getTraitReference(this.trait);
                    } else {
                        bl = true;
                    }
                    if (n4 >= 0) {
                        n4 <<= 2;
                        AMF3Utils.serializeInt(dataOutputStream, ++n4);
                    } else {
                        n2 = n3;
                        n2 <<= 4;
                        n2 |= 3;
                        if (bl) {
                            n2 |= 8;
                        }
                        AMF3Utils.serializeInt(dataOutputStream, n2);
                        aMFDataContextSerialize.writeString(dataOutputStream, this.getClassName());
                        for (int i = 0; i < n3; ++i) {
                            object = this.trait.getMember(i);
                            aMFDataContextSerialize.writeString(dataOutputStream, (String)object);
                        }
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        String string = this.trait.getMember(n2);
                        object = this.members.get(string);
                        if (object != null) {
                            ((AMFData)object).serialize(dataOutputStream, aMFDataContextSerialize);
                            continue;
                        }
                        dataOutputStream.write(6);
                    }
                    if (bl) {
                        for (String string : arrayList) {
                            aMFDataContextSerialize.writeString(dataOutputStream, string);
                            object = this.members.get(string);
                            ((AMFData)object).serialize(dataOutputStream, aMFDataContextSerialize);
                        }
                        AMF3Utils.serializeZeroLengthString(dataOutputStream);
                    }
                }
            } else {
                dataOutputStream.write(3);
                for (String string : this.order) {
                    dataOutputStream.writeUTF(string);
                    AMFData aMFData = this.members.get(string);
                    aMFData.serialize(dataOutputStream, aMFDataContextSerialize);
                }
                dataOutputStream.writeShort(0);
                dataOutputStream.write(9);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(AMFDataObj.class).error("serialize: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public byte[] serialize() {
        return this.serialize(AMFData.createContextSerialize(0));
    }

    public byte[] serialize(int n) {
        return this.serialize(AMFData.createContextSerialize(n));
    }

    public byte[] serialize(AMFDataContextSerialize aMFDataContextSerialize) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.serialize(dataOutputStream, aMFDataContextSerialize);
        return byteArrayOutputStream.toByteArray();
    }

    public Object getValue() {
        return this.members;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Obj[" + this.getClassName() + "]: ");
        Iterator<String> iterator = this.order.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = iterator.next();
            AMFData aMFData = this.members.get(string);
            if (n > 0) {
                stringBuffer.append(", ");
            }
            int n2 = aMFData.getType();
            switch (n2) {
                default: {
                    stringBuffer.append(string + ": " + aMFData.toString());
                    break;
                }
                case 2: 
                case 11: 
                case 15: 
                case 34: {
                    stringBuffer.append(string + ": \"" + aMFData.toString() + "\"");
                }
            }
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String getClassName() {
        return this.trait == null ? "" : this.trait.getClassName();
    }

    public void setClassName(String string) {
        if (this.trait == null) {
            this.trait = new AMFDataTrait();
        }
        this.trait.setClassName(string);
    }

    public AMFDataTrait getTrait() {
        return this.trait;
    }
}

