/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.model;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.model.HTTPStreamerSessionBase;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterList;
import com.wowza.wms.mediacaster.MediaCasterStreamItem;
import com.wowza.wms.mediacaster.MediaCasterStreamMap;
import com.wowza.wms.stream.mediacaster.MediaStreamMediaCasterUtils;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.StreamItem;
import com.wowza.wms.vhost.StreamList;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPStreamerMediaCasterStreamLock {
    protected List<String> repeaterStreams = new ArrayList<String>();
    protected List<MediaCasterStreamItem> repeaterStreamItems = new ArrayList<MediaCasterStreamItem>();
    protected boolean repeaterStreamsLocked = false;

    public void lockRepeaterStreams(String string, IApplicationInstance iApplicationInstance, String string2, String string3, String string4) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        this.lockRepeaterStreams(arrayList, iApplicationInstance, string2, string3, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockRepeaterStreams(List<String> list, IApplicationInstance iApplicationInstance, String string, String string2, String string3) {
        List<String> list2 = this.repeaterStreams;
        synchronized (list2) {
            if (!this.repeaterStreamsLocked) {
                this.repeaterStreamsLocked = true;
                IVHost iVHost = iApplicationInstance.getVHost();
                StreamList streamList = iVHost.getStreamTypes();
                StreamItem streamItem = streamList.getStreamDef(string3);
                String string4 = "httprepeater";
                string4 = streamItem.getProperties().getPropertyStr("mediaCasterType", string4);
                string4 = iApplicationInstance.getStreamProperties().getPropertyStr("mediaCasterType", string4);
                MediaCasterStreamMap mediaCasterStreamMap = iApplicationInstance.getMediaCasterStreams();
                MediaCasterList mediaCasterList = iVHost.getMediaCasterList();
                MediaCasterItem mediaCasterItem = mediaCasterList.getMediaCasterDef(string4);
                if (mediaCasterItem == null) {
                    WMSLoggerFactory.getLogger(HTTPStreamerSessionBase.class).warn("HTTPStreamerMediaCasterStreamLock.lockRepeaterStreams: MediaCaster type not found: " + string4);
                } else {
                    WMSReadWriteLock wMSReadWriteLock = mediaCasterStreamMap.getLock();
                    wMSReadWriteLock.writeLock().lock();
                    try {
                        for (String string5 : list) {
                            MediaCasterStreamItem mediaCasterStreamItem = mediaCasterStreamMap.acquire(string5 = MediaStreamMediaCasterUtils.mapMediaCasterName((IApplicationInstance)iApplicationInstance, null, (String)string5), string, string2, mediaCasterItem);
                            if (mediaCasterStreamItem == null) continue;
                            this.repeaterStreamItems.add(mediaCasterStreamItem);
                        }
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(HTTPStreamerSessionBase.class).error("HTTPStreamerMediaCasterStreamLock.lockRepeaterStreams: " + exception.toString());
                    }
                    finally {
                        wMSReadWriteLock.writeLock().unlock();
                    }
                    for (String string5 : list) {
                        WMSLoggerFactory.getLogger(HTTPStreamerSessionBase.class).info("HTTPStreamerMediaCasterStreamLock.lockRepeaterStreams[" + string + ":" + string2 + ":" + string4 + "]: repeaterLock: " + string5);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockRepeaterStreams(IApplicationInstance iApplicationInstance) {
        List<String> list = this.repeaterStreams;
        synchronized (list) {
            if (this.repeaterStreamsLocked && this.repeaterStreamItems.size() > 0 && iApplicationInstance != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                MediaCasterStreamMap mediaCasterStreamMap = iApplicationInstance.getMediaCasterStreams();
                WMSReadWriteLock wMSReadWriteLock = mediaCasterStreamMap.getLock();
                wMSReadWriteLock.writeLock().lock();
                try {
                    for (MediaCasterStreamItem object : this.repeaterStreamItems) {
                        if (object == null) continue;
                        object.release();
                        arrayList.add(object.getMediaCasterId());
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(HTTPStreamerSessionBase.class).error("HTTPStreamerMediaCasterStreamLock.unlockRepeaterStreams: " + exception.toString());
                }
                finally {
                    wMSReadWriteLock.writeLock().unlock();
                }
                for (String string : arrayList) {
                    WMSLoggerFactory.getLogger(HTTPStreamerSessionBase.class).info("HTTPStreamerMediaCasterStreamLock.unlockRepeaterStreams: repeaterUnLock: " + string);
                }
            }
        }
    }
}

