/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.model;

import com.wowza.util.DebugUtils;
import com.wowza.wms.http.HTTPRequest;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.ReleaseInfo;
import com.wowza.wms.server.RtmpRequestMessage;
import com.wowza.wms.stream.MediaStreamBase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPStreamerRequest
implements IHTTPRequest {
    private RtmpRequestMessage req = null;
    private Map<String, String> headerMap = new HashMap<String, String>();
    private Map<String, List<String>> parameterMap = new HashMap<String, List<String>>();
    private byte[] headerBytes = null;
    private byte[] msgBytes = null;
    private boolean parsedMsg = false;
    private String queryString = "";
    private String reqURI = "";
    private String reqURL = "";

    public HTTPStreamerRequest(RtmpRequestMessage rtmpRequestMessage) {
        this.req = rtmpRequestMessage;
        this.parseRequest(rtmpRequestMessage);
    }

    public RtmpRequestMessage getRTMPRequest() {
        return this.req;
    }

    private void parseRequest(RtmpRequestMessage rtmpRequestMessage) {
        block2: {
            ByteBuffer byteBuffer = rtmpRequestMessage.getBody();
            int n = rtmpRequestMessage.getHeaderLength();
            int n2 = rtmpRequestMessage.getContentLength();
            this.headerBytes = new byte[n];
            this.msgBytes = new byte[n2];
            byteBuffer.position(0);
            byteBuffer.get(this.headerBytes);
            byteBuffer.get(this.msgBytes);
            this.parseHeader(this.headerBytes);
            String string = this.headerMap.get("context");
            if (string == null || string.length() == 0) break block2;
            int n3 = string.indexOf("?");
            if (n3 < 0) {
                this.reqURL = string;
            } else {
                this.queryString = string.substring(n3 + 1);
                this.reqURL = string.substring(0, n3);
            }
            this.parseIntoParams(this.queryString, true);
        }
    }

    private void checkParsedMsg(boolean bl) {
        if (this.parsedMsg) {
            return;
        }
        this.parsedMsg = true;
        if (this.msgBytes == null) {
            return;
        }
        if (this.msgBytes.length == 0) {
            return;
        }
        try {
            String string = new String(this.msgBytes, "UTF-8");
            this.parseIntoParams(string, bl);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPRequest.class).error("HTTPRequest: checkParsedMsg: " + exception.toString());
        }
    }

    @Override
    public void parseBodyForParams(boolean bl) {
        this.checkParsedMsg(bl);
    }

    @Override
    public void parseBodyForParams() {
        this.checkParsedMsg(false);
    }

    private String decodeValue(String string) {
        String string2 = string;
        try {
            string2 = URLDecoder.decode(string2, "UTF-8");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPRequest.class).error("HTTPRequest: decodeValue (" + string + "): " + exception.toString());
            string2 = string;
        }
        return string2;
    }

    private void parseIntoParams(String string, boolean bl) {
        try {
            String[] stringArray = string.split("[&]");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() == 0) continue;
                int n = stringArray[i].indexOf("=");
                String string2 = null;
                String string3 = null;
                if (n > 0) {
                    string2 = stringArray[i].substring(0, n);
                    string3 = stringArray[i].substring(n + 1);
                } else if (n < 0) {
                    string2 = stringArray[i];
                }
                if (string2 != null && bl) {
                    string2 = this.decodeValue(string2);
                }
                if (string3 != null && bl) {
                    string3 = this.decodeValue(string3);
                }
                if (string2 == null) continue;
                List<String> list = this.parameterMap.get(string2);
                if (list == null) {
                    list = new ArrayList<String>();
                    this.parameterMap.put(string2, list);
                }
                if (string3 == null) continue;
                list.add(string3);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPRequest.class).error("HTTPRequest: parseIntoParams: " + exception.toString());
        }
    }

    private void parseHeader(byte[] byArray) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(HTTPRequest.class);
        if (!wMSLogger.isDebugEnabled()) {
            wMSLogger = null;
        }
        String string = null;
        String[] stringArray = null;
        try {
            string = new String(byArray, "UTF-8");
            string = string.replace("\r\n", "\n").replace("\r", "\n");
            stringArray = string.split("\n");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HTTPRequest.class).error("HTTPRequest: parseHeader: convert: " + exception.toString() + "\n" + DebugUtils.formatBytes(byArray));
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2;
                if (stringArray[i].length() == 0) continue;
                if (i == 0) {
                    try {
                        stringArray2 = stringArray[i].split(" ");
                        this.headerMap.put("uri", stringArray[i]);
                        this.headerMap.put("method", stringArray2[0].toUpperCase());
                        this.headerMap.put("context", stringArray2.length > 1 ? stringArray2[1].substring(1) : "");
                        this.headerMap.put("protocol", stringArray2.length > 2 ? stringArray2[2] : "");
                        this.reqURI = stringArray2[1];
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(HTTPRequest.class).error("HTTPRequest: parseHeader: context (" + stringArray[i] + "): " + exception.toString());
                    }
                    continue;
                }
                try {
                    stringArray2 = stringArray[i].split(": ");
                    if (stringArray2.length != 2) {
                        stringArray2 = stringArray[i].split(":");
                    }
                    if (stringArray2.length != 2) continue;
                    this.headerMap.put(stringArray2[0].toLowerCase(), stringArray2[1]);
                    continue;
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(HTTPRequest.class).error("HTTPRequest: parseHeader: token (" + stringArray[i] + "): " + exception.toString());
                }
            }
        }
    }

    @Override
    public String getHeader(String string) {
        return this.headerMap.get(string.toLowerCase());
    }

    @Override
    public int getIntHeader(String string) {
        try {
            String string2 = this.headerMap.get(string.toLowerCase());
            if (string2 != null) {
                return Integer.parseInt(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public Set<String> getHeaderNames() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.headerMap.keySet());
        return hashSet;
    }

    @Override
    public String getMethod() {
        return this.getHeader("method");
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public int getContentLength() {
        return this.req.getContentLength();
    }

    @Override
    public String getRequestURI() {
        return this.reqURI;
    }

    @Override
    public String getRequestURL() {
        return this.reqURL;
    }

    @Override
    public String getContentType() {
        return this.getHeader("content-type");
    }

    @Override
    public String getParameter(String string) {
        List<String> list = this.parameterMap.get(string);
        if (list != null) {
            if (list.size() > 0) {
                return list.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public Set<String> getParameterNames() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.parameterMap.keySet());
        return hashSet;
    }

    @Override
    public String[] getParameterValues(String string) {
        List<String> list = this.parameterMap.get(string);
        if (list != null) {
            String[] stringArray = new String[list.size()];
            Iterator<String> iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                stringArray[n] = iterator.next();
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    @Override
    public Map<String, List<String>> getParameterMap() {
        return this.parameterMap;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.msgBytes);
    }

    @Override
    public String getProtocol() {
        return this.getHeader("protocol");
    }

    @Override
    public String getScheme() {
        return "http";
    }

    @Override
    public String getServerName() {
        return MediaStreamBase.p + " " + ReleaseInfo.getVersion() + " build" + ReleaseInfo.getBuildNumber();
    }

    @Override
    public int getServerPort() {
        return this.req.getHostPort().getPort();
    }

    @Override
    public String getRemoteAddr() {
        return this.req.getSessionInfo().getIpAddress();
    }

    @Override
    public String getRemoteHost() {
        return this.req.getSessionInfo().getIpAddress();
    }

    @Override
    public boolean isSecure() {
        return this.req.getSessionInfo().isSSL();
    }

    @Override
    public Locale getLocale() {
        String string = this.getHeader("accept-language");
        if (string == null) {
            string = "en-us";
        }
        return new Locale(string);
    }
}

