/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.model;

import com.wowza.util.RandomIdGenerator;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.HTTPStreamerSessionCupertino;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSessionNotify;
import com.wowza.wms.httpstreamer.sanjosestreaming.httpstreamer.HTTPStreamerSessionSanJose;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.HTTPStreamerSessionSmoothStreamer;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.Server;
import com.wowza.wms.vhost.IVHost;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPStreamerSessions {
    private Map<String, IHTTPStreamerSession> sessions = new HashMap<String, IHTTPStreamerSession>();
    private IVHost vhost = null;
    private List<IHTTPStreamerSessionNotify> listeners = new ArrayList<IHTTPStreamerSessionNotify>();

    public HTTPStreamerSessions(IVHost iVHost) {
        this.vhost = iVHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTimeout(long l) {
        List<String> list = this.getSessionIds();
        for (String string : list) {
            Object object;
            IHTTPStreamerSession iHTTPStreamerSession = this.getSession(string);
            if (iHTTPStreamerSession == null) continue;
            boolean bl = false;
            Object object2 = object = iHTTPStreamerSession.getLock();
            synchronized (object2) {
                if (iHTTPStreamerSession.isTimeout(l)) {
                    iHTTPStreamerSession.shutdown();
                    bl = true;
                }
            }
            if (!bl) continue;
            try {
                this.notifySessionDestroy(iHTTPStreamerSession);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(HTTPStreamerSessions.class).error("HTTPStreamerSessions.checkTimeout: notifySessionDestroy: " + exception.toString());
            }
            object2 = iHTTPStreamerSession.getAppInstance();
            if (object2 != null) {
                try {
                    object2.getModFunctions().onHTTPSessionDestroy(iHTTPStreamerSession);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(HTTPStreamerSessions.class).error("HTTPStreamerSessions.checkTimeout: onHTTPSessionDestroy: " + exception.toString());
                }
                if (iHTTPStreamerSession instanceof HTTPStreamerSessionCupertino) {
                    try {
                        object2.getModFunctions().onHTTPCupertinoStreamingSessionDestroy((HTTPStreamerSessionCupertino)iHTTPStreamerSession);
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(HTTPStreamerSessions.class).error("HTTPStreamerSessions.checkTimeout: onHTTPCupertinoStreamingSessionDestroy: " + exception.toString());
                    }
                }
                if (iHTTPStreamerSession instanceof HTTPStreamerSessionSmoothStreamer) {
                    try {
                        object2.getModFunctions().onHTTPSmoothStreamingSessionDestroy((HTTPStreamerSessionSmoothStreamer)iHTTPStreamerSession);
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(HTTPStreamerSessions.class).error("HTTPStreamerSessions.checkTimeout: onHTTPSmoothStreamingSessionDestroy: " + exception.toString());
                    }
                }
                if (iHTTPStreamerSession.getSessionProtocol() == 2) {
                    try {
                        object2.getModFunctions().onHTTPSanJoseStreamingSessionDestroy((HTTPStreamerSessionSanJose)iHTTPStreamerSession);
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(HTTPStreamerSessions.class).error("HTTPStreamerSessions.checkTimeout: onHTTPSanJoseStreamingSessionDestroy: " + exception.toString());
                    }
                }
            }
            this.removeSession(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSessionIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<String, IHTTPStreamerSession> map = this.sessions;
        synchronized (map) {
            arrayList.addAll(this.sessions.keySet());
        }
        return arrayList;
    }

    public String getNextSessionId() {
        return this.getNextSessionId(null);
    }

    public String getNextSessionId(String string) {
        int n = -1;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        RandomIdGenerator randomIdGenerator = Server.getInstance().getClientIdGenerator();
        int n2 = -1;
        if (n > 0) {
            n2 = randomIdGenerator.tryToGetId(n);
        }
        if (n2 <= 0) {
            n2 = randomIdGenerator.getNextId();
        }
        return n2 + "";
    }

    public void releaseSessionId(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n >= 0) {
            Server.getInstance().getClientIdGenerator().releaseId(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHTTPStreamerSession getSession(String string) {
        IHTTPStreamerSession iHTTPStreamerSession = null;
        Map<String, IHTTPStreamerSession> map = this.sessions;
        synchronized (map) {
            iHTTPStreamerSession = this.sessions.get(string);
        }
        return iHTTPStreamerSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHTTPStreamerSession removeSession(String string) {
        IHTTPStreamerSession iHTTPStreamerSession = null;
        Map<String, IHTTPStreamerSession> map = this.sessions;
        synchronized (map) {
            iHTTPStreamerSession = this.sessions.remove(string);
        }
        this.releaseSessionId(string);
        return iHTTPStreamerSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHTTPStreamerSession removeSession(IHTTPStreamerSession iHTTPStreamerSession) {
        IHTTPStreamerSession iHTTPStreamerSession2 = null;
        Map<String, IHTTPStreamerSession> map = this.sessions;
        synchronized (map) {
            iHTTPStreamerSession2 = this.sessions.remove(iHTTPStreamerSession.getSessionId());
        }
        this.releaseSessionId(iHTTPStreamerSession.getSessionId());
        return iHTTPStreamerSession2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHTTPStreamerSession addSession(IHTTPStreamerSession iHTTPStreamerSession) {
        Map<String, IHTTPStreamerSession> map = this.sessions;
        synchronized (map) {
            iHTTPStreamerSession.setVHost(this.vhost);
            this.sessions.put(iHTTPStreamerSession.getSessionId(), iHTTPStreamerSession);
        }
        return iHTTPStreamerSession;
    }

    public IVHost getVHost() {
        return this.vhost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(IHTTPStreamerSessionNotify iHTTPStreamerSessionNotify) {
        List<IHTTPStreamerSessionNotify> list = this.listeners;
        synchronized (list) {
            this.listeners.add(iHTTPStreamerSessionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionListener(IHTTPStreamerSessionNotify iHTTPStreamerSessionNotify) {
        List<IHTTPStreamerSessionNotify> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(iHTTPStreamerSessionNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySessionCreate(IHTTPStreamerSession iHTTPStreamerSession) {
        ArrayList<IHTTPStreamerSessionNotify> arrayList = null;
        List<IHTTPStreamerSessionNotify> list = this.listeners;
        synchronized (list) {
            arrayList = new ArrayList<IHTTPStreamerSessionNotify>(this.listeners);
        }
        for (IHTTPStreamerSessionNotify iHTTPStreamerSessionNotify : arrayList) {
            iHTTPStreamerSessionNotify.onHTTPStreamerSessionCreate(iHTTPStreamerSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySessionDestroy(IHTTPStreamerSession iHTTPStreamerSession) {
        ArrayList<IHTTPStreamerSessionNotify> arrayList = null;
        List<IHTTPStreamerSessionNotify> list = this.listeners;
        synchronized (list) {
            arrayList = new ArrayList<IHTTPStreamerSessionNotify>(this.listeners);
        }
        for (IHTTPStreamerSessionNotify iHTTPStreamerSessionNotify : arrayList) {
            iHTTPStreamerSessionNotify.onHTTPStreamerSessionDestroy(iHTTPStreamerSession);
        }
    }
}

