/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.logging;

import com.wowza.util.SystemUtils;
import com.wowza.wms.logging.WMSLoggerIDs;
import com.wowza.wms.server.ReleaseInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.spi.LoggingEvent;

public class ECLFPatternLayout
extends PatternLayout {
    private StringBuffer sbuf = new StringBuffer(256);
    private StringBuffer tbuf = new StringBuffer(256);
    private String pattern;
    private PatternConverter head;
    public static final String LINE_SEP = System.getProperty("line.separator");
    private String header = null;
    private String fields = null;
    private String outputHeader = "false";
    private List categoryInclude = null;
    private List eventInclude = null;
    private List categoryExclude = null;
    private List eventExclude = null;
    private String delimeterChar = "\t";
    private boolean quoteFields = false;

    public ECLFPatternLayout() {
    }

    public ECLFPatternLayout(String string) {
        this.pattern = string;
        this.head = this.createPatternParser(string == null ? "%m%n" : string).parse();
    }

    public void setConversionPattern(String string) {
        this.pattern = string;
        this.head = this.createPatternParser(string).parse();
    }

    public void setHeader(String string) {
        this.header = string;
    }

    public void setOutputHeader(String string) {
        this.outputHeader = string.trim();
    }

    public void setQuoteFields(String string) {
        this.quoteFields = string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("true");
        this.updateFields();
    }

    public void setDelimeter(String string) {
        this.delimeterChar = string.equalsIgnoreCase("tab") ? "\t" : (string.equalsIgnoreCase("space") ? " " : string);
        this.updateFields();
    }

    public void setCategoryInclude(String string) {
        int n;
        String[] stringArray = string.replace(";", ",").split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < WMSLoggerIDs.CAT_ALL.length; ++n) {
            arrayList.add(WMSLoggerIDs.CAT_ALL[n]);
        }
        this.categoryInclude = null;
        for (n = 0; n < stringArray.length; ++n) {
            String string2 = stringArray[n].trim().toLowerCase();
            if (!arrayList.contains(string2)) {
                System.out.println("Log file configuration error: Invalid category name in CategoryInclude: " + string2);
                continue;
            }
            if (this.categoryInclude == null) {
                this.categoryInclude = new ArrayList();
            }
            this.categoryInclude.add(string2);
        }
    }

    public void setCategoryExclude(String string) {
        int n;
        String[] stringArray = string.replace(";", ",").split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < WMSLoggerIDs.CAT_ALL.length; ++n) {
            arrayList.add(WMSLoggerIDs.CAT_ALL[n]);
        }
        this.categoryExclude = null;
        for (n = 0; n < stringArray.length; ++n) {
            String string2 = stringArray[n].trim().toLowerCase();
            if (!arrayList.contains(string2)) {
                System.out.println("Log file configuration error: Invalid category name in CategoryExclude: " + string2);
                continue;
            }
            if (this.categoryExclude == null) {
                this.categoryExclude = new ArrayList();
            }
            this.categoryExclude.add(string2);
        }
    }

    public void setEventInclude(String string) {
        int n;
        String[] stringArray = string.replace(";", ",").split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < WMSLoggerIDs.EVT_ALL.length; ++n) {
            arrayList.add(WMSLoggerIDs.EVT_ALL[n]);
        }
        this.eventInclude = null;
        for (n = 0; n < stringArray.length; ++n) {
            String string2 = stringArray[n].trim().toLowerCase();
            if (!arrayList.contains(string2)) {
                System.out.println("Log file configuration error: Invalid event name in EventInclude: " + string2);
                continue;
            }
            if (this.eventInclude == null) {
                this.eventInclude = new ArrayList();
            }
            this.eventInclude.add(string2);
        }
    }

    public void setEventExclude(String string) {
        int n;
        String[] stringArray = string.replace(";", ",").split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < WMSLoggerIDs.EVT_ALL.length; ++n) {
            arrayList.add(WMSLoggerIDs.EVT_ALL[n]);
        }
        this.eventExclude = null;
        for (n = 0; n < stringArray.length; ++n) {
            String string2 = stringArray[n].trim().toLowerCase();
            if (!arrayList.contains(string2)) {
                System.out.println("Log file configuration error: Invalid event name in EventExclude: " + string2);
                continue;
            }
            if (this.eventExclude == null) {
                this.eventExclude = new ArrayList();
            }
            this.eventExclude.add(string2);
        }
    }

    public void setFields(String string) {
        this.fields = string;
        this.updateFields();
    }

    private void updateFields() {
        if (this.fields != null && this.fields.length() > 0) {
            String[] stringArray = this.fields.replace(";", ",").split(",");
            String string = "";
            String string2 = "#Version: 1.0%n#Start-Date: %d{yyyy-MM-dd} %d{HH:mm:ss} %d{z}%n#Software: " + ReleaseInfo.getProject() + " " + ReleaseInfo.getVersion() + " build" + ReleaseInfo.getBuildNumber() + "%n#Date: %d{yyyy-MM-dd}%n#Fields: ";
            for (int i = 0; i < stringArray.length; ++i) {
                if (string.length() > 0) {
                    string = string + this.delimeterChar;
                    string2 = string2 + this.delimeterChar;
                }
                string = string + (this.quoteFields ? "\"" : "") + "%X{" + stringArray[i].trim() + "}" + (this.quoteFields ? "\"" : "");
                string2 = string2 + stringArray[i].trim();
            }
            this.setConversionPattern(string + "%n");
            this.setHeader(string2 + "%n");
        }
    }

    public String format(LoggingEvent loggingEvent) {
        String string;
        boolean bl = true;
        if (this.categoryInclude != null || this.categoryExclude != null) {
            string = (String)loggingEvent.getMDC("x-category");
            if (this.categoryInclude != null) {
                bl = false;
                if (this.categoryInclude.contains(string)) {
                    bl = true;
                }
            }
            if (this.categoryExclude != null && this.categoryExclude.contains(string)) {
                bl = false;
            }
            if (!bl) {
                return "";
            }
        }
        if (this.eventInclude != null || this.eventExclude != null) {
            string = (String)loggingEvent.getMDC("x-event");
            if (this.eventInclude != null) {
                bl = false;
                if (this.eventInclude.contains(string)) {
                    bl = true;
                }
            }
            if (this.eventExclude != null && this.eventExclude.contains(string)) {
                bl = false;
            }
            if (!bl) {
                return "";
            }
        }
        if (this.sbuf.capacity() > 1024) {
            this.sbuf = new StringBuffer(256);
        } else {
            this.sbuf.setLength(0);
        }
        string = this.head;
        while (string != null) {
            if (string.getClass().getName().equals("org.apache.log4j.helpers.PatternParser$BasicPatternConverter")) {
                this.tbuf.setLength(0);
                string.format(this.tbuf, loggingEvent);
                if (this.quoteFields) {
                    this.sbuf.append(this.tbuf.toString().replace("\"", "\"\"").replace("\n", " ").replace("\t", " "));
                } else if (this.tbuf.length() == 0) {
                    this.sbuf.append("-");
                } else {
                    this.sbuf.append(this.tbuf.toString().replace("\n", " ").replace("\t", " "));
                }
            } else {
                this.tbuf.setLength(0);
                string.format(this.tbuf, loggingEvent);
                if (!this.quoteFields && this.tbuf.length() == 0) {
                    this.sbuf.append("-");
                } else {
                    this.sbuf.append(this.tbuf);
                }
            }
            string = ((PatternConverter)string).next;
        }
        return this.sbuf.toString();
    }

    public String getHeader() {
        int n = 0;
        if (!this.outputHeader.trim().equalsIgnoreCase("yes") && !this.outputHeader.trim().equalsIgnoreCase("true")) {
            return "";
        }
        if (this.header != null) {
            String string = "";
            String string2 = this.header;
            Date date = new Date();
            Pattern pattern = Pattern.compile("\\%d\\{[^}]*\\}");
            Matcher matcher = pattern.matcher(string2);
            while (matcher.find()) {
                String string3 = matcher.group().substring(3, matcher.group().length() - 1);
                string = string + string2.substring(n, matcher.start());
                FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)string3, (TimeZone)SystemUtils.defaultTimeZone, (Locale)SystemUtils.defaultLocale);
                string = string + fastDateFormat.format(date);
                n = matcher.end();
            }
            string = string + string2.substring(n, string2.length());
            string = string.replace("%n", LINE_SEP);
            return string;
        }
        return this.header;
    }
}

