/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.logging;

import com.wowza.wms.logging.ILogNotify;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;

public class LogNotifyCalculateIncremental
implements ILogNotify {
    public static final String FD_cs_bytes_inc = "cs-bytes-inc";
    public static final String FD_sc_bytes_inc = "sc-bytes-inc";
    public static final String FD_cs_stream_bytes_inc = "cs-stream-bytes-inc";
    public static final String FD_sc_stream_bytes_inc = "sc-stream-bytes-inc";
    public static final String FD_x_duration_inc = "x-duration-inc";
    Map<String, ClientLogInfo> clientList = new HashMap<String, ClientLogInfo>();
    Map<String, StreamLogInfo> streamList = new HashMap<String, StreamLogInfo>();

    public void onLog(Level level, String string, IMediaStream iMediaStream, String string2, String string3, int n, String string4) {
        try {
            WMSLoggerFactory.removeGlobalLogValue(FD_cs_bytes_inc);
            WMSLoggerFactory.removeGlobalLogValue(FD_sc_bytes_inc);
            WMSLoggerFactory.removeGlobalLogValue(FD_cs_stream_bytes_inc);
            WMSLoggerFactory.removeGlobalLogValue(FD_sc_stream_bytes_inc);
            WMSLoggerFactory.removeGlobalLogValue(FD_x_duration_inc);
            if (string2.equals("session")) {
                String string5 = (String)WMSLoggerFactory.getGlobalLogValue("x-vhost");
                String string6 = ((Integer)WMSLoggerFactory.getGlobalLogValue("c-client-id")).toString();
                String string7 = string5 + "." + string6;
                long l = (Long)WMSLoggerFactory.getGlobalLogValue("cs-bytes");
                long l2 = (Long)WMSLoggerFactory.getGlobalLogValue("sc-bytes");
                double d = (Double)WMSLoggerFactory.getGlobalLogValue("x-duration");
                ClientLogInfo clientLogInfo = this.clientList.get(string7);
                if (clientLogInfo == null) {
                    clientLogInfo = new ClientLogInfo(l, l2, d);
                    this.clientList.put(string7, clientLogInfo);
                    l = 0L;
                    l2 = 0L;
                    d = 0.0;
                } else {
                    l = clientLogInfo.setCSBytes(l);
                    l2 = clientLogInfo.setSCBytes(l2);
                    d = clientLogInfo.setDuration(d);
                }
                WMSLoggerFactory.putGlobalLogValue(FD_cs_bytes_inc, new Long(l));
                WMSLoggerFactory.putGlobalLogValue(FD_sc_bytes_inc, new Long(l2));
                WMSLoggerFactory.putGlobalLogValue(FD_x_duration_inc, new Double(d));
                if (string3.equals("disconnect")) {
                    this.clientList.remove(string7);
                }
            } else if (string2.equals("stream")) {
                String string8 = (String)WMSLoggerFactory.getGlobalLogValue("x-vhost");
                if (string8 == null) {
                    string8 = "unknown";
                }
                String string9 = "clientless";
                if (WMSLoggerFactory.getGlobalLogValue("c-client-id") != null) {
                    string9 = ((Integer)WMSLoggerFactory.getGlobalLogValue("c-client-id")).toString();
                }
                String string10 = "unknown";
                if (iMediaStream != null) {
                    string10 = iMediaStream.getSrc() + "";
                }
                String string11 = string8 + "." + string9 + "." + string10;
                long l = (Long)WMSLoggerFactory.getGlobalLogValue("cs-stream-bytes");
                long l3 = (Long)WMSLoggerFactory.getGlobalLogValue("sc-stream-bytes");
                double d = (Double)WMSLoggerFactory.getGlobalLogValue("x-duration");
                StreamLogInfo streamLogInfo = this.streamList.get(string11);
                if (streamLogInfo == null) {
                    streamLogInfo = new StreamLogInfo(l, l3, d);
                    this.streamList.put(string11, streamLogInfo);
                    l = 0L;
                    l3 = 0L;
                    d = 0.0;
                } else {
                    l = streamLogInfo.setStreamCSBytes(l);
                    l3 = streamLogInfo.setStreamSCBytes(l3);
                    d = streamLogInfo.setDuration(d);
                }
                WMSLoggerFactory.putGlobalLogValue(FD_cs_stream_bytes_inc, new Long(l));
                WMSLoggerFactory.putGlobalLogValue(FD_sc_stream_bytes_inc, new Long(l3));
                WMSLoggerFactory.putGlobalLogValue(FD_x_duration_inc, new Double(d));
                if (string3.equals("destroy")) {
                    this.streamList.remove(string11);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class ClientLogInfo {
        long cs_bytes = 0L;
        long sc_bytes = 0L;
        double x_duration = 0.0;

        public ClientLogInfo(long l, long l2, double d) {
            this.cs_bytes = l;
            this.sc_bytes = l2;
            this.x_duration = d;
        }

        public long setCSBytes(long l) {
            long l2 = l - this.cs_bytes;
            this.cs_bytes = l;
            if (l2 < 0L) {
                l2 = 0L;
            }
            return l2;
        }

        public long setSCBytes(long l) {
            long l2 = l - this.sc_bytes;
            this.sc_bytes = l;
            if (l2 < 0L) {
                l2 = 0L;
            }
            return l2;
        }

        public double setDuration(double d) {
            double d2 = d - this.x_duration;
            this.x_duration = d;
            if (d2 < 0.0) {
                d2 = 0.0;
            }
            return (double)Math.round(d2 * 1000.0) / 1000.0;
        }
    }

    class StreamLogInfo {
        long cs_stream_bytes = 0L;
        long sc_stream_bytes = 0L;
        double x_duration = 0.0;

        public StreamLogInfo(long l, long l2, double d) {
            this.cs_stream_bytes = l;
            this.sc_stream_bytes = l2;
            this.x_duration = d;
        }

        public long setStreamCSBytes(long l) {
            long l2 = l - this.cs_stream_bytes;
            this.cs_stream_bytes = l;
            if (l2 < 0L) {
                l2 = 0L;
            }
            return l2;
        }

        public long setStreamSCBytes(long l) {
            long l2 = l - this.sc_stream_bytes;
            this.sc_stream_bytes = l;
            if (l2 < 0L) {
                l2 = 0L;
            }
            return l2;
        }

        public double setDuration(double d) {
            double d2 = d - this.x_duration;
            this.x_duration = d;
            if (d2 < 0.0) {
                d2 = 0.0;
            }
            return (double)Math.round(d2 * 1000.0) / 1000.0;
        }
    }
}

