/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.media.h263;

import com.wowza.util.BitReader;
import com.wowza.util.BitWriter;
import com.wowza.wms.media.h263.H263Frame;

public class H263Utils {
    public static final int[][] H263FRAMESIZES = new int[][]{{0, 0}, {128, 96}, {176, 144}, {352, 288}, {704, 576}, {1408, 1152}};
    public static final int[][] PIXELASPECT = new int[][]{{0, 1}, {1, 1}, {12, 11}, {10, 11}, {16, 11}, {40, 33}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}, {0, 1}};
    public static final int[] MBAMAX = new int[]{47, 98, 395, 1583, 6335, 9215};
    public static final int[] MBAMAXLEN = new int[]{6, 7, 9, 11, 13, 14, 14};

    public static H263Frame decodeH263Header(byte[] byArray, int n) {
        BitReader bitReader = new BitReader(byArray);
        bitReader.skip(n * 8);
        return H263Utils.decodeH263Header(bitReader);
    }

    public static void encodeSorensonSparkHeader(BitWriter bitWriter, H263Frame h263Frame) {
        bitWriter.putInt(17, 1);
        bitWriter.putInt(5, 0);
        bitWriter.putInt(8, h263Frame.timeStamp);
        int n = -1;
        n = h263Frame.width == 352 && h263Frame.height == 288 ? 2 : (h263Frame.width == 176 && h263Frame.height == 144 ? 3 : (h263Frame.width == 128 && h263Frame.height == 96 ? 4 : (h263Frame.width == 320 && h263Frame.height == 240 ? 5 : (h263Frame.width == 160 && h263Frame.height == 120 ? 6 : (h263Frame.width <= 255 && h263Frame.height <= 255 ? 0 : 1)))));
        bitWriter.putInt(3, n);
        if (n == 0) {
            bitWriter.putInt(8, h263Frame.width);
            bitWriter.putInt(8, h263Frame.height);
        } else if (n == 1) {
            bitWriter.putInt(16, h263Frame.width);
            bitWriter.putInt(16, h263Frame.height);
        }
        bitWriter.putInt(2, h263Frame.frameType);
        bitWriter.putInt(1, 1);
        bitWriter.putInt(5, h263Frame.qscale);
        bitWriter.putInt(1, 0);
    }

    public static H263Frame decodeSorensonSparkHeader(BitReader bitReader) {
        H263Frame h263Frame = new H263Frame();
        try {
            bitReader.skip(17);
            h263Frame.escape_code_type = bitReader.getInt(5);
            System.out.println("ret.escape_code_type: " + h263Frame.escape_code_type);
            h263Frame.timeStamp = bitReader.getInt(8);
            System.out.println("ret.timeStamp: " + h263Frame.timeStamp);
            h263Frame.format = bitReader.getInt(3);
            System.out.println("ret.format: " + h263Frame.format);
            if (h263Frame.format == 2) {
                h263Frame.width = 352;
                h263Frame.height = 288;
            } else if (h263Frame.format == 3) {
                h263Frame.width = 176;
                h263Frame.height = 144;
            } else if (h263Frame.format == 4) {
                h263Frame.width = 128;
                h263Frame.height = 96;
            } else if (h263Frame.format == 5) {
                h263Frame.width = 320;
                h263Frame.height = 240;
            } else if (h263Frame.format == 6) {
                h263Frame.width = 160;
                h263Frame.height = 120;
            } else if (h263Frame.format == 0) {
                h263Frame.width = bitReader.getInt(8);
                h263Frame.height = bitReader.getInt(8);
            } else if (h263Frame.format == 1) {
                h263Frame.width = bitReader.getInt(16);
                h263Frame.height = bitReader.getInt(16);
            }
            h263Frame.frameType = bitReader.getInt(2);
            int n = bitReader.getInt(1);
            h263Frame.qscale = bitReader.getInt(5);
            int n2 = bitReader.getInt(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return h263Frame;
    }

    public static void encodeH263Header(BitWriter bitWriter, H263Frame h263Frame) {
        try {
            bitWriter.putInt(6, 32);
            bitWriter.putInt(8, h263Frame.timeStamp);
            bitWriter.putInt(1, 1);
            bitWriter.putInt(1, 0);
            bitWriter.putInt(1, 0);
            bitWriter.putInt(1, 0);
            bitWriter.putInt(1, 0);
            System.out.println("encodeH263.frameSize: " + h263Frame.width + "x" + h263Frame.height);
            int n = 0;
            if (h263Frame.width == 128 && h263Frame.height == 96) {
                n = 1;
            } else if (h263Frame.width == 176 && h263Frame.height == 144) {
                n = 2;
            } else if (h263Frame.width == 352 && h263Frame.height == 288) {
                n = 3;
            } else if (h263Frame.width == 704 && h263Frame.height == 576) {
                n = 4;
            } else if (h263Frame.width == 1408 && h263Frame.height == 1152) {
                n = 5;
            }
            bitWriter.putInt(3, n);
            if (n != 7 && n != 6) {
                bitWriter.putInt(1, h263Frame.frameType >= 1 ? 1 : 0);
                bitWriter.putInt(1, 0);
                bitWriter.putInt(1, 0);
                bitWriter.putInt(1, 0);
                bitWriter.putInt(1, h263Frame.frameType > 1 ? 1 : 0);
                bitWriter.putInt(5, h263Frame.qscale);
                bitWriter.putInt(1, 0);
            } else {
                System.out.println("H263Utils.encodeH263Header: Cannot handle frame size: " + h263Frame.width + "x" + h263Frame.height);
            }
            bitWriter.putInt(1, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static H263Frame decodeH263Header(BitReader bitReader) {
        H263Frame h263Frame = new H263Frame();
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6 = bitReader.getInt(6);
            System.out.println("startCode: " + Integer.toHexString(0xFF & n6));
            h263Frame.timeStamp = bitReader.getInt(8);
            int n7 = bitReader.getInt(1);
            System.out.println("marker: " + n7);
            int n8 = bitReader.getInt(1);
            System.out.println("h263Id: " + n8);
            int n9 = bitReader.getInt(1);
            int n10 = bitReader.getInt(1);
            int n11 = bitReader.getInt(1);
            if (n9 > 0 || n10 > 0 || n11 > 0) {
                System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&& isKEY?");
            }
            h263Frame.format = bitReader.getInt(3);
            System.out.println("format: " + h263Frame.format);
            boolean bl = false;
            if (h263Frame.format != 7 && h263Frame.format != 6) {
                h263Frame.width = H263FRAMESIZES[h263Frame.format][0];
                h263Frame.height = H263FRAMESIZES[h263Frame.format][1];
                h263Frame.frameType = bitReader.getInt(1);
                h263Frame.unrestrictedMotionVector = bitReader.getInt(1);
                System.out.println("unrestrictedMotionVector: " + h263Frame.unrestrictedMotionVector);
                n5 = bitReader.getInt(1);
                System.out.println("isSac: " + n5);
                n4 = bitReader.getInt(1);
                System.out.println("obmc: " + n4);
                n3 = h263Frame.unrestrictedMotionVector > 0 || n4 > 0 ? 1 : 0;
                System.out.println("unrestricted_mv: " + (n3 != 0));
                n2 = bitReader.getInt(1);
                System.out.println("pbFrame: " + n2);
                h263Frame.qscale = bitReader.getInt(5);
                System.out.println("qscale: " + h263Frame.qscale);
                n = bitReader.getInt(1);
                System.out.println("cpMultipoint: " + n);
            } else {
                n5 = bitReader.getInt(3);
                n4 = 0;
                n3 = 0;
                if (n5 == 1) {
                    h263Frame.format = bitReader.getInt(3);
                    n4 = bitReader.getInt(1);
                    n3 = bitReader.getInt(1);
                    n2 = bitReader.getInt(1);
                    n = bitReader.getInt(1);
                    System.out.println("obmc: " + n);
                    int n12 = bitReader.getInt(1);
                    int n13 = bitReader.getInt(1);
                    boolean bl2 = n3 > 0 || n > 0 || n13 > 0;
                    bl = bitReader.getInt(1) > 0;
                    int n14 = bitReader.getInt(1);
                    int n15 = bitReader.getInt(1);
                    int n16 = bitReader.getInt(1);
                    int n17 = bitReader.getInt(1);
                    int n18 = bitReader.getInt(1);
                    int n19 = bitReader.getInt(3);
                }
                h263Frame.frameType = bitReader.getInt(3);
                bitReader.skip(2);
                n2 = bitReader.getInt(1);
                bitReader.skip(4);
                if (n5 > 0) {
                    if (h263Frame.format == 6) {
                        h263Frame.aspect_ratio_info = bitReader.getInt(4);
                        h263Frame.width = (bitReader.getInt(9) + 1) * 4;
                        bitReader.skip(1);
                        h263Frame.height = bitReader.getInt(9) * 4;
                        if (h263Frame.aspect_ratio_info == 15) {
                            h263Frame.aspect_ratio_num = bitReader.getInt(8);
                            h263Frame.aspect_ratio_den = bitReader.getInt(8);
                        } else {
                            h263Frame.aspect_ratio_num = PIXELASPECT[h263Frame.aspect_ratio_info][0];
                            h263Frame.aspect_ratio_den = PIXELASPECT[h263Frame.aspect_ratio_info][1];
                        }
                    } else {
                        h263Frame.width = H263FRAMESIZES[h263Frame.format][0];
                        h263Frame.height = H263FRAMESIZES[h263Frame.format][1];
                        h263Frame.aspect_ratio_num = 12;
                        h263Frame.aspect_ratio_den = 11;
                    }
                    if (n4 > 0) {
                        h263Frame.time_base_den = 1800000;
                        h263Frame.time_base_num = 1000 + bitReader.getInt(1);
                        h263Frame.time_base_num *= bitReader.getInt(7);
                    } else {
                        h263Frame.time_base_den = 1001;
                        h263Frame.time_base_num = 30000;
                    }
                }
                if (n4 > 0) {
                    bitReader.skip(2);
                }
                if (n5 > 0) {
                    if (n3 > 0 && bitReader.getInt(1) > 0) {
                        bitReader.skip(1);
                    }
                    if (bl) {
                        bitReader.skip(2);
                    }
                }
                h263Frame.qscale = bitReader.getInt(5);
            }
            System.out.println("frameType: " + h263Frame.frameType);
            if (h263Frame.frameType == 0) {
                System.out.println("************************************ KEY ");
            }
            n5 = (h263Frame.width + 15) / 16;
            n4 = (h263Frame.height + 15) / 16;
            n3 = n5 * n4;
            while (bitReader.getInt(1) != 0) {
                System.out.println("skipPEI");
                bitReader.skip(8);
            }
            if (bl) {
                bitReader.skip(1);
                for (n2 = 0; n2 < 6 && n3 - 1 > MBAMAX[n2]; ++n2) {
                }
                n = bitReader.getInt(MBAMAXLEN[n2]);
                bitReader.skip(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return h263Frame;
    }
}

