/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.media.h264;

import com.wowza.wms.media.h264.H264Utils;

public class H264CodecConfigInfo {
    public int profileIDC = 0;
    public int levelIDC = 0;
    public int spsID = 0;
    public int chromaFormatIDC = 0;
    public int residualColorTransformFlag = 0;
    public int bitDepthLumaMinus8 = 0;
    public int bitDepthChromaMinus8 = 0;
    public int transformBypass = 0;
    public int scalingMatrixFlag = 0;
    public int log2MaxFrameNum = 0;
    public int pocType = 0;
    public int log2MaxPocLSB = 0;
    public int deltaPicOrderAlwaysZeroFlag = 0;
    public int offsetForNonRefPic = 0;
    public int offsetForTopToBottomField = 0;
    public int pocCycleLength = 0;
    public int[] offsetForRefFrame = null;
    public int refFrameCount = 0;
    public int gapsInFrameNumAllowedFlag = 0;
    public int mbWidth = 0;
    public int mbHeight = 0;
    public int frameMBSOnlyFlag = 0;
    public int mbAFF = 0;
    public int adjWidth = 0;
    public int adjHeight = 0;
    public int direct8x8InferenceFlag = 0;
    public int crop = 0;
    public int cropLeft = 0;
    public int cropRight = 0;
    public int cropTop = 0;
    public int cropBottom = 0;
    public int vuiParametersPresentFlag = 0;
    public int sarNum = 0;
    public int sarDen = 0;
    public int aspectRatioIDC = 0;
    public int aspectRatioInfoPresentFlag = 0;
    public int height = 0;
    public int width = 0;
    public int displayHeight = 0;
    public int displayWidth = 0;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{H264CodecConfigInfo: ");
        stringBuffer.append("profile: \"" + H264Utils.profileIDCToString(this.profileIDC) + "\", ");
        stringBuffer.append("level: " + H264Utils.levelIDCToString(this.levelIDC) + ", ");
        stringBuffer.append("frameSize: " + this.width + "x" + this.height + ", ");
        stringBuffer.append("displaySize: " + this.displayWidth + "x" + this.displayHeight + ", ");
        if (this.sarNum > 0 && this.sarDen > 0) {
            stringBuffer.append("PAR: " + this.sarNum + ":" + this.sarDen + ", ");
        }
        if (this.cropLeft > 0 || this.cropRight > 0 || this.cropTop > 0 || this.cropBottom > 0) {
            stringBuffer.append("crop: l:" + this.cropLeft + " r:" + this.cropRight + " t:" + this.cropTop + " b:" + this.cropBottom + ", ");
        }
        if (this.mbAFF > 0) {
            stringBuffer.append("mbAFF: true, ");
        }
        stringBuffer.setLength(stringBuffer.length() - 2);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

