/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.media.mp3.model.idtags;

import com.wowza.util.BufferUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FrameBase;
import java.io.File;
import java.io.RandomAccessFile;

public class ID3V2FrameAttachedPicture
extends ID3V2FrameBase {
    public static final int PICTURETYPE_OTHER = 0;
    public static final int PICTURETYPE_FILEICON = 1;
    public static final int PICTURETYPE_OTHERFILEICON = 2;
    public static final int PICTURETYPE_COVERFRONT = 3;
    public static final int PICTURETYPE_COVERBACK = 4;
    public static final int PICTURETYPE_MOVIESCREENCAPTURE = 16;
    public static final int PICTURETYPE_ILLUSTRATION = 18;
    public static final int PICTURETYPE_ARTISTLOGO = 19;
    public static final int PICTURETYPE_PUBLISHERLOGO = 20;
    public static final String MIMETYPES_JPEG = "image/jpeg";
    public static final String MIMETYPES_PNG = "image/png";
    public static final String MIMETYPES_URL = "-->";
    private int textEncoding = 3;
    private String mimeType = "image/jpeg";
    private int pictureType = 16;
    private String description = "";
    private byte[] pictureData = null;
    public static long PICTUREMAXFILESIZE = 0x100000L;

    public ID3V2FrameAttachedPicture(String string, int n) {
        super(string, n);
    }

    public ID3V2FrameAttachedPicture() {
        super("APIC", 0);
    }

    public int serializeBody(byte[] byArray, int n) {
        int n2 = 0;
        try {
            byArray[n + n2] = (byte)(this.textEncoding & 0xFF);
            int n3 = ID3V2FrameAttachedPicture.serializeString(this.mimeType, byArray, n + ++n2);
            byArray[n + (n2 += n3)] = (byte)(this.pictureType & 0xFF);
            n3 = ID3V2FrameAttachedPicture.serializeString(this.description, byArray, n + ++n2);
            n2 += n3;
            if (this.pictureData != null) {
                System.arraycopy(this.pictureData, 0, byArray, n + n2, this.pictureData.length);
                n2 += this.pictureData.length;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ID3V2FrameBase.class).error("ID3V2FrameAPIC.deserializeBody: " + exception.toString());
        }
        return n2;
    }

    public void deserializeBody(byte[] byArray, int n, int n2) {
        try {
            if (n + 1 < n2) {
                String string;
                this.textEncoding = byArray[n] & 0xFF;
                if ((string = ID3V2FrameAttachedPicture.deserializeString(byArray, ++n, n2)) != null) {
                    this.mimeType = string;
                    if ((n += string.length() + 1) + 1 < n2) {
                        String string2;
                        this.pictureType = byArray[n] & 0xFF;
                        if ((string2 = ID3V2FrameAttachedPicture.deserializeString(byArray, ++n, n2)) != null) {
                            this.description = string2;
                            int n3 = n2 - (n += string2.length() + 1);
                            if (n3 > 0) {
                                this.pictureData = new byte[n3];
                                System.arraycopy(byArray, n, this.pictureData, 0, n3);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ID3V2FrameBase.class).error("ID3V2FrameAPIC.deserializeBody: " + exception.toString());
        }
    }

    public String getMapIdStr() {
        String string = Integer.toHexString(this.pictureType);
        if (string.length() < 2) {
            string = "0" + string;
        }
        return this.getIdStr() + ":0x" + string;
    }

    public int getBodySize() {
        int n = 1 + ID3V2FrameAttachedPicture.serializeStringLen(this.mimeType) + 1 + ID3V2FrameAttachedPicture.serializeStringLen(this.description) + (this.pictureData == null ? 0 : this.pictureData.length);
        return n;
    }

    public int getTextEncoding() {
        return this.textEncoding;
    }

    public void setTextEncoding(int n) {
        this.textEncoding = n;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    public int getPictureType() {
        return this.pictureType;
    }

    public void setPictureType(int n) {
        this.pictureType = n;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public byte[] getPictureData() {
        return this.pictureData;
    }

    public void setPictureData(byte[] byArray) {
        this.pictureData = byArray;
    }

    public void setPictureDataAsURL(String string) {
        this.pictureData = string.getBytes();
    }

    public boolean loadFile(File file) {
        boolean bl = false;
        RandomAccessFile randomAccessFile = null;
        try {
            if (!file.exists()) {
                WMSLoggerFactory.getLogger(ID3V2FrameBase.class).warn("ID3V2FrameAttachedPicture.loadFile: File missing[" + file.getAbsolutePath() + "]");
            } else if (file.length() > PICTUREMAXFILESIZE) {
                WMSLoggerFactory.getLogger(ID3V2FrameBase.class).warn("ID3V2FrameAttachedPicture.loadFile: File too large[" + file.getAbsolutePath() + "]: size:" + file.length() + " maxSize:" + PICTUREMAXFILESIZE);
            } else {
                byte[] byArray = new byte[(int)file.length()];
                randomAccessFile = new RandomAccessFile(file, "r");
                randomAccessFile.readFully(byArray);
                randomAccessFile.close();
                randomAccessFile = null;
                if (byArray.length > 16) {
                    bl = true;
                    if (byArray[1] == 80 && byArray[2] == 78 && byArray[3] == 71) {
                        this.mimeType = MIMETYPES_PNG;
                    } else if (byArray[6] == 74 && byArray[7] == 70 && byArray[8] == 73 && byArray[9] == 70) {
                        this.mimeType = MIMETYPES_JPEG;
                    } else {
                        bl = false;
                    }
                    if (bl) {
                        this.pictureData = byArray;
                        WMSLoggerFactory.getLogger(ID3V2FrameBase.class).info("ID3V2FrameAttachedPicture.loadFile: Successful [" + file.getAbsolutePath() + "]: mimeType:" + this.mimeType + " size:" + this.pictureData.length);
                    } else {
                        WMSLoggerFactory.getLogger(ID3V2FrameBase.class).warn("ID3V2FrameAttachedPicture.loadFile: File format not recognized [" + file.getAbsolutePath() + "]: " + BufferUtils.encodeHexString(byArray, 0, 16));
                    }
                } else {
                    WMSLoggerFactory.getLogger(ID3V2FrameBase.class).warn("ID3V2FrameAttachedPicture.loadFile: File format not recognized [" + file.getAbsolutePath() + "]: too small: size:" + file.length());
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ID3V2FrameBase.class).error("ID3V2FrameAPIC.loadFile: " + exception.toString());
        }
        try {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ID3V2FrameBase.class).error("ID3V2FrameAPIC.loadFile: " + exception.toString());
        }
        return bl;
    }
}

