/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.media.mp3.model.idtags;

import com.wowza.util.BufferUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.mp3.model.idtags.ID3V2FrameBase;

public class ID3V2FrameComment
extends ID3V2FrameBase {
    private int textEncoding = 3;
    private String description = null;
    private String value = null;

    public ID3V2FrameComment(String string, int n) {
        super(string, n);
    }

    public ID3V2FrameComment(String string) {
        super(string, 0);
    }

    public ID3V2FrameComment() {
        super("COMM", 0);
    }

    public int serializeBody(byte[] byArray, int n) {
        int n2 = 0;
        try {
            byArray[n + n2] = (byte)(this.textEncoding & 0xFF);
            int n3 = ID3V2FrameComment.serializeString(this.description, byArray, n + ++n2);
            n2 += n3;
            if (this.value != null) {
                byte[] byArray2 = this.value.getBytes("UTF-8");
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                n2 += byArray2.length;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ID3V2FrameBase.class).error("ID3V2FrameTextInformation.serializeBody: " + exception.toString());
        }
        return n2;
    }

    public void deserializeBody(byte[] byArray, int n, int n2) {
        try {
            if (n + 1 < n2) {
                String string;
                this.textEncoding = byArray[n] & 0xFF;
                if ((string = ID3V2FrameComment.deserializeString(byArray, ++n, n2)) != null) {
                    this.description = string;
                    int n3 = n2 - (n += string.length() + 1);
                    if (n3 > 0) {
                        this.value = BufferUtils.byteArrayToString(byArray, n, n3);
                        n += n3;
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ID3V2FrameBase.class).error("ID3V2FrameTextInformation.deserializeBody: " + exception.toString());
        }
    }

    public int getBodySize() {
        return 1 + ID3V2FrameComment.serializeStringLen(this.description) + (this.value == null ? 0 : this.value.length());
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public int getTextEncoding() {
        return this.textEncoding;
    }

    public void setTextEncoding(int n) {
        this.textEncoding = n;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }
}

