/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.module;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.mediacaster.IMediaCaster;
import com.wowza.wms.mediacaster.IMediaCasterValidateMediaCaster;
import com.wowza.wms.mediacaster.MediaCasterStreamItem;
import com.wowza.wms.mediacaster.MediaCasterStreamMap;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.MediaStreamMapGroup;
import com.wowza.wms.stream.monitor.MediaStreamMonitor;
import com.wowza.wms.util.ModuleUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ModuleMediaCasterStreamMonitorAdvanced
extends ModuleBase
implements IMediaCasterValidateMediaCaster {
    protected int streamMonitorStreamStartTimeout = 20000;
    protected int streamMonitorStreamTimeout = 12000;
    protected boolean streamMonitorVideoTCToleranceEnable = false;
    protected int streamMonitorVideoTCPosTolerance = 3000;
    protected int streamMonitorVideoTCNegTolerance = -500;
    protected boolean streamMonitorAudioTCToleranceEnable = false;
    protected int streamMonitorAudioTCPosTolerance = 3000;
    protected int streamMonitorAudioTCNegTolerance = -500;
    protected boolean streamMonitorDataTCToleranceEnable = false;
    protected int streamMonitorDataTCPosTolerance = 3000;
    protected int streamMonitorDataTCNegTolerance = -500;
    protected boolean streamMonitorAVSyncToleranceEnable = false;
    protected int streamMonitorAVSyncTolerance = 1500;
    protected int streamMonitorVideoStartTimeout = 0;
    protected int streamMonitorVideoTimeout = 0;
    protected int streamMonitorAudioStartTimeout = 0;
    protected int streamMonitorAudioTimeout = 0;
    protected boolean streamMonitorResetNameGroups = false;
    protected boolean streamMonitorDebug = false;
    protected IApplicationInstance appInstance = null;
    protected Map<IMediaStream, MediaStreamMonitor> monitors = new HashMap<IMediaStream, MediaStreamMonitor>();
    protected Set<IMediaCaster> badStreams = new HashSet<IMediaCaster>();

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
        ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("ModuleMediaCasterStreamMonitorAdvanced.onAppStart[" + iApplicationInstance.getContextStr() + "]");
        WMSProperties wMSProperties = iApplicationInstance.getProperties();
        this.streamMonitorStreamStartTimeout = wMSProperties.getPropertyInt("streamMonitorStreamStartTimeout", this.streamMonitorStreamStartTimeout);
        this.streamMonitorStreamTimeout = wMSProperties.getPropertyInt("streamMonitorStreamTimeout", this.streamMonitorStreamTimeout);
        this.streamMonitorVideoStartTimeout = wMSProperties.getPropertyInt("streamMonitorVideoStartTimeout", this.streamMonitorVideoStartTimeout);
        this.streamMonitorVideoTimeout = wMSProperties.getPropertyInt("streamMonitorVideoTimeout", this.streamMonitorVideoTimeout);
        this.streamMonitorAudioStartTimeout = wMSProperties.getPropertyInt("streamMonitorAudioStartTimeout", this.streamMonitorAudioStartTimeout);
        this.streamMonitorAudioTimeout = wMSProperties.getPropertyInt("streamMonitorAudioTimeout", this.streamMonitorAudioTimeout);
        this.streamMonitorVideoTCToleranceEnable = wMSProperties.getPropertyBoolean("streamMonitorVideoTCToleranceEnable", this.streamMonitorVideoTCToleranceEnable);
        this.streamMonitorVideoTCPosTolerance = wMSProperties.getPropertyInt("streamMonitorVideoTCPosTolerance", this.streamMonitorVideoTCPosTolerance);
        this.streamMonitorVideoTCNegTolerance = wMSProperties.getPropertyInt("streamMonitorVideoTCNegTolerance", this.streamMonitorVideoTCNegTolerance);
        this.streamMonitorAudioTCToleranceEnable = wMSProperties.getPropertyBoolean("streamMonitorAudioTCToleranceEnable", this.streamMonitorAudioTCToleranceEnable);
        this.streamMonitorAudioTCPosTolerance = wMSProperties.getPropertyInt("streamMonitorAudioTCPosTolerance", this.streamMonitorAudioTCPosTolerance);
        this.streamMonitorAudioTCNegTolerance = wMSProperties.getPropertyInt("streamMonitorAudioTCNegTolerance", this.streamMonitorAudioTCNegTolerance);
        this.streamMonitorDataTCToleranceEnable = wMSProperties.getPropertyBoolean("streamMonitorDataTCToleranceEnable", this.streamMonitorDataTCToleranceEnable);
        this.streamMonitorDataTCPosTolerance = wMSProperties.getPropertyInt("streamMonitorDataTCPosTolerance", this.streamMonitorDataTCPosTolerance);
        this.streamMonitorDataTCNegTolerance = wMSProperties.getPropertyInt("streamMonitorDataTCNegTolerance", this.streamMonitorDataTCNegTolerance);
        this.streamMonitorAVSyncToleranceEnable = wMSProperties.getPropertyBoolean("streamMonitorAVSyncToleranceEnable", this.streamMonitorAVSyncToleranceEnable);
        this.streamMonitorAVSyncTolerance = wMSProperties.getPropertyInt("streamMonitorAVSyncTolerance", this.streamMonitorAVSyncTolerance);
        this.streamMonitorResetNameGroups = wMSProperties.getPropertyBoolean("streamMonitorResetNameGroups", this.streamMonitorResetNameGroups);
        this.streamMonitorDebug = wMSProperties.getPropertyBoolean("streamMonitorDebug", this.streamMonitorDebug);
        if (this.streamMonitorDebug) {
            ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("streamMonitorStreamStartTimeout: " + this.streamMonitorStreamStartTimeout);
            ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("streamMonitorStreamTimeout: " + this.streamMonitorStreamTimeout);
            ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("streamMonitorVideoStartTimeout: " + this.streamMonitorVideoStartTimeout);
            ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("streamMonitorVideoTimeout: " + this.streamMonitorVideoTimeout);
            ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("streamMonitorAudioStartTimeout: " + this.streamMonitorAudioStartTimeout);
            ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("streamMonitorAudioTimeout: " + this.streamMonitorAudioTimeout);
            ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("streamMonitorVideoTCToleranceEnable: " + this.streamMonitorVideoTCToleranceEnable);
            ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("streamMonitorVideoTCPosTolerance: " + this.streamMonitorVideoTCPosTolerance);
            ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("streamMonitorVideoTCNegTolerance: " + this.streamMonitorVideoTCNegTolerance);
            ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("streamMonitorAudioTCToleranceEnable: " + this.streamMonitorAudioTCToleranceEnable);
            ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("streamMonitorAudioTCPosTolerance: " + this.streamMonitorAudioTCPosTolerance);
            ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("streamMonitorAudioTCNegTolerance: " + this.streamMonitorAudioTCNegTolerance);
            ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("streamMonitorDataTCToleranceEnable: " + this.streamMonitorDataTCToleranceEnable);
            ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("streamMonitorDataTCPosTolerance: " + this.streamMonitorDataTCPosTolerance);
            ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("streamMonitorDataTCNegTolerance: " + this.streamMonitorDataTCNegTolerance);
            ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("streamMonitorAVSyncToleranceEnable: " + this.streamMonitorAVSyncToleranceEnable);
            ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("streamMonitorAVSyncTolerance: " + this.streamMonitorAVSyncTolerance);
            ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("streamMonitorResetNameGroups: " + this.streamMonitorResetNameGroups);
        }
        iApplicationInstance.setMediaCasterValidator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAppStop(IApplicationInstance iApplicationInstance) {
        int n = 0;
        Map<IMediaStream, MediaStreamMonitor> map = this.monitors;
        synchronized (map) {
            n = this.monitors.size();
            this.monitors.clear();
        }
        ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("ModuleMediaCasterStreamMonitorAdvanced.onAppStop[" + iApplicationInstance.getContextStr() + "] monitorCount:" + n);
        iApplicationInstance.setMediaCasterValidator(null);
    }

    public void onStreamCreate(IMediaStream iMediaStream) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStreamDestroy(IMediaStream iMediaStream) {
        Map<IMediaStream, MediaStreamMonitor> map = this.monitors;
        synchronized (map) {
            this.monitors.remove(iMediaStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaStreamMonitor getMonitor(IMediaStream iMediaStream) {
        MediaStreamMonitor mediaStreamMonitor = null;
        Map<IMediaStream, MediaStreamMonitor> map = this.monitors;
        synchronized (map) {
            mediaStreamMonitor = this.monitors.get(iMediaStream);
            if (mediaStreamMonitor == null) {
                ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("ModuleMediaCasterStreamMonitorAdvanced.getMonitor[" + this.appInstance.getContextStr() + "] create:" + iMediaStream.getName());
                mediaStreamMonitor = new MediaStreamMonitor();
                mediaStreamMonitor.setStreamMonitorStreamStartTimeout(this.streamMonitorStreamStartTimeout);
                mediaStreamMonitor.setStreamMonitorStreamTimeout(this.streamMonitorStreamTimeout);
                mediaStreamMonitor.setStreamMonitorVideoTCToleranceEnable(this.streamMonitorVideoTCToleranceEnable);
                mediaStreamMonitor.setStreamMonitorVideoTCPosTolerance(this.streamMonitorVideoTCPosTolerance);
                mediaStreamMonitor.setStreamMonitorVideoTCNegTolerance(this.streamMonitorVideoTCNegTolerance);
                mediaStreamMonitor.setStreamMonitorAudioTCToleranceEnable(this.streamMonitorAudioTCToleranceEnable);
                mediaStreamMonitor.setStreamMonitorAudioTCPosTolerance(this.streamMonitorAudioTCPosTolerance);
                mediaStreamMonitor.setStreamMonitorAudioTCNegTolerance(this.streamMonitorAudioTCNegTolerance);
                mediaStreamMonitor.setStreamMonitorDataTCToleranceEnable(this.streamMonitorDataTCToleranceEnable);
                mediaStreamMonitor.setStreamMonitorDataTCPosTolerance(this.streamMonitorDataTCPosTolerance);
                mediaStreamMonitor.setStreamMonitorDataTCNegTolerance(this.streamMonitorDataTCNegTolerance);
                mediaStreamMonitor.setStreamMonitorAVSyncToleranceEnable(this.streamMonitorAVSyncToleranceEnable);
                mediaStreamMonitor.setStreamMonitorAVSyncTolerance(this.streamMonitorAVSyncTolerance);
                mediaStreamMonitor.setStreamMonitorVideoStartTimeout(this.streamMonitorVideoStartTimeout);
                mediaStreamMonitor.setStreamMonitorVideoTimeout(this.streamMonitorVideoTimeout);
                mediaStreamMonitor.setStreamMonitorAudioStartTimeout(this.streamMonitorAudioStartTimeout);
                mediaStreamMonitor.setStreamMonitorAudioTimeout(this.streamMonitorAudioTimeout);
                if (this.streamMonitorDebug) {
                    mediaStreamMonitor.debugLog = true;
                }
                mediaStreamMonitor.init(iMediaStream);
                this.monitors.put(iMediaStream, mediaStreamMonitor);
            }
        }
        return mediaStreamMonitor;
    }

    private String getStreamName(IMediaCaster iMediaCaster) {
        String string = "unknown";
        String string2 = "flv";
        IMediaStream iMediaStream = iMediaCaster.getStream();
        if (iMediaStream != null) {
            string = iMediaStream.getName();
            string2 = iMediaStream.getExt();
        }
        return string2 + ":" + string;
    }

    public void onValidateMediaCastersStart(IApplicationInstance iApplicationInstance) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onValidateMediaCaster(IApplicationInstance iApplicationInstance, IMediaCaster iMediaCaster) {
        boolean bl;
        block4: {
            IMediaStream iMediaStream;
            bl = true;
            int n = iMediaCaster.getMediaCasterType();
            if (n == 1 || (iMediaStream = iMediaCaster.getStream()) == null) break block4;
            MediaStreamMonitor mediaStreamMonitor = this.getMonitor(iMediaStream);
            mediaStreamMonitor.monitor();
            int n2 = mediaStreamMonitor.getHealthState();
            if (n2 != 0 && n2 != 1) {
                ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("ModuleMediaCasterStreamMonitorAdvanced.onValidateMediaCaster[" + iApplicationInstance.getContextStr() + "] Stream not healthy [" + MediaStreamMonitor.healthStateToName(n2) + "]: " + this.getStreamName(iMediaCaster));
                Set<IMediaCaster> set = this.badStreams;
                synchronized (set) {
                    this.badStreams.add(iMediaCaster);
                }
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onValidateMediaCastersStop(IApplicationInstance iApplicationInstance) {
        Object object;
        Set<MediaStreamMapGroup> set;
        HashSet<IMediaCaster> hashSet = null;
        HashSet<MediaStreamMapGroup> hashSet2 = null;
        HashSet<String> hashSet3 = null;
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        Object object2 = this.badStreams;
        synchronized (object2) {
            if (this.badStreams.size() > 0) {
                if (this.streamMonitorResetNameGroups) {
                    for (IMediaCaster iMediaCaster : this.badStreams) {
                        set = iMediaCaster.getStream();
                        if (set == null) continue;
                        object = this.getStreamName(iMediaCaster);
                        Set<MediaStreamMapGroup> set2 = mediaStreamMap.getNameGroups((String)object);
                        if (set2 == null) {
                            if (hashSet == null) {
                                hashSet = new HashSet();
                            }
                            hashSet.add(iMediaCaster);
                            continue;
                        }
                        for (MediaStreamMapGroup mediaStreamMapGroup : set2) {
                            if (hashSet2 == null) {
                                hashSet2 = new HashSet<MediaStreamMapGroup>();
                                hashSet3 = new HashSet<String>();
                            }
                            hashSet2.add(mediaStreamMapGroup);
                            hashSet3.addAll(mediaStreamMapGroup.getNames());
                        }
                    }
                } else {
                    hashSet = new HashSet<IMediaCaster>();
                    hashSet.addAll(this.badStreams);
                }
                this.badStreams.clear();
            }
        }
        if (hashSet3 != null) {
            int n;
            do {
                n = hashSet3.size();
                for (String string : hashSet3) {
                    set = mediaStreamMap.getNameGroups(string);
                    if (set == null) continue;
                    for (MediaStreamMapGroup mediaStreamMapGroup : set) {
                        hashSet2.add(mediaStreamMapGroup);
                        hashSet3.addAll(mediaStreamMapGroup.getNames());
                    }
                }
            } while (hashSet3.size() != n);
            object2 = iApplicationInstance.getMediaCasterStreams();
            for (String string : hashSet3) {
                IMediaCaster iMediaCaster;
                MediaCasterStreamItem mediaCasterStreamItem;
                set = string;
                object = "flv";
                String string2 = "";
                String[] stringArray = ModuleUtils.decodeStreamExtension((String)((Object)set), (String)object);
                set = stringArray[0];
                object = stringArray[1];
                boolean bl = ((String)((Object)set)).indexOf("://") >= 0;
                int n2 = ((String)((Object)set)).indexOf("?");
                if (!bl && n2 >= 0) {
                    String string3 = ((String)((Object)set)).substring(n2 + 1);
                    set = ((String)((Object)set)).substring(0, n2);
                }
                if ((mediaCasterStreamItem = ((MediaCasterStreamMap)object2).getMediaCaster((String)((Object)set))) == null || (iMediaCaster = mediaCasterStreamItem.getMediaCaster()) == null) continue;
                ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("ModuleMediaCasterStreamMonitorAdvanced.onValidateMediaCastersStop[" + iApplicationInstance.getContextStr() + "] Reset stream [nameGroup]: " + string);
                iMediaCaster.forceReset();
            }
        }
        if (hashSet != null) {
            for (IMediaCaster iMediaCaster : hashSet) {
                ModuleMediaCasterStreamMonitorAdvanced.getLogger().info("ModuleMediaCasterStreamMonitorAdvanced.onValidateMediaCastersStop[" + iApplicationInstance.getContextStr() + "] Reset stream [mediaCaster]: " + this.getStreamName(iMediaCaster));
                iMediaCaster.forceReset();
            }
        }
    }

    public boolean onResetMediaCaster(IApplicationInstance iApplicationInstance, IMediaCaster iMediaCaster) {
        return true;
    }
}

