/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.netconnection;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.netconnection.INetConnection;
import com.wowza.wms.netconnection.INetConnectionIdle;
import com.wowza.wms.netconnection.NetConnectionAdapter;
import com.wowza.wms.server.RtmpRequestMessage;
import com.wowza.wms.server.RtmpResponseMessage;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHost;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;

public class NetConnectionSessionHandler
extends IoHandlerAdapter {
    private INetConnection netConnection = null;
    private String vhostName = "";

    public NetConnectionSessionHandler(INetConnection iNetConnection) {
        this.netConnection = iNetConnection;
        WMSLoggerFactory.getLogger(NetConnectionSessionHandler.class).debug("NetConnectionSessionHandler: create");
        this.vhostName = iNetConnection.getAppInstance().getVHost().getName();
    }

    private RtmpSessionInfo getSessionInfo(IoSession ioSession) {
        return (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
    }

    public void sessionCreated(IoSession ioSession) {
        WMSLoggerFactory.getLogger(NetConnectionSessionHandler.class).debug("NetConnectionSessionHandler: sessionCreated");
        ioSession.setAttribute("wmsSessionInfo", (Object)new RtmpSessionInfo(false, "unknown"));
        ioSession.setAttribute("netConnection", (Object)this.netConnection);
        IVHost iVHost = this.netConnection.getAppInstance().getVHost();
        ((VHost)iVHost).addSession(ioSession);
    }

    public void sessionClosed(IoSession ioSession) {
        IVHost iVHost = this.netConnection.getAppInstance().getVHost();
        ((VHost)iVHost).removeSession(ioSession);
        INetConnectionIdle iNetConnectionIdle = this.netConnection.getIdleHandler();
        if (iNetConnectionIdle != null) {
            iNetConnectionIdle.onSessionClosed(this.netConnection, ioSession);
        }
    }

    public void sessionOpened(IoSession ioSession) {
        Object object;
        WMSLoggerFactory.getLogger(NetConnectionSessionHandler.class).debug("NetConnectionSessionHandler: sessionOpened");
        String string = "127.0.0.1";
        SocketAddress socketAddress = ioSession.getRemoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            object = (InetSocketAddress)socketAddress;
            string = ((InetSocketAddress)object).getAddress().toString().replace("/", "");
        }
        object = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
        ((RtmpSessionInfo)object).setProtocol(1);
        ((RtmpSessionInfo)object).setIpAddress(string);
        RtmpResponseMessage rtmpResponseMessage = new RtmpResponseMessage(this.vhostName);
        this.serviceRequest(ioSession, (RtmpSessionInfo)object, null, rtmpResponseMessage);
        INetConnectionIdle iNetConnectionIdle = this.netConnection.getIdleHandler();
        if (iNetConnectionIdle != null) {
            iNetConnectionIdle.onSessionOpened(this.netConnection, ioSession);
        }
    }

    private void handleMessageReceived(IoSession ioSession, Object object) {
        RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
        RtmpRequestMessage rtmpRequestMessage = (RtmpRequestMessage)object;
        RtmpResponseMessage rtmpResponseMessage = new RtmpResponseMessage(this.vhostName);
        this.serviceRequest(ioSession, rtmpSessionInfo, rtmpRequestMessage, rtmpResponseMessage);
    }

    private void handleSessionIdle(IoSession ioSession) {
        INetConnectionIdle iNetConnectionIdle = this.netConnection.getIdleHandler();
        if (iNetConnectionIdle != null) {
            iNetConnectionIdle.onIdle(this.netConnection, ioSession);
        }
        RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
        RtmpResponseMessage rtmpResponseMessage = new RtmpResponseMessage(this.vhostName);
        RtmpRequestMessage rtmpRequestMessage = new RtmpRequestMessage(rtmpSessionInfo, this.netConnection.getAppInstance().getVHost().getName(), 1, false);
        rtmpRequestMessage.setType(3);
        rtmpRequestMessage.setLastReadTime(System.currentTimeMillis() - ioSession.getLastReadTime());
        this.serviceRequest(ioSession, rtmpSessionInfo, rtmpRequestMessage, rtmpResponseMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionIdle(IoSession ioSession, IdleStatus idleStatus) {
        RtmpSessionInfo rtmpSessionInfo = this.getSessionInfo(ioSession);
        Object object = this;
        synchronized (object) {
            if (rtmpSessionInfo.getInHandler() > 0) {
                rtmpSessionInfo.addMessageQueue(null);
                return;
            }
            rtmpSessionInfo.incInHandler();
        }
        object = null;
        while (true) {
            if (object == null) {
                this.handleSessionIdle(ioSession);
            } else {
                this.handleMessageReceived(ioSession, object);
            }
            NetConnectionSessionHandler netConnectionSessionHandler = this;
            synchronized (netConnectionSessionHandler) {
                boolean bl;
                boolean bl2 = bl = object == null;
                if (rtmpSessionInfo.isMessageQueueEmpty()) {
                    rtmpSessionInfo.decInHandler();
                    break;
                }
                object = rtmpSessionInfo.getFirstMessageQueue();
                if (object == null && bl) {
                    rtmpSessionInfo.decInHandler();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoSession ioSession, Object object) {
        RtmpSessionInfo rtmpSessionInfo = this.getSessionInfo(ioSession);
        Object object2 = this;
        synchronized (object2) {
            if (rtmpSessionInfo.getInHandler() > 0) {
                rtmpSessionInfo.addMessageQueue(object);
                return;
            }
            rtmpSessionInfo.incInHandler();
        }
        object2 = object;
        while (true) {
            if (object2 == null) {
                this.handleSessionIdle(ioSession);
            } else {
                this.handleMessageReceived(ioSession, object2);
            }
            NetConnectionSessionHandler netConnectionSessionHandler = this;
            synchronized (netConnectionSessionHandler) {
                boolean bl;
                boolean bl2 = bl = object2 == null;
                if (rtmpSessionInfo.isMessageQueueEmpty()) {
                    rtmpSessionInfo.decInHandler();
                    break;
                }
                object2 = rtmpSessionInfo.getFirstMessageQueue();
                if (object2 == null && bl) {
                    rtmpSessionInfo.decInHandler();
                    break;
                }
            }
        }
    }

    public void exceptionCaught(IoSession ioSession, Throwable throwable) {
        WMSLoggerFactory.getLogger(NetConnectionSessionHandler.class).debug("NetConnectionSessionHandler: exceptionCaught: " + throwable.toString());
        RtmpSessionInfo rtmpSessionInfo = (RtmpSessionInfo)ioSession.getAttribute("wmsSessionInfo");
        rtmpSessionInfo.setOpen(false);
        rtmpSessionInfo.setClosed(true);
        rtmpSessionInfo.setClientId(-1);
        ioSession.close();
    }

    private void serviceRequest(IoSession ioSession, RtmpSessionInfo rtmpSessionInfo, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        RtmpSessionInfo rtmpSessionInfo2 = this.getSessionInfo(ioSession);
        NetConnectionAdapter.service(this.netConnection, rtmpRequestMessage, rtmpResponseMessage);
        int n = rtmpSessionInfo.getProtocol();
        if (rtmpResponseMessage.getContentLength() > 0) {
            if (n == 1) {
                ioSession.write((Object)rtmpResponseMessage.getBody());
            } else {
                ioSession.write((Object)rtmpResponseMessage).join();
            }
        }
        if (!rtmpSessionInfo2.isDidNotifySessionOpen()) {
            IVHost iVHost = this.netConnection.getAppInstance().getVHost();
            ((VHost)iVHost).notifySessionOpen(ioSession, 17, null);
            rtmpSessionInfo2.setDidNotifySessionOpen(true);
        }
        if (rtmpResponseMessage.isDidClose()) {
            rtmpSessionInfo.setOpen(false);
            rtmpSessionInfo.setClosed(true);
            rtmpSessionInfo.setClientId(-1);
            ioSession.close();
        }
    }
}

