/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.request;

import com.wowza.util.DebugUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.module.ModuleFunctions;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.request.RequestProcessData;
import com.wowza.wms.request.RequestProcessSO;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.vhost.IVHost;
import java.util.List;

public class RequestProcessFunctions {
    public static void processFunctions(IVHost iVHost, IClient iClient, List list) {
        IApplicationInstance iApplicationInstance = iClient.getAppInstance();
        MediaStreamMap mediaStreamMap = null;
        if (iApplicationInstance != null) {
            mediaStreamMap = iApplicationInstance.getStreams();
        }
        for (RequestFunction requestFunction : list) {
            Object object;
            if (requestFunction.isPartial()) continue;
            if (requestFunction.getType() == 18 || requestFunction.getType() == 15) {
                int n = requestFunction.getSrc();
                if (n <= 0 || (object = mediaStreamMap.getStream(iClient, n)) == null) continue;
                object.handleCallback(requestFunction);
                continue;
            }
            if (requestFunction.getType() == 19 || requestFunction.getType() == 16) {
                RequestProcessSO.execute(iVHost, iClient, requestFunction);
                continue;
            }
            if (requestFunction.getType() == 20 || requestFunction.getType() == 17) {
                AMFDataList aMFDataList = requestFunction.getMessage();
                if (aMFDataList == null) continue;
                object = aMFDataList.get(0);
                WMSLoggerFactory.getLogger(RequestProcessData.class).debug("cmd: " + object);
                if (((AMFData)object).getType() != 2) continue;
                String string = (String)((AMFData)object).getValue();
                if (string.equals("connect")) {
                    ModuleConnect.connect(iVHost, iClient, requestFunction, aMFDataList);
                    continue;
                }
                if (string.equals("_result") || string.equals("_error")) {
                    ((Client)iClient).getCallResults().handleResult(iClient, requestFunction, aMFDataList);
                    continue;
                }
                if (iApplicationInstance == null || !iClient.isConnected()) continue;
                IApplication iApplication = iApplicationInstance.getApplication();
                ModuleFunctions moduleFunctions = iApplicationInstance.getModFunctions();
                boolean bl = false;
                if (!bl && string.indexOf(".") >= 0 && moduleFunctions.invokeComponent(string, iClient, requestFunction, aMFDataList)) {
                    bl = true;
                }
                if (!bl && moduleFunctions.invoke(string, iClient, requestFunction, aMFDataList)) {
                    bl = true;
                }
                if (bl) continue;
                if (moduleFunctions.isOnCall()) {
                    moduleFunctions.onCall(string, iClient, requestFunction, aMFDataList);
                    continue;
                }
                WMSLoggerFactory.getLogger(RequestProcessData.class).warn("Missing function: " + string);
                continue;
            }
            WMSLoggerFactory.getLogger(RequestProcessData.class).error("Strange data:\n" + DebugUtils.formatBytes(requestFunction.getData()) + "\n");
        }
    }
}

