/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.response;

import com.wowza.wms.amf.AMFObj;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.response.IMediaStreamOutputControl;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamPlay;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ResponseStreams {
    List streamResponses = new ArrayList();
    long[] playSizes = new long[8];

    public void addStreamResponse(IMediaStream iMediaStream) {
        if (!this.streamResponses.contains(iMediaStream)) {
            this.streamResponses.add(iMediaStream);
        }
    }

    public int output(OutputStream outputStream, IClient iClient) {
        IMediaStreamOutputControl iMediaStreamOutputControl;
        Client client = (Client)iClient;
        IMediaStreamOutputControl iMediaStreamOutputControl2 = iMediaStreamOutputControl = outputStream instanceof IMediaStreamOutputControl ? (IMediaStreamOutputControl)((Object)outputStream) : null;
        if (iMediaStreamOutputControl != null) {
            iMediaStreamOutputControl.startResponseStreams(iClient, this);
        }
        int n = 0;
        for (IMediaStream iMediaStream : this.streamResponses) {
            IMediaStreamPlay iMediaStreamPlay;
            AMFObj aMFObj = client.getRespAMFAudioObj(iMediaStream);
            AMFObj aMFObj2 = client.getRespAMFVideoObj(iMediaStream);
            AMFObj aMFObj3 = client.getRespAMFDataObj(iMediaStream);
            if (aMFObj == null || aMFObj2 == null || aMFObj3 == null || (iMediaStreamPlay = iMediaStream.getPlayer()) == null) continue;
            for (int i = 0; i < this.playSizes.length; ++i) {
                this.playSizes[i] = 0L;
            }
            if (iMediaStreamOutputControl != null) {
                iMediaStreamOutputControl.startStreamPlay(iMediaStream);
            }
            n += iMediaStreamPlay.play(outputStream, aMFObj, aMFObj2, aMFObj3, this.playSizes);
            if (iMediaStreamOutputControl != null) {
                iMediaStreamOutputControl.stopStreamPlay(iMediaStream);
            }
            long l = this.playSizes[0] + this.playSizes[2] + this.playSizes[4];
            long l2 = this.playSizes[1] + this.playSizes[3] + this.playSizes[5];
            long l3 = this.playSizes[6];
            long l4 = this.playSizes[7];
            if (l2 > 0L) {
                client.incrementMediaOutBytes(l, l2);
                iMediaStream.incrementMediaOutBytes(l, l2);
            }
            if (l4 <= 0L) continue;
            client.incrementMediaLossBytes(l3, l4);
            client.incrementTotalLossBytes(l3, l4);
            iMediaStream.incrementMediaLossBytes(l3, l4);
        }
        this.streamResponses.clear();
        if (iMediaStreamOutputControl != null) {
            iMediaStreamOutputControl.stopResponseStreams(iClient, this);
        }
        return n;
    }

    public boolean isPending() {
        return this.streamResponses.size() > 0;
    }

    public int size() {
        return this.streamResponses.size();
    }
}

