/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.util.BitReader;
import com.wowza.util.BufferUtils;
import com.wowza.util.DebugUtils;
import com.wowza.util.RolloverLong;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.IRTPTimecodeProvider;
import com.wowza.wms.rtp.depacketizer.RTCPEventHandlerGeneric;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerVideoBase;
import com.wowza.wms.rtp.depacketizer.RTPSequence;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPTrack;
import java.net.SocketAddress;

public class RTPDePacketizerSorensonVideo3
extends RTPDePacketizerVideoBase
implements IRTPDePacketizer,
IRTPTimecodeProvider {
    private RTPSequence seq = new RTPSequence();
    private long lastTimecode = -1L;
    private RTCPEventHandlerGeneric rtcpEventHandler = new RTCPEventHandlerGeneric();
    private RolloverLong timecode = new RolloverLong(32);
    private boolean waitForEnd = false;

    public void init(RTPContext rTPContext, RTPDePacketizerItem rTPDePacketizerItem) {
        super.init(rTPContext, rTPDePacketizerItem);
        if (this.debugLog) {
            WMSLoggerFactory.getLogger(null).debug("RTPDePacketizerSorensonVideo3.init");
        }
    }

    public boolean canHandle(RTPTrack rTPTrack) {
        String string;
        return rTPTrack.isVideo() && (string = rTPTrack.getSampleType()) != null && string.toLowerCase().startsWith("x-sv3v-es");
    }

    public void handleRTCPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.debugLog) {
            int n3 = Math.min(n2, 16);
            WMSLoggerFactory.getLogger(null).debug("rtcp[" + rTPTrack.getTrackId() + ":" + n2 + "] {" + DebugUtils.formatBytesShort(byArray, n, n3) + "}");
        }
        if (!this.checkRTCPSSRC(socketAddress, rTPTrack, byArray, n, n2)) {
            return;
        }
        this.rtcpHandler.handleRTCPPacket(socketAddress, rTPTrack, byArray, n, n2);
    }

    public void handleRTPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.debugLog) {
            int n3 = Math.min(n2, 16);
            WMSLoggerFactory.getLogger(null).debug("rtp[" + rTPTrack.getTrackId() + ":" + n2 + "] {" + DebugUtils.formatBytesShort(byArray, n, n3) + "}");
        }
        if (!this.checkRTPSSRC(socketAddress, rTPTrack, byArray, n, n2)) {
            return;
        }
        this.seq.handleRTPPacket(rTPTrack, byArray, n, n2);
        long l = BufferUtils.byteArrayToLong(byArray, n + 4, 4);
        this.timecode.set(l);
        int n4 = rTPTrack.getTimescale();
        this.setVideoCodecId(rTPTrack, 2);
        try {
            System.out.println(DebugUtils.formatBytes(byArray, n, Math.min(n2, 128)));
            System.out.println("tc:" + this.timecode.get() + " len:" + n2 + " seq:" + this.seq.longValue());
            int n5 = this.skipRTPExtensions(byArray, n, n2, 12);
            int n6 = 0;
            BitReader bitReader = new BitReader(byArray, n2 + n);
            bitReader.skip((n + n5 + n6) * 8);
            bitReader.skip(1);
            int n7 = bitReader.getInt(1);
            int n8 = bitReader.getInt(1);
            int n9 = bitReader.getInt(1);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error("RTPDePacketizerSorensonVideo3.handleRTPPacket: " + exception.toString());
        }
    }

    public void startup(RTPTrack rTPTrack) {
        this.waitForEnd = rTPTrack.isWaitForFirstEnd();
        this.rtcpEventHandler.setTimecodeProvider(this);
        this.rtcpHandler.addEventListener(this.rtcpEventHandler);
        this.setupAppInstanceRTCPEventHandler(this, this.rtcpHandler, rTPTrack);
    }

    public void shutdown(RTPTrack rTPTrack) {
    }

    public long getAdjTimecode(RTPTrack rTPTrack) {
        if (this.lastTimecode != -1L && this.rtcpHandler.isTimeSyncReady(rTPTrack, this.lastTimecode)) {
            long l = this.rtcpHandler.convertTimeSyncTimecode(this.lastTimecode, rTPTrack.getTimescale());
            return l;
        }
        return -1L;
    }
}

