/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.model;

import com.wowza.util.NetworkUtils;

public class RTPDestination {
    private String hostType = "IP4";
    private String host = null;
    private String videoHost = null;
    private String audioHost = null;
    private int ttl = 63;
    private int videoPort = -1;
    private int audioPort = -1;
    private int streamPort = -1;
    private boolean isRTPWrapped = true;
    private String name = "destination";

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        if (this.isStream()) {
            string = "stream: " + this.getHost() + ":" + this.getStreamPort() + ", ";
        } else if (this.videoPort > 0 && this.audioPort > 0) {
            string = "audio: " + this.getAudioHost() + ":" + this.getAudioPort() + ", video: " + this.getVideoHost() + ":" + this.getVideoPort() + ", ";
        } else if (this.videoPort > 0) {
            string = "video: " + this.getVideoHost() + ":" + this.getVideoPort() + ", ";
        } else if (this.audioPort > 0) {
            string = "audio: " + this.getAudioHost() + ":" + this.getAudioPort() + ", ";
        }
        stringBuffer.append("{RTPDestination: ");
        stringBuffer.append("name: \"" + this.name + "\", ");
        stringBuffer.append(string);
        stringBuffer.append("ttl: " + this.ttl + ", ");
        stringBuffer.append("isRTPWrapped: " + this.isRTPWrapped + "");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public boolean isMulticast() {
        boolean bl = false;
        String string = null;
        if (this.host != null) {
            string = this.host;
        } else if (this.videoHost != null) {
            string = this.videoHost;
        } else if (this.audioHost != null) {
            string = this.audioHost;
        }
        if (string != null) {
            try {
                bl = NetworkUtils.isAddressMulticast(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public boolean isStream() {
        return this.streamPort > 0;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getVideoPort() {
        return this.videoPort;
    }

    public void setVideoPort(int n) {
        this.videoPort = n;
    }

    public int getAudioPort() {
        return this.audioPort;
    }

    public void setAudioPort(int n) {
        this.audioPort = n;
    }

    public int getStreamPort() {
        return this.streamPort;
    }

    public void setStreamPort(int n) {
        this.streamPort = n;
    }

    public String getVideoHost() {
        return this.videoHost == null ? this.host : this.videoHost;
    }

    public void setVideoHost(String string) {
        this.videoHost = string;
    }

    public String getAudioHost() {
        return this.audioHost == null ? this.host : this.audioHost;
    }

    public void setAudioHost(String string) {
        this.audioHost = string;
    }

    public String getHostType() {
        return this.hostType;
    }

    public void setHostType(String string) {
        this.hostType = string;
    }

    public int getTTL() {
        return this.ttl;
    }

    public void setTTL(int n) {
        this.ttl = n;
    }

    public boolean isRTPWrapped() {
        return this.isRTPWrapped;
    }

    public void setRTPWrapped(boolean bl) {
        this.isRTPWrapped = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }
}

