/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.packetizer;

import com.wowza.util.BitReader;
import com.wowza.util.BitWriter;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.h263.H263Frame;
import com.wowza.wms.media.h263.H263Utils;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.model.RTPDescribeInfo;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtp.packetizer.RTPPacketizerBase;
import com.wowza.wms.rtp.packetizer.RTPPacketizerVideoBase;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class RTPPacketizerRFC2190H263
extends RTPPacketizerVideoBase
implements IRTPPacketizer {
    protected int maxPacketSize = 1438;
    protected List<RTPPacketFragment> pendingFragments = new ArrayList<RTPPacketFragment>();
    protected boolean isBalanced = true;

    public RTPPacketizerRFC2190H263() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS(bigInteger.toByteArray(), string);
            if (string2.indexOf(RTMPRequestAdapter.fN(ModuleConnect.getN(116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
        }
        this.sdpTypeId = 96;
    }

    public int handleAMFPacket(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, AMFPacket aMFPacket, long l) {
        int n = 0;
        n += this.rtcpSender.sendRTCP(outputStream, this, iMediaStream, rTPTrack, aMFPacket, l);
        try {
            if (aMFPacket.getSize() >= 2) {
                int n2;
                int n3 = aMFPacket.getFirstByte();
                int n4 = aMFPacket.getSecondByte();
                int n5 = FLVUtils.getVideoCodec(n3);
                if (n5 == 2 && (n2 = FLVUtils.getFrameType(n3)) != 3) {
                    int n6;
                    int n7;
                    byte[] byArray = aMFPacket.getData();
                    int n8 = 1;
                    int n9 = aMFPacket.getSize() - n8;
                    byte[] byArray2 = new byte[n9 + 20];
                    BitReader bitReader = new BitReader(byArray, n8 + n9);
                    BitWriter bitWriter = new BitWriter(byArray2);
                    bitReader.skip(8);
                    H263Frame h263Frame = H263Utils.decodeSorensonSparkHeader(bitReader);
                    H263Utils.encodeH263Header(bitWriter, h263Frame);
                    while (bitReader.remaining() > 0) {
                        n7 = 32;
                        if (n7 > bitReader.remaining()) {
                            n7 = bitReader.remaining();
                        }
                        bitWriter.putInt(n7, bitReader.getInt(n7));
                    }
                    n7 = rTPTrack.getTimescale();
                    n9 = bitWriter.count() / 8 + (bitWriter.count() % 8 > 0 ? 1 : 0);
                    int n10 = 0;
                    int n11 = 2;
                    do {
                        if ((n6 = this.maxPacketSize - n11) > n9 - n10) {
                            n6 = n9 - n10;
                        }
                        int n12 = 12 + n11 + n6;
                        byte[] byArray3 = new byte[n12];
                        this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray3, n12, l * (long)n7 / 1000L));
                        byArray3[12] = (byte)(n10 == 0 ? 4 : 0);
                        System.out.println("pos: " + n10 + ":" + n6 + ":" + n9 + ":" + byArray2.length);
                        System.arraycopy(byArray2, n10, byArray3, 12 + n11, n6);
                    } while ((n10 += n6) < n9);
                    n += this.writePendingBlocks(outputStream, rTPTrack, this.sdpTypeId);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerRFC2190H263.class).error("RTPPacketizerRFC2190H263.handleAMFPacket: " + exception.toString());
            exception.printStackTrace();
        }
        return n;
    }

    public int flushPackets(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack) {
        return 0;
    }

    public RTPDescribeInfo getDescribeInfo(RTPTrack rTPTrack, IMediaStream iMediaStream, AMFPacket aMFPacket, AMFPacket aMFPacket2, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 <= 0) {
            n2 = 90000;
        }
        try {
            int n3 = this.sdpTypeId;
            stringBuffer.append("a=rtpmap:" + n3 + " H263-1998/" + n2 + "\r\n");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerRFC2190H263.class).error("RTPPacketizerRFC2190H263.handleAMFPacket: " + exception.toString());
        }
        RTPDescribeInfo rTPDescribeInfo = new RTPDescribeInfo();
        rTPDescribeInfo.setSDPStr(stringBuffer.toString());
        rTPDescribeInfo.setTimescale(n2);
        rTPDescribeInfo.setSDPTypeId(this.sdpTypeId);
        return rTPDescribeInfo;
    }
}

