/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.transport;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.transport.IUDPMessageHandler;
import com.wowza.wms.rtp.transport.RTPMulticastGroup;
import com.wowza.wms.rtp.transport.RTPMulticastListener;
import com.wowza.wms.rtp.transport.RTPUDPDatagramConfig;
import com.wowza.wms.rtp.transport.RTPUDPTransportMina;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.mina.common.ByteBuffer;

public class RTPMulticastListener2
extends Thread {
    private boolean running = true;
    private boolean quit = false;
    private MulticastSocket multicastSocket = null;
    private RTPUDPDatagramConfig datagramConfig = null;
    private Executor executor = null;
    private int port = 0;
    private Map<String, RTPMulticastGroup> groups = new HashMap<String, RTPMulticastGroup>();
    private InetAddress lastAddress = null;

    public RTPMulticastListener2(RTPUDPDatagramConfig rTPUDPDatagramConfig, int n, Executor executor) {
        this.datagramConfig = rTPUDPDatagramConfig;
        this.executor = executor;
        this.port = n;
        this.init();
    }

    private void init() {
        try {
            this.multicastSocket = new MulticastSocket(this.port);
            this.multicastSocket.setTrafficClass(this.datagramConfig.getTrafficClass());
            this.multicastSocket.setReceiveBufferSize(this.datagramConfig.getReceiveBufferSize());
            this.multicastSocket.setReuseAddress(this.datagramConfig.isReuseAddress());
            this.multicastSocket.setSoTimeout(this.datagramConfig.getMulticastTimeout());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPMulticastListener.class).error("RTPMulticastListener.init: " + exception.toString());
        }
    }

    public synchronized void quit() {
        this.quit = true;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unbindAll() {
        try {
            for (String string : this.groups.keySet()) {
                RTPMulticastGroup rTPMulticastGroup = this.groups.get(string);
                if (rTPMulticastGroup == null) continue;
                WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).info("MulticastTransport.unbind: " + string + "/" + this.port);
                InetAddress inetAddress = InetAddress.getByName(string);
                if (this.multicastSocket == null) continue;
                this.multicastSocket.leaveGroup(inetAddress);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPMulticastListener.class).error("RTPMulticastListener.unbindAll: " + exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int unbind(String string) {
        int n = -1;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            String string2 = InetAddress.getByName(string).getHostAddress();
            WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).info("MulticastTransport.unbind: " + string2 + "/" + this.port);
            RTPMulticastGroup rTPMulticastGroup = this.groups.remove(string2);
            if (rTPMulticastGroup != null && this.multicastSocket != null) {
                this.multicastSocket.leaveGroup(inetAddress);
            }
            n = this.groups.size();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPMulticastListener.class).error("RTPMulticastListener.unbind: " + exception.toString());
        }
        return n;
    }

    public synchronized int bind(String string, IUDPMessageHandler iUDPMessageHandler) {
        int n = -1;
        try {
            InetAddress inetAddress;
            this.lastAddress = inetAddress = InetAddress.getByName(string);
            String string2 = inetAddress.getHostAddress();
            WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).info("MulticastTransport.bind: " + string2 + "/" + this.port);
            RTPMulticastGroup rTPMulticastGroup = new RTPMulticastGroup(string, this.port, iUDPMessageHandler);
            this.groups.put(string2, rTPMulticastGroup);
            if (this.multicastSocket != null) {
                this.multicastSocket.joinGroup(inetAddress);
            }
            n = this.groups.size();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPMulticastListener.class).error("RTPMulticastListener.bind: " + exception.toString());
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int n = this.datagramConfig.getReceiveBufferSize();
        byte[] byArray = new byte[n];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, n);
        System.out.println("Start");
        while (true) {
            RTPMulticastListener2 rTPMulticastListener2;
            if (this.multicastSocket == null) {
                RTPMulticastListener2 rTPMulticastListener22 = this;
                synchronized (rTPMulticastListener22) {
                    this.running = false;
                    break;
                }
            }
            try {
                this.multicastSocket.receive(datagramPacket);
                System.out.println("message");
                int n2 = datagramPacket.getLength();
                if (n2 > 0) {
                    rTPMulticastListener2 = ByteBuffer.allocate((int)n2, (boolean)false);
                    rTPMulticastListener2.put(byArray, 0, n2);
                    rTPMulticastListener2.flip();
                    String string = datagramPacket.getSocketAddress().toString();
                    System.out.println("adjAddress1: " + datagramPacket.getAddress().getCanonicalHostName());
                    System.out.println("adjAddress2: " + datagramPacket.getAddress().getHostAddress());
                    System.out.println("adjAddress3: " + datagramPacket.getAddress().getHostName());
                    StringBuilder stringBuilder = new StringBuilder().append("adjAddress4: ");
                    datagramPacket.getAddress();
                    System.out.println(stringBuilder.append(InetAddress.getLocalHost()).toString());
                    System.out.println("adjAddress5: " + datagramPacket.getSocketAddress());
                    System.out.println("size: " + rTPMulticastListener2.limit());
                    RTPMulticastGroup rTPMulticastGroup = null;
                    RTPMulticastListener2 rTPMulticastListener23 = this;
                    synchronized (rTPMulticastListener23) {
                        rTPMulticastGroup = this.groups.get(string);
                    }
                    if (rTPMulticastGroup != null) {
                        rTPMulticastGroup.handleMessage(this.executor, datagramPacket.getSocketAddress(), rTPMulticastListener2);
                        long l = rTPMulticastGroup.incPacketCount();
                        if (l == 1L) {
                            WMSLoggerFactory.getLogger(RTPUDPTransportMina.class).info("MulticastTransport.firstPacket: " + string + "/" + this.port);
                        }
                    }
                }
                rTPMulticastListener2 = this;
                synchronized (rTPMulticastListener2) {
                    if (this.quit) {
                        this.running = false;
                        break;
                    }
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                rTPMulticastListener2 = this;
                synchronized (rTPMulticastListener2) {
                    if (this.quit) {
                        this.running = false;
                        break;
                    }
                }
            }
            catch (Exception exception) {
                rTPMulticastListener2 = this;
                synchronized (rTPMulticastListener2) {
                    if (this.quit) {
                        this.running = false;
                        break;
                    }
                }
            }
        }
        try {
            if (this.multicastSocket != null) {
                this.multicastSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        WMSLoggerFactory.getLogger(RTPMulticastListener.class).info("RTPMulticastListener.run(stop)");
        System.out.println("stop");
    }
}

