/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.transport;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.transport.IUDPMessageHandler;
import com.wowza.wms.rtp.transport.IUDPTransport;
import com.wowza.wms.rtp.transport.RTPMulticastTransport;
import com.wowza.wms.rtp.transport.RTPUDPDatagramConfig;
import com.wowza.wms.rtp.transport.RTPUDPTransportMina;
import com.wowza.wms.rtp.transport.UDPTransportBase;
import com.wowza.wms.transport.udp.UDPPortSharingManager;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;

public class UDPTransportShared
extends UDPTransportBase
implements IUDPTransport {
    private boolean isMulticast = false;
    private UDPPortSharingManager udpPortSharingManager = null;
    private IUDPTransport internalUDPTransport = null;
    private Map<InetSocketAddress, AddressHolder> binds = new HashMap<InetSocketAddress, AddressHolder>();
    private Object lock = new Object();

    public void init(UDPPortSharingManager uDPPortSharingManager, boolean bl) {
        this.udpPortSharingManager = uDPPortSharingManager;
        this.isMulticast = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IUDPTransport getInternalUDPTransport() {
        IUDPTransport iUDPTransport = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.internalUDPTransport == null) {
                this.internalUDPTransport = this.isMulticast ? new RTPMulticastTransport() : new RTPUDPTransportMina();
                this.internalUDPTransport.copyContext(this);
            }
            iUDPTransport = this.internalUDPTransport;
        }
        return iUDPTransport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress bind(RTPUDPDatagramConfig rTPUDPDatagramConfig, IUDPMessageHandler iUDPMessageHandler, String string, int n, String string2, int n2, int n3) {
        InetSocketAddress inetSocketAddress = string == null ? new InetSocketAddress(n) : new InetSocketAddress(string, n);
        boolean bl = n3 == 1 && !this.udpPortSharingManager.isPortAutoAssigned(n);
        WMSLoggerFactory.getLogger(UDPTransportShared.class).debug("UDPTransportShared.bind[" + this.getLoggingContextStr() + "]: port:" + n + " directIn:" + (n3 == 1) + " portAuto:" + this.udpPortSharingManager.isPortAutoAssigned(n) + " shared:" + bl);
        IUDPTransport iUDPTransport = null;
        Object object = this.lock;
        synchronized (object) {
            if (!bl) {
                iUDPTransport = this.getInternalUDPTransport();
            }
            this.binds.put(inetSocketAddress, new AddressHolder(inetSocketAddress, bl));
        }
        object = this.getExecutor();
        if (iUDPTransport != null) {
            iUDPTransport.bind(rTPUDPDatagramConfig, iUDPMessageHandler, string, n, string2, n2, n3);
        } else {
            this.udpPortSharingManager.bind(this, inetSocketAddress, iUDPMessageHandler, (Executor)object, rTPUDPDatagramConfig);
        }
        return inetSocketAddress;
    }

    protected void unbind(AddressHolder addressHolder, IUDPTransport iUDPTransport) {
        if (addressHolder != null) {
            if (!addressHolder.shared) {
                iUDPTransport.unbind(addressHolder.socketAddress);
            } else {
                this.udpPortSharingManager.unbind(this, addressHolder.socketAddress);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(InetSocketAddress inetSocketAddress) {
        AddressHolder addressHolder = null;
        IUDPTransport iUDPTransport = null;
        Object object = this.lock;
        synchronized (object) {
            addressHolder = this.binds.remove(inetSocketAddress);
            if (addressHolder != null && !addressHolder.shared) {
                iUDPTransport = this.getInternalUDPTransport();
            }
        }
        this.unbind(addressHolder, iUDPTransport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAll() {
        ArrayList<AddressHolder> arrayList = new ArrayList<AddressHolder>();
        IUDPTransport iUDPTransport = null;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            for (AddressHolder addressHolder : this.binds.values()) {
                if (addressHolder == null) continue;
                if (!addressHolder.shared) {
                    iUDPTransport = this.getInternalUDPTransport();
                }
                arrayList.add(addressHolder);
            }
            this.binds.clear();
        }
        for (AddressHolder addressHolder : arrayList) {
            this.unbind(addressHolder, iUDPTransport);
        }
    }

    public boolean isMulticast() {
        return this.isMulticast;
    }

    public void setMulticast(boolean bl) {
        this.isMulticast = bl;
    }

    class AddressHolder {
        InetSocketAddress socketAddress;
        boolean shared = false;

        AddressHolder(InetSocketAddress inetSocketAddress, boolean bl) {
            this.socketAddress = inetSocketAddress;
            this.shared = bl;
        }
    }
}

