/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.serverlistener;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.IServerNotify2;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ServerListenerStartupStreamsMonitor
implements IServerNotify2 {
    private Map<String, StartupStreamsAppInstance> monitors = new HashMap<String, StartupStreamsAppInstance>();
    private StartupStreamsMonitorThread monitorThread = null;

    public void onServerCreate(IServer iServer) {
    }

    public void onServerConfigLoaded(IServer iServer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServerInit(IServer iServer) {
        block17: {
            String string;
            String string2;
            String string3;
            int n;
            String string4;
            block16: {
                WMSProperties wMSProperties = iServer.getProperties();
                WMSLoggerFactory.getLogger(ServerListenerStartupStreamsMonitor.class).warn("ServerListenerStartupStreamsMonitor.onServerInit");
                string4 = "";
                n = 1000;
                string3 = "mp4";
                string2 = "rtp";
                string = ".sdp|.stream";
                string4 = wMSProperties.getPropertyStr("startupStreamsMonitorApplicationList", string4);
                n = wMSProperties.getPropertyInt("startupStreamsMonitorFrequency", n);
                string3 = wMSProperties.getPropertyStr("startupStreamsMonitorStreamPrefix", string3);
                string2 = wMSProperties.getPropertyStr("startupStreamsMonitorMediaCasterType", string2);
                string = wMSProperties.getPropertyStr("startupStreamsMonitorExtensionFilter", string);
                if (string4 == null) {
                    string4 = "";
                }
                if (string4.length() > 0) break block16;
                WMSLoggerFactory.getLogger(ServerListenerStartupStreamsMonitor.class).warn("ServerListenerStartupStreamsMonitor: Application list is missing. Server level property startupStreamsMonitorApplicationList must be present and contain pipe (|) delimited list of applcation to monitor.");
                break block17;
            }
            String[] stringArray = string4.trim().split("[|]");
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                Object object2;
                int n2;
                String string5 = stringArray[i].trim();
                if (string5.length() <= 0) continue;
                String string6 = string5;
                String string7 = "_definst_";
                String string8 = "_defaultVHost_";
                int n3 = string5.indexOf(":");
                if (n3 >= 0) {
                    string8 = string5.substring(0, n3);
                    string6 = string5.substring(n3 + 1);
                }
                if ((n2 = string6.indexOf("/")) >= 0) {
                    string7 = string6.substring(n2 + 1);
                    string6 = string6.substring(0, n2);
                }
                IApplicationInstance iApplicationInstance = null;
                IVHost iVHost = null;
                iVHost = VHostSingleton.getInstance(string8);
                if (iVHost == null) {
                    WMSLoggerFactory.getLogger(ServerListenerStartupStreamsMonitor.class).warn("ServerListenerStartupStreamsMonitor: VHostName is not found: " + string8);
                } else {
                    object2 = null;
                    object = iVHost.getApplicationLock();
                    object.writeLock().lock();
                    try {
                        object2 = iVHost.getApplication(string6);
                        if (object2 != null) {
                            iApplicationInstance = object2.getAppInstance(string7);
                            if (iApplicationInstance != null) {
                                iApplicationInstance.setApplicationTimeout(0);
                            }
                        } else {
                            WMSLoggerFactory.getLogger(ServerListenerStartupStreamsMonitor.class).warn("ServerListenerStartupStreamsMonitor: Application folder ([install-location]/applications/" + string6 + ") is missing");
                        }
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(ServerListenerStartupStreamsMonitor.class).error("ServerListenerStartupStreamsMonitor: " + exception.toString());
                    }
                    finally {
                        object.writeLock().unlock();
                    }
                }
                if (iApplicationInstance == null) {
                    WMSLoggerFactory.getLogger(ServerListenerStartupStreamsMonitor.class).warn("ServerListenerStartupStreamsMonitor: AppInstance not loaded: " + string5 + ":" + string7);
                    continue;
                }
                object2 = iVHost.getName() + ":" + iApplicationInstance.getContextStr();
                WMSLoggerFactory.getLogger(ServerListenerStartupStreamsMonitor.class).info("ServerListenerStartupStreamsMonitor: Add application instance: " + (String)object2);
                object = new StartupStreamsAppInstance((String)object2, iApplicationInstance);
                ((StartupStreamsAppInstance)object).setMediaCasterType(string2);
                ((StartupStreamsAppInstance)object).setStreamPrefix(string3);
                ((StartupStreamsAppInstance)object).setExtensionFilter(string);
                ((StartupStreamsAppInstance)object).init();
                this.monitors.put((String)object2, (StartupStreamsAppInstance)object);
            }
            if (this.monitors.size() <= 0) break block17;
            WMSLoggerFactory.getLogger(ServerListenerStartupStreamsMonitor.class).info("ServerListenerStartupStreamsMonitor: Monitor thread started.");
            this.monitorThread = new StartupStreamsMonitorThread();
            this.monitorThread.setMonitorFrequency(n);
            this.monitorThread.setName("StartupStreamsMonitorThread");
            this.monitorThread.setDaemon(true);
            this.monitorThread.run();
        }
    }

    public void onServerShutdownStart(IServer iServer) {
        WMSLoggerFactory.getLogger(ServerListenerStartupStreamsMonitor.class).warn("ServerListenerStartupStreamsMonitor.onServerShutdownStart");
        if (this.monitorThread != null) {
            this.monitorThread.stopRunning();
            this.monitorThread = null;
        }
    }

    public void onServerShutdownComplete(IServer iServer) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StartupStreamsAppInstance {
        String contextStr = "";
        Map<String, StartupStreamsFile> fileList = new HashMap<String, StartupStreamsFile>();
        IApplicationInstance appInstance = null;
        String streamPrefix = "mp4";
        String mediaCasterType = "rtp";
        String[] extensionFilterArr = new String[0];
        String extensionFilter = ".sdp|.stream";

        public StartupStreamsAppInstance(String string, IApplicationInstance iApplicationInstance) {
            this.contextStr = string;
            this.appInstance = iApplicationInstance;
        }

        public void init() {
            WMSProperties wMSProperties = this.appInstance.getProperties();
            this.streamPrefix = wMSProperties.getPropertyStr("startupStreamsMonitorStreamPrefix", this.streamPrefix);
            this.mediaCasterType = wMSProperties.getPropertyStr("startupStreamsMonitorMediaCasterType", this.mediaCasterType);
            this.extensionFilter = wMSProperties.getPropertyStr("startupStreamsMonitorExtensionFilter", this.extensionFilter);
            this.initExtensionFilter();
            String string = this.appInstance.getStreamStoragePath();
            WMSLoggerFactory.getLogger(ServerListenerStartupStreamsMonitor.class).info("ServerListenerStartupStreamsMonitor#StartupStreamsAppInstance.init[" + this.contextStr + "]: Monitoring folder: " + string);
        }

        private void initExtensionFilter() {
            String[] stringArray = this.extensionFilter.split("[|]");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i].trim();
                if (string.length() <= 0) continue;
                arrayList.add(string);
            }
            if (arrayList.size() > 0) {
                this.extensionFilterArr = new String[arrayList.size()];
                Iterator iterator = arrayList.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    String string;
                    this.extensionFilterArr[n] = string = (String)iterator.next();
                    ++n;
                }
            } else {
                this.extensionFilterArr = new String[0];
            }
        }

        private void clearTouch() {
            for (StartupStreamsFile startupStreamsFile : this.fileList.values()) {
                startupStreamsFile.setTouched(false);
            }
        }

        private List<String> getUntouchFiles() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (StartupStreamsFile startupStreamsFile : this.fileList.values()) {
                if (startupStreamsFile.isTouched()) continue;
                arrayList.add(startupStreamsFile.getFileName());
            }
            return arrayList;
        }

        private void scanFolderForMatches(File file, String string, List<String> list) {
            try {
                File[] fileArray = null;
                try {
                    fileArray = file.listFiles();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (fileArray != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        StartupStreamsFile startupStreamsFile;
                        int n;
                        File file2 = fileArray[i];
                        String string2 = file2.getName();
                        if (string2.equals(".") || string2.equals("..")) continue;
                        if (file2.isDirectory()) {
                            String string3 = string;
                            if (string3.length() > 0) {
                                string3 = string3 + "/";
                            }
                            string3 = string3 + string2;
                            this.scanFolderForMatches(file2, string3, list);
                            continue;
                        }
                        if (!file2.isFile()) continue;
                        for (n = 0; n < this.extensionFilterArr.length && !string2.toLowerCase().endsWith(this.extensionFilterArr[n].toLowerCase()); ++n) {
                        }
                        if (n == this.extensionFilterArr.length) continue;
                        if (string.length() > 0) {
                            string2 = string + "/" + string2;
                        }
                        if ((startupStreamsFile = this.fileList.get(string2)) != null) {
                            startupStreamsFile.setTouched(true);
                            continue;
                        }
                        list.add(string2);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void startStreams(List<String> list) {
            for (String string : list) {
                StartupStreamsFile startupStreamsFile = new StartupStreamsFile(string);
                this.fileList.put(string, startupStreamsFile);
                WMSLoggerFactory.getLogger(ServerListenerStartupStreamsMonitor.class).info("ServerListenerStartupStreamsMonitor#StartupStreamsAppInstance.run[" + this.contextStr + "]: Start stream: " + string);
                try {
                    this.appInstance.startMediaCasterStream(string, this.streamPrefix, this.mediaCasterType);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(ServerListenerStartupStreamsMonitor.class).error("ServerListenerStartupStreamsMonitor#StartupStreamsAppInstance.run[" + this.contextStr + ":" + string + "]: " + exception.toString());
                }
            }
        }

        private void stopStreams(List<String> list) {
            for (String string : list) {
                this.fileList.remove(string);
                WMSLoggerFactory.getLogger(ServerListenerStartupStreamsMonitor.class).info("ServerListenerStartupStreamsMonitor#StartupStreamsAppInstance.run[" + this.contextStr + "]: Stop stream: " + string);
                try {
                    this.appInstance.stopMediaCasterStream(string);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(ServerListenerStartupStreamsMonitor.class).error("ServerListenerStartupStreamsMonitor#StartupStreamsAppInstance.run[" + this.contextStr + ":" + string + "]: " + exception.toString());
                }
            }
        }

        public void run() {
            try {
                File file;
                String string = this.appInstance.getStreamStoragePath();
                if (string != null && (file = new File(string)).exists()) {
                    this.clearTouch();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    this.scanFolderForMatches(file, "", arrayList);
                    List<String> list = this.getUntouchFiles();
                    this.startStreams(arrayList);
                    this.stopStreams(list);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ServerListenerStartupStreamsMonitor.class).error("ServerListenerStartupStreamsMonitor#StartupStreamsAppInstance.run[" + this.contextStr + "]: " + exception.toString());
            }
        }

        public String getStreamPrefix() {
            return this.streamPrefix;
        }

        public void setStreamPrefix(String string) {
            this.streamPrefix = string;
        }

        public String getMediaCasterType() {
            return this.mediaCasterType;
        }

        public void setMediaCasterType(String string) {
            this.mediaCasterType = string;
        }

        public String[] getExtensionFilter() {
            return this.extensionFilterArr;
        }

        public void setExtensionFilter(String[] stringArray) {
            this.extensionFilterArr = stringArray;
        }

        public void setExtensionFilter(String string) {
            this.extensionFilter = string;
        }
    }

    class StartupStreamsFile {
        boolean isTouched = false;
        String fileName = null;

        public StartupStreamsFile(String string) {
            this.fileName = string;
        }

        public boolean isTouched() {
            return this.isTouched;
        }

        public void setTouched(boolean bl) {
            this.isTouched = bl;
        }

        public String getFileName() {
            return this.fileName;
        }
    }

    class StartupStreamsMonitorThread
    extends Thread {
        int monitorFrequency = 1000;
        int incTime = 250;
        long lastRunTime = -1L;
        boolean isRunning = true;

        StartupStreamsMonitorThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopRunning() {
            StartupStreamsMonitorThread startupStreamsMonitorThread = this;
            synchronized (startupStreamsMonitorThread) {
                this.isRunning = false;
            }
        }

        public void setMonitorFrequency(int n) {
            this.monitorFrequency = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            WMSLoggerFactory.getLogger(ServerListenerStartupStreamsMonitor.class).info("ServerListenerStartupStreamsMonitor#StartupStreamsAppInstance.run: thread start");
            while (true) {
                StartupStreamsMonitorThread startupStreamsMonitorThread = this;
                synchronized (startupStreamsMonitorThread) {
                    if (!this.isRunning) {
                        break;
                    }
                }
                long l = System.currentTimeMillis();
                if (this.lastRunTime < 0L || l - this.lastRunTime >= (long)this.monitorFrequency) {
                    for (StartupStreamsAppInstance startupStreamsAppInstance : ServerListenerStartupStreamsMonitor.this.monitors.values()) {
                        startupStreamsAppInstance.run();
                    }
                    this.lastRunTime = System.currentTimeMillis();
                }
                try {
                    StartupStreamsMonitorThread startupStreamsMonitorThread2 = this;
                    synchronized (startupStreamsMonitorThread2) {
                        if (!this.isRunning) {
                            break;
                        }
                    }
                    Thread.currentThread();
                    Thread.sleep(this.incTime);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(ServerListenerStartupStreamsMonitor.class).error("ServerListenerStartupStreamsMonitor#StartupStreamsMonitorThread.run: " + exception.toString());
                }
            }
            WMSLoggerFactory.getLogger(ServerListenerStartupStreamsMonitor.class).info("ServerListenerStartupStreamsMonitor#StartupStreamsMonitorThread.run: thread stop");
        }
    }
}

