/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream;

import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleFunctions;
import com.wowza.wms.netconnection.INetConnection;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.server.Server;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamNotify;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStreamFactory;
import com.wowza.wms.stream.MediaStreamMapGroup;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizer;
import com.wowza.wms.stream.livepacketizer.LiveStreamPacketizerItem;
import com.wowza.wms.stream.livepacketizer.LiveStreamPacketizerList;
import com.wowza.wms.vhost.IVHost;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReentrantReadWriteLock;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaStreamMap {
    public static final int MAXSTREAMINDEX = 65536;
    protected Map<Long, IMediaStream> streams = new HashMap<Long, IMediaStream>();
    protected Map<String, IMediaStream> streamNames = new HashMap<String, IMediaStream>();
    protected Map<String, Set<MediaStreamMapGroup>> streamNameToGroup = null;
    protected List<MediaStreamMapGroup> nameGroups = null;
    protected int nameGroupId = 1;
    protected WMSReadWriteLock streamLock = new WMSReentrantReadWriteLock();
    protected WMSReadWriteLock streamNamesLock = new WMSReentrantReadWriteLock();
    protected IApplicationInstance appInstance = null;
    protected List<IMediaStreamNotify> mediaStreamListeners = new ArrayList<IMediaStreamNotify>();
    protected AtomicLong nextStreamId = new AtomicLong();
    protected Map<String, ILiveStreamPacketizer> liveStreamPacketizers = new HashMap<String, ILiveStreamPacketizer>();

    public MediaStreamMap(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
    }

    public WMSReadWriteLock getStreamListLock() {
        return this.streamLock;
    }

    public WMSReadWriteLock getStreamNameLock() {
        return this.streamNamesLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPublishStreamNames() {
        ArrayList<String> arrayList = null;
        this.streamNamesLock.readLock().lock();
        try {
            arrayList = new ArrayList<String>(this.streamNames.keySet());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.getPublishStreamNames[read]: " + exception.toString());
        }
        finally {
            this.streamNamesLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IMediaStream> getStreams() {
        ArrayList<IMediaStream> arrayList = new ArrayList<IMediaStream>();
        this.streamLock.readLock().lock();
        try {
            arrayList.addAll(this.streams.values());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.getStreams: " + exception.toString());
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        int n = arrayList.size();
        for (int i = n - 1; i >= 0; --i) {
            if (arrayList.get(i) != null) continue;
            arrayList.remove(i);
        }
        return arrayList;
    }

    public IMediaStream getStream(IClient iClient, int n) {
        return this.getStream(iClient, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMediaStream getStreamClientless(int n, String string) {
        IMediaStream iMediaStream = null;
        this.streamLock.readLock().lock();
        try {
            iMediaStream = this.streams.get(new Long(n));
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.getStreamClientless[read]: " + exception.toString());
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        if (iMediaStream == null) {
            iMediaStream = MediaStreamFactory.createStream(string, this, n);
            this.streamLock.writeLock().lock();
            try {
                this.streams.put(new Long(n), iMediaStream);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.getStreamClientless[write]: " + exception.toString());
            }
            finally {
                this.streamLock.writeLock().unlock();
            }
        }
        if (this.appInstance != null) {
            ModuleFunctions moduleFunctions = this.appInstance.getModFunctions();
            moduleFunctions.onStreamCreate(iMediaStream);
            this.notifyMediaStreamCreate(iMediaStream);
        }
        return iMediaStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMediaStream getStream(IClient iClient, int n, boolean bl) {
        Object object;
        Object object2;
        long l;
        IMediaStream iMediaStream;
        block21: {
            iMediaStream = null;
            l = n;
            if (iClient != null) {
                l = ((long)iClient.getClientId() << 32) + (long)n;
            }
            this.streamLock.readLock().lock();
            try {
                iMediaStream = this.streams.get(new Long(l));
                if (bl) break block21;
                object = object2 = ((Client)iClient).getStreamCache();
                synchronized (object) {
                    iMediaStream = object2.get(new Long(l));
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.getStream[read]: " + exception.toString());
            }
            finally {
                this.streamLock.readLock().unlock();
            }
        }
        if (iMediaStream == null && bl) {
            Object object3;
            object2 = "default";
            object = iClient.getStreamType();
            if (object != null) {
                object2 = object;
            }
            iMediaStream = MediaStreamFactory.createStream((String)object2, this, n);
            this.streamLock.writeLock().lock();
            try {
                this.streams.put(new Long(l), iMediaStream);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.getStream[write]: " + exception.toString());
            }
            finally {
                this.streamLock.writeLock().unlock();
            }
            if (iClient != null) {
                iMediaStream.setBufferTime(iClient.getBufferTime());
                iMediaStream.setLiveStreamPacketizerList(iClient.getLiveStreamPacketizerList());
                ((Client)iClient).registerStream(iMediaStream);
                iMediaStream.setClient(iClient);
                Object object4 = object3 = ((Client)iClient).getStreamCache();
                synchronized (object4) {
                    object3.put(new Long(l), iMediaStream);
                }
            }
            if (this.appInstance != null) {
                object3 = this.appInstance.getModFunctions();
                ((ModuleFunctions)object3).onStreamCreate(iMediaStream);
                this.notifyMediaStreamCreate(iMediaStream);
            }
        }
        return iMediaStream;
    }

    public IMediaStream getStream(INetConnection iNetConnection, int n) {
        return this.getStream(iNetConnection, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMediaStream getStream(INetConnection iNetConnection, int n, boolean bl) {
        IMediaStream iMediaStream = null;
        long l = n;
        if (iNetConnection != null) {
            l = ((long)iNetConnection.getNetConnectionId() << 32) + (long)n;
        }
        this.streamLock.readLock().lock();
        try {
            iMediaStream = this.streams.get(new Long(l));
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.getStream[read]: " + exception.toString());
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        if (iMediaStream == null && bl) {
            Object object;
            if (iNetConnection != null) {
                object = "default";
                String string = iNetConnection.getStreamType();
                if (string != null) {
                    object = string;
                }
                iMediaStream = MediaStreamFactory.createStream((String)object, this, n);
            } else {
                try {
                    object = Class.forName("com.wowza.wms.debugger.MediaStreamDebug");
                    if (object != null) {
                        iMediaStream = (IMediaStream)((Class)object).newInstance();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                iMediaStream.setSrc(n);
            }
            this.streamLock.writeLock().lock();
            try {
                this.streams.put(new Long(l), iMediaStream);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.getStream[write]: " + exception.toString());
            }
            finally {
                this.streamLock.writeLock().unlock();
            }
            if (iNetConnection != null) {
                iNetConnection.registerStream(iMediaStream);
            }
            if (this.appInstance != null) {
                object = this.appInstance.getModFunctions();
                ((ModuleFunctions)object).onStreamCreate(iMediaStream);
            }
        }
        return iMediaStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMediaStream getStream(String string) {
        IMediaStream iMediaStream = null;
        this.streamNamesLock.readLock().lock();
        try {
            iMediaStream = this.streamNames.get(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.getStream[read]: " + exception.toString());
        }
        finally {
            this.streamNamesLock.readLock().unlock();
        }
        return iMediaStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamName(IMediaStream iMediaStream, String string) {
        this.streamNamesLock.writeLock().lock();
        try {
            this.streamNames.put(string, iMediaStream);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.setStreamName[write]: " + exception.toString());
        }
        finally {
            this.streamNamesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStreamName(String string) {
        this.streamNamesLock.writeLock().lock();
        try {
            this.streamNames.remove(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.clearStreamName[write]: " + exception.toString());
        }
        finally {
            this.streamNamesLock.writeLock().unlock();
        }
    }

    public long streamToIndex(IMediaStream iMediaStream) {
        long l = iMediaStream.getSrc();
        IClient iClient = iMediaStream.getClient();
        if (iClient != null) {
            l = ((long)iClient.getClientId() << 32) + l;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStreamName(String string, IMediaStream iMediaStream) {
        this.streamNamesLock.writeLock().lock();
        try {
            IMediaStream iMediaStream2 = this.streamNames.get(string);
            if (iMediaStream2 != null && this.streamToIndex(iMediaStream) == this.streamToIndex(iMediaStream2)) {
                this.streamNames.remove(string);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.clearStreamName[write]: " + exception.toString());
        }
        finally {
            this.streamNamesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public int getNextStreamIndex(INetConnection iNetConnection) {
        int n = 0;
        while (true) {
            long l = ((long)iNetConnection.getNetConnectionId() << 32) + (long)(++n);
            Long l2 = new Long(l);
            this.streamLock.readLock().lock();
            try {
                if (this.streams.containsKey(l2)) {
                    l2 = null;
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.getNextStreamIndex[read]: " + exception.toString());
            }
            finally {
                this.streamLock.readLock().unlock();
            }
            if (l2 == null) continue;
            this.streamLock.writeLock().lock();
            try {
                if (this.streams.containsKey(l2)) {
                    l2 = null;
                } else {
                    this.streams.put(l2, null);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.getNextStreamIndex[write]: " + exception.toString());
            }
            finally {
                this.streamLock.writeLock().unlock();
            }
            if (l2 != null) return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public int getNextStreamIndex(IClient iClient) {
        int n = 0;
        while (true) {
            long l = ((long)iClient.getClientId() << 32) + (long)(++n);
            Long l2 = new Long(l);
            this.streamLock.readLock().lock();
            try {
                if (this.streams.containsKey(l2)) {
                    l2 = null;
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.getNextStreamIndex[read]: " + exception.toString());
            }
            finally {
                this.streamLock.readLock().unlock();
            }
            if (l2 == null) continue;
            this.streamLock.writeLock().lock();
            try {
                if (this.streams.containsKey(l2)) {
                    l2 = null;
                } else {
                    this.streams.put(l2, null);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.getNextStreamIndex[write]: " + exception.toString());
            }
            finally {
                this.streamLock.writeLock().unlock();
            }
            if (l2 != null) return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextStreamIndex() {
        int n = 0;
        while (true) {
            if ((n = (int)(this.nextStreamId.incrementAndGet() & 0xFFFFL)) == 0) {
                continue;
            }
            Long l = new Long(n);
            this.streamLock.readLock().lock();
            try {
                if (this.streams.containsKey(l)) {
                    l = null;
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.getNextStreamIndex[read]: " + exception.toString());
            }
            finally {
                this.streamLock.readLock().unlock();
            }
            if (l == null) continue;
            this.streamLock.writeLock().lock();
            try {
                if (this.streams.containsKey(l)) {
                    l = null;
                } else {
                    this.streams.put(l, null);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.getNextStreamIndex[write]: " + exception.toString());
            }
            finally {
                this.streamLock.writeLock().unlock();
            }
            if (l != null) break;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        int n = 0;
        this.streamLock.readLock().lock();
        try {
            n = this.streams.size();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.getCount: " + exception.toString());
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        return n;
    }

    public void removeStream(INetConnection iNetConnection, int n) {
        long l = ((long)iNetConnection.getNetConnectionId() << 32) + (long)n;
        this.removeStreamInternal(l, "netConnection");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStream(IClient iClient, int n) {
        Map<Long, IMediaStream> map;
        long l = ((long)iClient.getClientId() << 32) + (long)n;
        Map<Long, IMediaStream> map2 = map = ((Client)iClient).getStreamCache();
        synchronized (map2) {
            map.remove(new Long(l));
        }
        this.removeStreamInternal(l, "client");
    }

    public void removeStream(int n) {
        long l = n;
        this.removeStreamInternal(l, "clientless");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStreamInternal(long l, String string) {
        Object object;
        IMediaStream iMediaStream = null;
        this.streamLock.readLock().lock();
        try {
            iMediaStream = this.streams.get(new Long(l));
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.: " + exception.toString());
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        if (iMediaStream != null) {
            if (this.appInstance != null) {
                object = this.appInstance.getModFunctions();
                ((ModuleFunctions)object).onStreamDestroy(iMediaStream);
                this.notifyMediaStreamDestroy(iMediaStream);
            }
            iMediaStream.shutdown();
        } else {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).warn("MediaStreamMap.removeStreamInternal[read]: Stream index not found[" + string + "]: " + l);
        }
        this.streamLock.writeLock().lock();
        try {
            this.streams.remove(new Long(l));
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.removeStreamInternal[write]: " + exception.toString());
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
        if (iMediaStream != null) {
            INetConnection iNetConnection;
            object = (Client)iMediaStream.getClient();
            if (object != null) {
                ((Client)object).unregisterStream(iMediaStream);
                ((Client)object).removePlayStreams(iMediaStream);
                ((Client)object).removePublishStreams(iMediaStream);
            }
            if ((iNetConnection = iMediaStream.getNetConnection()) != null) {
                iNetConnection.unregisterStream(iMediaStream);
            }
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info(null, iMediaStream, "stream", "destroy", 200, iMediaStream.getSrc() + "");
        }
    }

    public String getAppName() {
        if (this.appInstance != null) {
            return this.appInstance.getApplication().getName();
        }
        return "client2server";
    }

    public String getAppInstanceName() {
        if (this.appInstance != null) {
            return this.appInstance.getName();
        }
        return "client2server";
    }

    public IVHost getVHost() {
        if (this.appInstance != null) {
            return this.appInstance.getVHost();
        }
        return null;
    }

    public IApplicationInstance getAppInstance() {
        return this.appInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPlayUnpublish(IMediaStream iMediaStream) {
        Boolean bl = false;
        String string = iMediaStream.getName();
        IMediaStream iMediaStream2 = null;
        this.streamNamesLock.readLock().lock();
        try {
            iMediaStream2 = this.streamNames.get(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.notifyPlayUnpublish[read]: " + exception.toString());
        }
        finally {
            this.streamNamesLock.readLock().unlock();
        }
        if (iMediaStream2 != null) {
            bl = this.streamToIndex(iMediaStream2) == this.streamToIndex(iMediaStream);
        }
        if (bl.booleanValue()) {
            this.notifyPlayUnpublish(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IMediaStream> getPlayStreamsByName(String string) {
        ArrayList<IMediaStream> arrayList = new ArrayList<IMediaStream>();
        ArrayList<IMediaStream> arrayList2 = new ArrayList<IMediaStream>();
        this.streamLock.readLock().lock();
        try {
            arrayList2.addAll(this.streams.values());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.getPlayStreamsByName: " + exception.toString());
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        for (IMediaStream iMediaStream : arrayList2) {
            if (iMediaStream == null || !iMediaStream.isPlay() || !iMediaStream.getName().equals(string)) continue;
            arrayList.add(iMediaStream);
        }
        arrayList2.clear();
        arrayList2 = null;
        return arrayList;
    }

    public void notifyPlayUnpublish(String string) {
        List<IMediaStream> list = this.getPlayStreamsByName(string);
        for (IMediaStream iMediaStream : list) {
            IClient iClient;
            IMediaStreamPlay iMediaStreamPlay = iMediaStream.getPlayer();
            if (iMediaStreamPlay != null) {
                iMediaStreamPlay.resetNoLookup();
            }
            if ((iClient = iMediaStream.getClient()) == null) continue;
            double d = iClient.getClientId();
            if (!iClient.isConnected()) continue;
            ResponseFunction responseFunction = new ResponseFunction(iClient, iMediaStream.getRespAMFDataObj());
            responseFunction.createDefaultMessage("onStatus", 0.0);
            responseFunction.setSrc(iMediaStream.getSrc());
            AMFDataObj aMFDataObj = null;
            aMFDataObj = new AMFDataObj();
            aMFDataObj.put("level", new AMFDataItem("status"));
            aMFDataObj.put("code", new AMFDataItem("NetStream.Play.UnpublishNotify"));
            aMFDataObj.put("description", new AMFDataItem(string + " is now unpublished."));
            aMFDataObj.put("clientid", new AMFDataItem(d));
            responseFunction.addBody(aMFDataObj);
            ((Client)iClient).getRespFunctions().add(responseFunction);
        }
    }

    public int broadcastGetObjectEncoding(IMediaStream iMediaStream) {
        int n = -1;
        List<IMediaStream> list = this.getPlayStreamsByName(iMediaStream.getName());
        for (IMediaStream iMediaStream2 : list) {
            IClient iClient = iMediaStream2.getClient();
            if (iClient == null) continue;
            int n2 = iClient.getObjectEncoding();
            if (n == -1) {
                n = n2;
                continue;
            }
            if (n2 >= n) continue;
            n = n2;
        }
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    public void broadcasePlayMessage(IMediaStream iMediaStream, long l, ByteBuffer byteBuffer, int n) {
        List<IMediaStream> list = this.getPlayStreamsByName(iMediaStream.getName());
        for (IMediaStream iMediaStream2 : list) {
            IClient iClient = iMediaStream2.getClient();
            if (iClient == null || !iClient.isConnected()) continue;
            ResponseFunction responseFunction = new ResponseFunction(iClient, iMediaStream2.getRespAMFDataObj());
            responseFunction.createBroadcastMessage(byteBuffer);
            responseFunction.setSrc(iMediaStream2.getSrc());
            responseFunction.setTimecode(l);
            responseFunction.setType(n == 0 ? 18 : 15);
            ((Client)iClient).getRespFunctions().add(responseFunction);
        }
    }

    public void notifyPlayPublish(IMediaStream iMediaStream) {
        List<IMediaStream> list = this.getPlayStreamsByName(iMediaStream.getName());
        for (IMediaStream iMediaStream2 : list) {
            IClient iClient;
            IMediaStreamPlay iMediaStreamPlay = iMediaStream2.getPlayer();
            if (iMediaStreamPlay != null) {
                iMediaStreamPlay.reset(true);
            }
            if ((iClient = iMediaStream2.getClient()) == null) continue;
            double d = iClient.getClientId();
            if (!iClient.isConnected()) continue;
            ResponseFunction responseFunction = new ResponseFunction(iClient, iMediaStream2.getRespAMFDataObj());
            responseFunction.createDefaultMessage("onStatus", 0.0);
            responseFunction.setSrc(iMediaStream2.getSrc());
            AMFDataObj aMFDataObj = null;
            aMFDataObj = new AMFDataObj();
            aMFDataObj.put("level", new AMFDataItem("status"));
            aMFDataObj.put("code", new AMFDataItem("NetStream.Play.PublishNotify"));
            aMFDataObj.put("description", new AMFDataItem(iMediaStream.getName() + " is now published."));
            aMFDataObj.put("clientid", new AMFDataItem(d));
            responseFunction.addBody(aMFDataObj);
            ((Client)iClient).getRespFunctions().add(responseFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMediaStreamListener(IMediaStreamNotify iMediaStreamNotify) {
        List<IMediaStreamNotify> list = this.mediaStreamListeners;
        synchronized (list) {
            this.mediaStreamListeners.add(iMediaStreamNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMediaStreamListener(IMediaStreamNotify iMediaStreamNotify) {
        List<IMediaStreamNotify> list = this.mediaStreamListeners;
        synchronized (list) {
            this.mediaStreamListeners.remove(iMediaStreamNotify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaStreamCreate(IMediaStream iMediaStream) {
        ArrayList<IMediaStreamNotify> arrayList = null;
        List<IMediaStreamNotify> list = this.mediaStreamListeners;
        synchronized (list) {
            arrayList = new ArrayList<IMediaStreamNotify>(this.mediaStreamListeners);
        }
        for (IMediaStreamNotify iMediaStreamNotify : arrayList) {
            iMediaStreamNotify.onMediaStreamCreate(iMediaStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMediaStreamDestroy(IMediaStream iMediaStream) {
        ArrayList<IMediaStreamNotify> arrayList = null;
        List<IMediaStreamNotify> list = this.mediaStreamListeners;
        synchronized (list) {
            arrayList = new ArrayList<IMediaStreamNotify>(this.mediaStreamListeners);
        }
        for (IMediaStreamNotify iMediaStreamNotify : arrayList) {
            iMediaStreamNotify.onMediaStreamDestroy(iMediaStream);
        }
    }

    private String getLiveStreamPacketizerID(String string, String string2) {
        return string2 + "|" + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getLiveStreamPacketizerIDs(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Object object = this.liveStreamPacketizers;
        synchronized (object) {
            arrayList2.addAll(this.liveStreamPacketizers.keySet());
        }
        object = "|" + string;
        for (String string2 : arrayList2) {
            if (!string2.endsWith((String)object)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public void removeLiveStreamPacketizer(String string) {
        List<String> list = this.getLiveStreamPacketizerIDs(string);
        for (String string2 : list) {
            int n = string2.indexOf("|");
            if (n < 0) continue;
            String string3 = string2.substring(0, n);
            this.removeLiveStreamPacketizer(string, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printLiveStreamPacketizers() {
        Map<String, ILiveStreamPacketizer> map = this.liveStreamPacketizers;
        synchronized (map) {
            Iterator<String> iterator = this.liveStreamPacketizers.keySet().iterator();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("******** LiveStreamPacketizers ********\n");
            while (iterator.hasNext()) {
                String string = iterator.next();
                ILiveStreamPacketizer iLiveStreamPacketizer = this.liveStreamPacketizers.get(string);
                stringBuffer.append("  packetizerName:" + string + ":" + iLiveStreamPacketizer + "\n");
            }
            System.out.println(stringBuffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILiveStreamPacketizer removeLiveStreamPacketizer(String string, String string2) {
        ILiveStreamPacketizer iLiveStreamPacketizer = null;
        String string3 = this.getLiveStreamPacketizerID(string, string2);
        Map<String, ILiveStreamPacketizer> map = this.liveStreamPacketizers;
        synchronized (map) {
            iLiveStreamPacketizer = this.liveStreamPacketizers.remove(string3);
        }
        if (iLiveStreamPacketizer != null) {
            this.appInstance.notifyLiveStreamPacketizerDestroy(iLiveStreamPacketizer);
            iLiveStreamPacketizer.shutdown();
            int n = iLiveStreamPacketizer.getLiveStreamPacketizerId();
            if (n > 0) {
                Server.getInstance().getClientIdGenerator().releaseId(n);
            }
            WMSLoggerFactory.getLogger(null).info("MediaStreamMap.removeLiveStreamPacketizer[" + this.appInstance.getApplication().getName() + "/" + this.appInstance.getName() + "/" + string + "]: Destroy live stream packetizer: " + string2);
        }
        return iLiveStreamPacketizer;
    }

    public Object getLiveStreamPacketizerLock() {
        return this.liveStreamPacketizers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILiveStreamPacketizer getLiveStreamPacketizer(String string, String string2, boolean bl) {
        IApplicationInstance iApplicationInstance;
        LiveStreamPacketizerItem liveStreamPacketizerItem;
        boolean bl2;
        ILiveStreamPacketizer iLiveStreamPacketizer;
        block14: {
            iLiveStreamPacketizer = null;
            bl2 = false;
            liveStreamPacketizerItem = null;
            iApplicationInstance = this.getAppInstance();
            String string3 = this.getLiveStreamPacketizerID(string, string2);
            Object object = this.liveStreamPacketizers;
            synchronized (object) {
                iLiveStreamPacketizer = this.liveStreamPacketizers.get(string3);
            }
            if (iLiveStreamPacketizer == null && bl) {
                try {
                    object = iApplicationInstance.getVHost();
                    LiveStreamPacketizerList liveStreamPacketizerList = object.getLiveStreamPacketizerList();
                    liveStreamPacketizerItem = liveStreamPacketizerList.getLiveStreamPacketizerDef(string2);
                    if (liveStreamPacketizerItem == null) {
                        WMSLoggerFactory.getLogger(null).warn("MediaStreamMap.getLiveStreamPacketizer: Can't find LiveStreamPacketizerItem: " + string2 + ":" + string);
                        break block14;
                    }
                    String string4 = liveStreamPacketizerItem.getBaseClass();
                    Class<?> clazz = Class.forName(string4);
                    if (clazz == null) {
                        WMSLoggerFactory.getLogger(null).warn("MediaStreamMap.getLiveStreamPacketizer: Error instantiating LiveStreamPacketizerItem[" + string2 + ":" + string + "]: " + string4);
                        break block14;
                    }
                    iLiveStreamPacketizer = (ILiveStreamPacketizer)clazz.newInstance();
                    int n = Server.getInstance().getClientIdGenerator().getNextId();
                    Map<String, ILiveStreamPacketizer> map = this.liveStreamPacketizers;
                    synchronized (map) {
                        ILiveStreamPacketizer iLiveStreamPacketizer2 = this.liveStreamPacketizers.get(string3);
                        if (iLiveStreamPacketizer2 == null) {
                            this.liveStreamPacketizers.put(string3, iLiveStreamPacketizer);
                            iLiveStreamPacketizer.setLiveStreamPacketizerId(n);
                            bl2 = true;
                        } else {
                            iLiveStreamPacketizer = iLiveStreamPacketizer2;
                            Server.getInstance().getClientIdGenerator().releaseId(n);
                        }
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(null).warn("MediaStreamMap.getLiveStreamPacketizer: Error instantiating LiveStreamPacketizerItem[" + string2 + ":" + string + "]: " + exception.toString());
                }
            }
        }
        if (bl2 && iLiveStreamPacketizer != null) {
            iApplicationInstance.notifyLiveStreamPacketizerCreate(iLiveStreamPacketizer, string);
            iLiveStreamPacketizer.init(string, string2, iApplicationInstance, liveStreamPacketizerItem);
            iApplicationInstance.notifyLiveStreamPacketizerInit(iLiveStreamPacketizer, string);
            WMSLoggerFactory.getLogger(null).info("MediaStreamMap.getLiveStreamPacketizer: Create live stream packetizer: " + string2 + ":" + string);
        }
        return iLiveStreamPacketizer;
    }

    private void initNameGroups() {
        if (this.nameGroups == null) {
            this.nameGroups = new ArrayList<MediaStreamMapGroup>();
        }
        if (this.streamNameToGroup == null) {
            this.streamNameToGroup = new HashMap<String, Set<MediaStreamMapGroup>>();
        }
    }

    private MediaStreamMapGroup nameGroupFind(MediaStreamMapGroup mediaStreamMapGroup) {
        MediaStreamMapGroup mediaStreamMapGroup2 = null;
        if (this.nameGroups != null) {
            String string = mediaStreamMapGroup.toHashString();
            for (MediaStreamMapGroup mediaStreamMapGroup3 : this.nameGroups) {
                if (!string.equals(mediaStreamMapGroup3.toHashString())) continue;
                mediaStreamMapGroup2 = mediaStreamMapGroup3;
                break;
            }
        }
        return mediaStreamMapGroup2;
    }

    private MediaStreamMapGroup nameGroupFind(int n) {
        MediaStreamMapGroup mediaStreamMapGroup = null;
        if (this.nameGroups != null) {
            for (MediaStreamMapGroup mediaStreamMapGroup2 : this.nameGroups) {
                if (n != mediaStreamMapGroup2.getId()) continue;
                mediaStreamMapGroup = mediaStreamMapGroup2;
                break;
            }
        }
        return mediaStreamMapGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStreamMapGroup addNameGroup(MediaStreamMapGroup mediaStreamMapGroup) {
        MediaStreamMapGroup mediaStreamMapGroup2 = null;
        this.streamNamesLock.writeLock().lock();
        try {
            this.initNameGroups();
            mediaStreamMapGroup2 = this.nameGroupFind(mediaStreamMapGroup);
            if (mediaStreamMapGroup2 == null) {
                mediaStreamMapGroup2 = mediaStreamMapGroup;
                this.nameGroups.add(mediaStreamMapGroup);
                Set<String> set = mediaStreamMapGroup.getNames();
                for (String string : set) {
                    Set<MediaStreamMapGroup> set2 = this.streamNameToGroup.get(string);
                    if (set2 == null) {
                        set2 = new HashSet<MediaStreamMapGroup>();
                        this.streamNameToGroup.put(string, set2);
                    }
                    set2.add(mediaStreamMapGroup);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.addNameGroup[write]: " + exception.toString());
        }
        finally {
            this.streamNamesLock.writeLock().unlock();
        }
        return mediaStreamMapGroup2;
    }

    private void removeNameGroupInternal(MediaStreamMapGroup mediaStreamMapGroup) {
        this.nameGroups.remove(mediaStreamMapGroup);
        Set<String> set = mediaStreamMapGroup.getNames();
        for (String string : set) {
            Set<MediaStreamMapGroup> set2 = this.streamNameToGroup.get(string);
            if (set2 == null) continue;
            set2.remove(mediaStreamMapGroup);
            if (set2.size() > 0) continue;
            this.streamNameToGroup.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStreamMapGroup removeNameGroup(int n) {
        MediaStreamMapGroup mediaStreamMapGroup = null;
        this.streamNamesLock.writeLock().lock();
        try {
            this.initNameGroups();
            mediaStreamMapGroup = this.nameGroupFind(n);
            if (mediaStreamMapGroup != null) {
                this.removeNameGroupInternal(mediaStreamMapGroup);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.removeNameGroup[write]: " + exception.toString());
        }
        finally {
            this.streamNamesLock.writeLock().unlock();
        }
        return mediaStreamMapGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStreamMapGroup removeNameGroup(MediaStreamMapGroup mediaStreamMapGroup) {
        MediaStreamMapGroup mediaStreamMapGroup2 = null;
        this.streamNamesLock.writeLock().lock();
        try {
            this.initNameGroups();
            mediaStreamMapGroup2 = this.nameGroupFind(mediaStreamMapGroup);
            if (mediaStreamMapGroup2 != null) {
                this.removeNameGroupInternal(mediaStreamMapGroup2);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.removeNameGroup[write]: " + exception.toString());
        }
        finally {
            this.streamNamesLock.writeLock().unlock();
        }
        return mediaStreamMapGroup2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MediaStreamMapGroup> getNameGroups() {
        HashSet<MediaStreamMapGroup> hashSet = null;
        this.streamNamesLock.readLock().lock();
        try {
            if (this.nameGroups != null) {
                hashSet = new HashSet<MediaStreamMapGroup>();
                hashSet.addAll(this.nameGroups);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.getNameGroups[read]: " + exception.toString());
        }
        finally {
            this.streamNamesLock.readLock().unlock();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MediaStreamMapGroup> getNameGroups(String string) {
        HashSet<MediaStreamMapGroup> hashSet = null;
        this.streamNamesLock.readLock().lock();
        try {
            Set<MediaStreamMapGroup> set;
            if (this.streamNameToGroup != null && (set = this.streamNameToGroup.get(string)) != null) {
                hashSet = new HashSet<MediaStreamMapGroup>();
                hashSet.addAll(set);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.getNameGroups[read]: " + exception.toString());
        }
        finally {
            this.streamNamesLock.readLock().unlock();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getNameGroupStreamNames(String string) {
        HashSet<String> hashSet = null;
        this.streamNamesLock.readLock().lock();
        try {
            Set<MediaStreamMapGroup> set;
            if (this.streamNameToGroup != null && (set = this.streamNameToGroup.get(string)) != null) {
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                }
                for (MediaStreamMapGroup mediaStreamMapGroup : set) {
                    mediaStreamMapGroup.addNamesToSet(hashSet);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaStreamMap.class).info("MediaStreamMap.getNameGroupStreamNames[read]: " + exception.toString());
        }
        finally {
            this.streamNamesLock.readLock().unlock();
        }
        return hashSet;
    }
}

