/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.util;

import com.wowza.util.NoMBean;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.util.IIdleNotify;
import java.util.ArrayList;
import java.util.List;

public class IdleWorkerUtil
extends Thread {
    private int pollFreq = 100;
    private int minimumWaitTime = 5;
    private boolean isRunning = true;
    private List<IIdleNotify> idleList = new ArrayList<IIdleNotify>();
    private int lastProcessingTime = 0;
    private int maxProcessingTime = 0;
    private int fellBehindCount = 0;
    private int index = 0;

    public IdleWorkerUtil(int n, int n2, int n3) {
        super("IdleWorkerUtil-" + n);
        this.index = n;
        this.pollFreq = n2;
    }

    public synchronized void halt() {
        this.isRunning = false;
    }

    @NoMBean
    public synchronized void registerIdleClient(IIdleNotify iIdleNotify) {
        this.idleList.add(iIdleNotify);
    }

    @NoMBean
    public synchronized void unregisterIdleClient(IIdleNotify iIdleNotify) {
        this.idleList.remove(iIdleNotify);
    }

    public int getMinimumWaitTime() {
        return this.minimumWaitTime;
    }

    public void setMinimumWaitTime(int n) {
        this.minimumWaitTime = n;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLastProcessingTime() {
        return this.lastProcessingTime;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public int getFellBehindCount() {
        return this.fellBehindCount;
    }

    public int getMaxProcessingTime() {
        return this.maxProcessingTime;
    }

    public int getPollFreq() {
        return this.pollFreq;
    }

    public void setPollFreq(int n) {
        this.pollFreq = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NoMBean
    public void run() {
        while (true) {
            ArrayList<IIdleNotify> arrayList = new ArrayList<IIdleNotify>();
            try {
                int n;
                int n2;
                arrayList.clear();
                IdleWorkerUtil idleWorkerUtil = this;
                synchronized (idleWorkerUtil) {
                    arrayList.addAll(this.idleList);
                }
                long l = System.currentTimeMillis();
                for (IIdleNotify iIdleNotify : arrayList) {
                    if (iIdleNotify == null) continue;
                    try {
                        iIdleNotify.onIdle(l);
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(IdleWorkerUtil.class).error("IdleWorkerUtil: run.work: " + exception.toString());
                    }
                    if (this.isRunning) continue;
                    break;
                }
                this.lastProcessingTime = (int)(System.currentTimeMillis() - l);
                if (this.lastProcessingTime > this.maxProcessingTime) {
                    this.maxProcessingTime = this.lastProcessingTime;
                }
                if ((n2 = this.pollFreq - this.lastProcessingTime) < (n = this.getMinimumWaitTime())) {
                    ++this.fellBehindCount;
                    n2 = n;
                }
                if (!this.isRunning) break;
                arrayList.clear();
                if (n2 > 0) {
                    IdleWorkerUtil.sleep(this.pollFreq);
                }
                if (this.isRunning) continue;
            }
            catch (InterruptedException interruptedException) {
                WMSLoggerFactory.getLogger(IdleWorkerUtil.class).error("IdleWorkerUtil: run: " + interruptedException.toString());
                continue;
            }
            break;
        }
    }
}

