/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.util;

import com.wowza.util.SystemUtils;
import com.wowza.util.XMLUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.http.IHTTPProvider;
import com.wowza.wms.http.IHTTPProvider2;
import com.wowza.wms.httpstreamer.model.HTTPStreamerItem;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerAdapter;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.transport.RTPUDPDatagramConfig;
import com.wowza.wms.rtp.transport.UDPTransportManager;
import com.wowza.wms.util.ApplicationUtils;
import com.wowza.wms.util.ServerUtils;
import com.wowza.wms.util.StreamUtils;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.HostPortConfig;
import com.wowza.wms.vhost.HostPortSSLConfig;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.StartupStream;
import com.wowza.wms.vhost.VHost;
import com.wowza.wms.vhost.VHostWorkerThread;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VHostUtils {
    public static void clearLoggingContext() {
        block0: {
            Thread thread = Thread.currentThread();
            if (thread == null || !(thread instanceof VHostWorkerThread)) break block0;
            ((VHostWorkerThread)Thread.currentThread()).clear();
        }
    }

    public static void loadHTTPProvider(Element element, IVHost iVHost, HostPort hostPort) {
        block8: {
            try {
                String string;
                XPathFactory xPathFactory = XMLUtils.newXPathFactory();
                XPath xPath = xPathFactory.newXPath();
                Node node = XMLUtils.getNodeByTagName(element, "BaseClass");
                if (node == null || (string = XMLUtils.getNodeValue(node)) == null || (string = string.trim()).length() <= 0) break block8;
                Class<?> clazz = Class.forName(string);
                if (clazz != null) {
                    IHTTPProvider iHTTPProvider = (IHTTPProvider)clazz.newInstance();
                    if (iHTTPProvider != null) {
                        try {
                            String string2 = "Properties/Property";
                            WMSProperties wMSProperties = new WMSProperties();
                            XMLUtils.loadConfigProperies(element, string2, wMSProperties);
                            iHTTPProvider.setProperties(wMSProperties);
                        }
                        catch (Exception exception) {
                            WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHTTPProvider: error parsing properties: " + exception.toString());
                            exception.printStackTrace();
                        }
                        if (iHTTPProvider instanceof IHTTPProvider2) {
                            ((IHTTPProvider2)iHTTPProvider).setRequestFilters(XMLUtils.getXMLPropertyStr(xPath, "RequestFilters", element, ((IHTTPProvider2)iHTTPProvider).getRequestFilters()));
                            ((IHTTPProvider2)iHTTPProvider).setAuthenticationMethod(XMLUtils.getXMLPropertyStr(xPath, "AuthenticationMethod", element, ((IHTTPProvider2)iHTTPProvider).getAuthenticationMethod()));
                        }
                        hostPort.addHttpProvider(iHTTPProvider);
                        if (iHTTPProvider instanceof IHTTPProvider2) {
                            ((IHTTPProvider2)iHTTPProvider).init();
                        }
                        break block8;
                    }
                    WMSLoggerFactory.getLogger(ServerUtils.class).error("loadHTTPProvider: Error creating httpProvider (" + string + "): Instance null");
                    break block8;
                }
                WMSLoggerFactory.getLogger(ServerUtils.class).error("loadHTTPProvider: Error creating httpProvider (" + string + "): Class null");
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHTTPProvider: error parsing HTTPProvider properties: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    public static void loadDatagramConfig(Element element, RTPUDPDatagramConfig rTPUDPDatagramConfig) {
        try {
            String string;
            Node node = XMLUtils.getNodeByTagName(element, "ReuseAddress");
            Node node2 = XMLUtils.getNodeByTagName(element, "MulticastBindToAddress");
            Node node3 = XMLUtils.getNodeByTagName(element, "MulticastInterfaceAddress");
            Node node4 = XMLUtils.getNodeByTagName(element, "ReceiveBufferSize");
            Node node5 = XMLUtils.getNodeByTagName(element, "SendBufferSize");
            Node node6 = XMLUtils.getNodeByTagName(element, "TrafficClass");
            Node node7 = XMLUtils.getNodeByTagName(element, "MulticastTimeout");
            Node node8 = XMLUtils.getNodeByTagName(element, "DatagramMaximumPacketSize");
            if (node != null) {
                string = XMLUtils.getNodeValue(node);
                try {
                    rTPUDPDatagramConfig.setReuseAddress(Boolean.parseBoolean(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadDatagramConfig: error parsing: configReuseAddress: (" + string + "): " + exception.toString());
                }
            }
            if (node2 != null) {
                string = XMLUtils.getNodeValue(node2);
                try {
                    rTPUDPDatagramConfig.setMulticastBindToAddress(Boolean.parseBoolean(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadDatagramConfig: error parsing: configMulticastBindToAddress: (" + string + "): " + exception.toString());
                }
            }
            if (node3 != null && (string = XMLUtils.getNodeValue(node3)) != null && string.trim().length() > 0) {
                rTPUDPDatagramConfig.setMulticastInterfaceAddress(string.trim());
            }
            if (node4 != null) {
                string = XMLUtils.getNodeValue(node4);
                try {
                    rTPUDPDatagramConfig.setReceiveBufferSize(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadDatagramConfig: error parsing: configReceiveBufferSize: (" + string + "): " + exception.toString());
                }
            }
            if (node5 != null) {
                string = XMLUtils.getNodeValue(node5);
                try {
                    rTPUDPDatagramConfig.setSendBufferSize(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadDatagramConfig: error parsing: configSendBufferSize: (" + string + "): " + exception.toString());
                }
            }
            if (node6 != null) {
                string = XMLUtils.getNodeValue(node6);
                try {
                    rTPUDPDatagramConfig.setTrafficClass(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadDatagramConfig: error parsing: configTrafficClass: (" + string + "): " + exception.toString());
                }
            }
            if (node7 != null) {
                string = XMLUtils.getNodeValue(node7);
                try {
                    rTPUDPDatagramConfig.setMulticastTimeout(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadDatagramConfig: error parsing: configMulticastTimeout: (" + string + "): " + exception.toString());
                }
            }
            if (node8 != null) {
                string = XMLUtils.getNodeValue(node8);
                try {
                    rTPUDPDatagramConfig.setDatagramMaximumPacketSize(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadDatagramConfig: error parsing: configDatagramMaximumPacketSizeElem: (" + string + "): " + exception.toString());
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostUtils.class).error("loadDatagramConfig: error parsing hostPortConfig properties: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void loadHostPortConfig(Element element, IVHost iVHost, HostPortConfig hostPortConfig) {
        try {
            String string;
            Node node = XMLUtils.getNodeByTagName(element, "ReuseAddress");
            Node node2 = XMLUtils.getNodeByTagName(element, "ReceiveBufferSize");
            Node node3 = XMLUtils.getNodeByTagName(element, "SendBufferSize");
            Node node4 = XMLUtils.getNodeByTagName(element, "TrafficClass");
            Node node5 = XMLUtils.getNodeByTagName(element, "KeepAlive");
            Node node6 = XMLUtils.getNodeByTagName(element, "OobInline");
            Node node7 = XMLUtils.getNodeByTagName(element, "SoLingerTime");
            Node node8 = XMLUtils.getNodeByTagName(element, "TcpNoDelay");
            Node node9 = XMLUtils.getNodeByTagName(element, "AcceptorBackLog");
            if (node9 != null) {
                string = XMLUtils.getNodeValue(node9);
                try {
                    hostPortConfig.setAcceptorBackLog(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing: configAcceptorBackLog: (" + string + "): " + exception.toString());
                }
            }
            if (node != null) {
                string = XMLUtils.getNodeValue(node);
                try {
                    hostPortConfig.setReuseAddress(Boolean.parseBoolean(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing: configReuseAddress: (" + string + "): " + exception.toString());
                }
            }
            if (node2 != null) {
                string = XMLUtils.getNodeValue(node2);
                try {
                    hostPortConfig.setReceiveBufferSize(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing: configReceiveBufferSize: (" + string + "): " + exception.toString());
                }
            }
            if (node3 != null) {
                string = XMLUtils.getNodeValue(node3);
                try {
                    hostPortConfig.setSendBufferSize(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing: configSendBufferSize: (" + string + "): " + exception.toString());
                }
            }
            if (node4 != null) {
                string = XMLUtils.getNodeValue(node4);
                try {
                    hostPortConfig.setTrafficClass(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing: configTrafficClass: (" + string + "): " + exception.toString());
                }
            }
            if (node5 != null) {
                string = XMLUtils.getNodeValue(node5);
                try {
                    hostPortConfig.setKeepAlive(Boolean.parseBoolean(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing: configKeepAlive: (" + string + "): " + exception.toString());
                }
            }
            if (node6 != null) {
                string = XMLUtils.getNodeValue(node6);
                try {
                    hostPortConfig.setOobInline(Boolean.parseBoolean(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing: configOobInline: (" + string + "): " + exception.toString());
                }
            }
            if (node7 != null) {
                string = XMLUtils.getNodeValue(node7);
                try {
                    hostPortConfig.setSoLinger(Integer.parseInt(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing: configSoLingerTime: (" + string + "): " + exception.toString());
                }
            }
            if (node8 != null) {
                string = XMLUtils.getNodeValue(node8);
                try {
                    hostPortConfig.setTcpNoDelay(Boolean.parseBoolean(string));
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing: configTcpNoDelay: (" + string + "): " + exception.toString());
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPortConfig: error parsing hostPortConfig properties: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static HostPortSSLConfig loadHostPortSSLConfig(Element element, IVHost iVHost) {
        HostPortSSLConfig hostPortSSLConfig = null;
        try {
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            Node node = XMLUtils.getNodeByTagName(element, "KeyStorePath");
            Node node2 = XMLUtils.getNodeByTagName(element, "KeyStorePassword");
            Node node3 = XMLUtils.getNodeByTagName(element, "KeyStoreType");
            Node node4 = XMLUtils.getNodeByTagName(element, "SSLProtocol");
            Node node5 = XMLUtils.getNodeByTagName(element, "Algorithm");
            if (node != null && node2 != null) {
                String string;
                hostPortSSLConfig = new HostPortSSLConfig();
                String string2 = XMLUtils.getNodeValue(node);
                String string3 = XMLUtils.getNodeValue(node2);
                hostPortSSLConfig.setKeyStorePath(string2);
                hostPortSSLConfig.setKeyStorePass(string3);
                if (node3 != null) {
                    string = XMLUtils.getNodeValue(node3);
                    hostPortSSLConfig.setKeyStoreType(string);
                }
                if (node4 != null) {
                    string = XMLUtils.getNodeValue(node4);
                    hostPortSSLConfig.setSSLProtocol(string);
                }
                if (node5 != null) {
                    string = XMLUtils.getNodeValue(node5);
                    hostPortSSLConfig.setAlgorithm(string);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPortSSLConfig: error parsing server properties: " + exception.toString());
            exception.printStackTrace();
        }
        return hostPortSSLConfig;
    }

    public static HostPort loadHostPort(Element element, IVHost iVHost, int n) {
        HostPort hostPort = null;
        try {
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            Node node = XMLUtils.getNodeByTagName(element, "DomainName");
            Node node2 = XMLUtils.getNodeByTagName(element, "IpAddress");
            Node node3 = XMLUtils.getNodeByTagName(element, "Port");
            Node node4 = XMLUtils.getNodeByTagName(element, "SSLFactoryClass");
            Node node5 = XMLUtils.getNodeByTagName(element, "SSLConfig");
            Node node6 = XMLUtils.getNodeByTagName(element, "ProcessorCount");
            Node node7 = XMLUtils.getNodeByTagName(element, "HTTPStreamerAdapterIDs");
            if ((node != null || node2 != null) && node3 != null) {
                NodeList nodeList;
                Object object;
                Object object2;
                String string = XMLUtils.getNodeValue(node);
                String string2 = XMLUtils.getNodeValue(node2);
                String string3 = XMLUtils.getNodeValue(node3);
                String string4 = XMLUtils.getNodeValue(node4);
                String string5 = XMLUtils.getNodeValue(node6);
                String string6 = XMLUtils.getNodeValue(node7);
                hostPort = new HostPort();
                if (node2 != null) {
                    if (string2 != null) {
                        string2 = SystemUtils.expandEnvironmentVariables(string2);
                    }
                    hostPort.setIpAddress(string2);
                } else if (node != null) {
                    if (string != null) {
                        string = SystemUtils.expandEnvironmentVariables(string);
                    }
                    hostPort.setDomainName(string);
                }
                if (string6 != null) {
                    string6 = string6.replace(",", "|");
                    string6 = string6.replace(";", "|");
                    object2 = string6.split("[|]");
                    for (int i = 0; i < ((String[])object2).length; ++i) {
                        object = object2[i].trim();
                        if (((String)object).length() <= 0) continue;
                        hostPort.addHTTPStreamerAdapterID((String)object);
                    }
                }
                if (n >= 0) {
                    hostPort.setPort(n);
                } else {
                    hostPort.setPort(Integer.parseInt(string3));
                }
                hostPort.setSslFactoryClass(string4);
                if (node5 != null && (object2 = VHostUtils.loadHostPortSSLConfig((Element)node5, iVHost)) != null) {
                    hostPort.setSSLConfig((HostPortSSLConfig)object2);
                }
                if (string5 != null && string5.length() > 0) {
                    hostPort.setProcessorCount(Integer.parseInt(string5));
                }
                object2 = (Element)XMLUtils.getNodeByTagName(element, "SocketConfiguration");
                HostPortConfig hostPortConfig = hostPort.getConfiguation();
                if (object2 != null && hostPortConfig != null) {
                    VHostUtils.loadHostPortConfig((Element)object2, iVHost, hostPortConfig);
                }
                if ((nodeList = (NodeList)(object = xPath.compile("HTTPProviders/HTTPProvider")).evaluate(element, XPathConstants.NODESET)) != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        VHostUtils.loadHTTPProvider((Element)nodeList.item(i), iVHost, hostPort);
                    }
                }
            } else {
                WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing server properties: <DomainName> or <IpAddress> and <Port> required");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing server properties: " + exception.toString());
            exception.printStackTrace();
        }
        return hostPort;
    }

    public static HostPort loadHostPort(Element element, IVHost iVHost, String string) {
        HostPort hostPort = null;
        try {
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile(string);
            Node node = (Node)xPathExpression.evaluate(element, XPathConstants.NODE);
            if (node != null) {
                hostPort = VHostUtils.loadHostPort((Element)node, null, -1);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPort: error parsing server properties: " + exception.toString());
            exception.printStackTrace();
        }
        return hostPort;
    }

    public static void loadHostPortList(Element element, String string, IVHost iVHost) {
        block6: {
            try {
                XPathFactory xPathFactory = XMLUtils.newXPathFactory();
                XPath xPath = xPathFactory.newXPath();
                XPathExpression xPathExpression = xPath.compile(string);
                NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
                if (nodeList == null) break block6;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    Element element2 = (Element)node;
                    Node node2 = XMLUtils.getNodeByTagName(element2, "Port");
                    if (node2 == null) continue;
                    String string2 = XMLUtils.getNodeValue(node2);
                    String[] stringArray = string2.split(",");
                    for (int j = 0; j < stringArray.length; ++j) {
                        String string3 = stringArray[j].trim();
                        if (string3.length() <= 0) continue;
                        int n = -1;
                        try {
                            n = Integer.parseInt(string3);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (n < 0) continue;
                        HostPort hostPort = VHostUtils.loadHostPort(element2, null, n);
                        iVHost.getHostPortsList().add(hostPort);
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHostPortList: error parsing HostPortList: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    public static boolean doesApplicationExist(String string) {
        boolean bl = false;
        WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("Loading ApplicationExists.xml: " + string);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            if (document != null) {
                Element element = document.getDocumentElement();
                bl = XMLUtils.getXMLPropertyBool(xPath, "/Root/Application/Exists", element, false);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostUtils.class).error("doesApplicationExist: error parsing appExists config file: (" + string + ") error: " + exception.toString());
            exception.printStackTrace();
        }
        return bl;
    }

    public static List getApplicationFolders(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("Loading ApplicationNames.xml: " + string);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            if (document != null) {
                Element element = document.getDocumentElement();
                String string2 = "/Root/Applications/Application/Name";
                XPathExpression xPathExpression = xPath.compile(string2);
                NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node = nodeList.item(i);
                        String string3 = XMLUtils.getNodeValue(node);
                        arrayList.add(string3);
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostUtils.class).error("getApplicationFolders: error parsing application list config file: (" + string + ") error: " + exception.toString());
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static IHTTPStreamerAdapter loadHTTPStreamerAdapter(Element element, IVHost iVHost) {
        IHTTPStreamerAdapter iHTTPStreamerAdapter;
        block9: {
            iHTTPStreamerAdapter = null;
            try {
                Node node = XMLUtils.getNodeByTagName(element, "ID");
                Node node2 = XMLUtils.getNodeByTagName(element, "Name");
                if (node != null && node2 != null) {
                    String string = XMLUtils.getNodeValue(node);
                    String string2 = XMLUtils.getNodeValue(node2);
                    HTTPStreamerItem hTTPStreamerItem = iVHost.getHTTPStreamerList().getHTTPStreamerDef(string2);
                    if (hTTPStreamerItem != null) {
                        Object object;
                        String string3 = hTTPStreamerItem.getBaseClass();
                        try {
                            object = Class.forName(string3);
                            if (object != null) {
                                iHTTPStreamerAdapter = (IHTTPStreamerAdapter)((Class)object).newInstance();
                            } else {
                                WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHTTPStreamerAdapter: HTTPStreamerDef could not find class: " + string3);
                            }
                        }
                        catch (Exception exception) {
                            WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHTTPStreamerAdapter: HTTPStreamerDef error create class[" + string3 + "]: " + exception.toString());
                        }
                        if (iHTTPStreamerAdapter != null) {
                            object = "Properties/Property";
                            WMSProperties wMSProperties = new WMSProperties();
                            XMLUtils.loadConfigProperies(element, (String)object, wMSProperties);
                            iHTTPStreamerAdapter.setID(string);
                            iHTTPStreamerAdapter.setHTTPStreamerItem(hTTPStreamerItem);
                            iHTTPStreamerAdapter.setVHost(iVHost);
                            iHTTPStreamerAdapter.setProperties(hTTPStreamerItem.getProperties());
                            iHTTPStreamerAdapter.setProperties(wMSProperties);
                        }
                        break block9;
                    }
                    WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHTTPStreamerAdapter: HTTPStreamerDef could not be found: " + string2);
                    break block9;
                }
                WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHTTPStreamerAdapter: error parsing server properties: <Name> and <ID> required");
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHTTPStreamerAdapter: error parsing server properties: " + exception.toString());
                exception.printStackTrace();
            }
        }
        return iHTTPStreamerAdapter;
    }

    public static void loadHTTPStreamerAdapters(Element element, String string, IVHost iVHost) {
        try {
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile(string);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    Element element2 = (Element)node;
                    IHTTPStreamerAdapter iHTTPStreamerAdapter = VHostUtils.loadHTTPStreamerAdapter(element2, iVHost);
                    if (iHTTPStreamerAdapter == null) continue;
                    iVHost.putHTTPStreamerAdapter(iHTTPStreamerAdapter.getID(), iHTTPStreamerAdapter);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostUtils.class).error("loadHTTPStreamerAdapters: error parsing HostPortList: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static StartupStream loadStartupStream(Element element, IVHost iVHost) {
        StartupStream startupStream = null;
        try {
            Node node = XMLUtils.getNodeByTagName(element, "Application");
            Node node2 = XMLUtils.getNodeByTagName(element, "MediaCasterType");
            Node node3 = XMLUtils.getNodeByTagName(element, "StreamName");
            if (node != null && node2 != null && node3 != null) {
                String string = XMLUtils.getNodeValue(node);
                String string2 = XMLUtils.getNodeValue(node2);
                String string3 = XMLUtils.getNodeValue(node3);
                startupStream = new StartupStream();
                startupStream.setApplicationName(string);
                startupStream.setMediaCasterType(string2);
                startupStream.setStreamName(string3);
            } else {
                WMSLoggerFactory.getLogger(VHostUtils.class).error("loadStartupStream: error parsing server properties: <Application>, <MediaCasterType> and <StreamName> required");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostUtils.class).error("loadStartupStream: error parsing server properties: " + exception.toString());
            exception.printStackTrace();
        }
        return startupStream;
    }

    public static void loadStartupStreams(IVHost iVHost, String string) {
        WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("Loading StartupStreams.xml: " + string);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            if (document != null) {
                Element element = document.getDocumentElement();
                XPathExpression xPathExpression = xPath.compile("StartupStreams/StartupStream");
                NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node = nodeList.item(i);
                        Element element2 = (Element)node;
                        StartupStream startupStream = VHostUtils.loadStartupStream(element2, iVHost);
                        if (startupStream == null) continue;
                        iVHost.addStartupStream(startupStream);
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostUtils.class).error("loadStartupStreams: error parsing vhost config file: (" + string + ") error: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void loadConfigFile(IVHost iVHost, String string) {
        WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("Loading VHost.xml: " + string);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            if (document != null) {
                String string2;
                Element element = document.getDocumentElement();
                String string3 = "/Root/VHost/Properties/Property";
                WMSProperties wMSProperties = iVHost.getProperties();
                XMLUtils.loadConfigProperies(element, string3, wMSProperties);
                String string4 = "/Root/VHost/HostPortList/HostPort";
                VHostUtils.loadHostPortList(element, string4, iVHost);
                String string5 = "/Root/VHost/AdminInterface/HostPort";
                HostPort hostPort = VHostUtils.loadHostPort(element, iVHost, string5);
                iVHost.setAdminInterfaceHostPort(hostPort);
                String string6 = "/Root/VHost/HTTPStreamerAdapters/HTTPStreamerAdapter";
                VHostUtils.loadHTTPStreamerAdapters(element, string6, iVHost);
                RTPContext rTPContext = iVHost.getRTPContext();
                XPathExpression xPathExpression = null;
                Node node = null;
                xPathExpression = xPath.compile("/Root/VHost/RTP/DatagramConfiguration/Incoming");
                node = (Node)xPathExpression.evaluate(element, XPathConstants.NODE);
                if (node != null) {
                    VHostUtils.loadDatagramConfig((Element)node, iVHost.getRTPDatagramConfigIncoming());
                }
                if ((node = (Node)(xPathExpression = xPath.compile("/Root/VHost/RTP/DatagramConfiguration/Outgoing")).evaluate(element, XPathConstants.NODE)) != null) {
                    VHostUtils.loadDatagramConfig((Element)node, iVHost.getRTPDatagramConfigOutgoing());
                }
                iVHost.setNetConnectionProcessorCount(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/NetConnections/ProcessorCount", element, iVHost.getNetConnectionProcessorCount()));
                iVHost.setNetConnectionIdleFrequency(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/NetConnections/IdleFrequency", element, iVHost.getNetConnectionIdleFrequency()));
                XPathExpression xPathExpression2 = xPath.compile("/Root/VHost/NetConnections/SocketConfiguration");
                Node node2 = (Node)xPathExpression2.evaluate(element, XPathConstants.NODE);
                if (node2 != null) {
                    VHostUtils.loadHostPortConfig((Element)node2, iVHost, iVHost.getNetConnectionHostPortConfig());
                }
                if ((string2 = XMLUtils.getXMLPropertyStr(xPath, "/Root/VHost/Internal/ByteArrayOutputStream/BaseClass", element)) != null) {
                    ((VHost)iVHost).setByteArrayOutputStreamBaseClassPath(string2);
                }
                iVHost.setKeepAliveTimeout(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/HTTPTunnel/KeepAliveTimeout", element, iVHost.getKeepAliveTimeout()));
                if (XMLUtils.getXMLPropertyExists(xPath, "/Root/VHost/ThreadPool/PoolSize", element)) {
                    int n = XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/ThreadPool/PoolSize", element, 0);
                    iVHost.setCoreHandlerPoolSize(n / 2);
                    iVHost.setCoreTransportPoolSize(n / 2);
                } else {
                    iVHost.setCoreTransportPoolSize(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/TransportThreadPool/PoolSize", element, iVHost.getCoreTransportPoolSize()));
                    iVHost.setCoreHandlerPoolSize(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/HandlerThreadPool/PoolSize", element, iVHost.getCoreHandlerPoolSize()));
                }
                iVHost.setFileIOPoolSize(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/FileIO/PoolSize", element, iVHost.getFileIOPoolSize()));
                iVHost.setIdleCheckFrequency(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/IdleWorkers/CheckFrequency", element, iVHost.getIdleCheckFrequency()));
                iVHost.setIdleWorkerCount(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/IdleWorkers/WorkerCount", element, iVHost.getIdleWorkerCount()));
                iVHost.setIdleMinimumWaitTime(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/IdleWorkers/MinimumWaitTime", element, iVHost.getIdleMinimumWaitTime()));
                iVHost.setClientTimeout(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/Client/ClientTimeout", element, iVHost.getClientTimeout()));
                iVHost.setClientIdleFrequency(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/Client/IdleFrequency", element, iVHost.getClientIdleFrequency()));
                iVHost.setRTPIdleFrequency(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/RTP/IdleFrequency", element, iVHost.getRTPIdleFrequency()));
                iVHost.setApplicationTimeout(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/Application/ApplicationTimeout", element, iVHost.getApplicationTimeout()));
                iVHost.setPingTimeout(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/Application/PingTimeout", element, iVHost.getPingTimeout()));
                iVHost.setValidationFrequency(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/Application/ValidationFrequency", element, iVHost.getValidationFrequency()));
                iVHost.setMaximumPendingWriteBytes(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/Application/MaximumPendingWriteBytes", element, iVHost.getMaximumPendingWriteBytes()));
                iVHost.setMaximumSetBufferTime(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/Application/MaximumSetBufferTime", element, iVHost.getMaximumSetBufferTime()));
                iVHost.setStartStarupStreams(XMLUtils.getXMLPropertyBool(xPath, "/Root/VHost/StartStartupStreams", element, iVHost.isStartStarupStreams()));
                UDPTransportManager uDPTransportManager = iVHost.getUDPTransportManager();
                uDPTransportManager.setUnicastIncomingProcessorCount(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/RTP/UnicastIncoming/ProcessorCount", element, uDPTransportManager.getUnicastIncomingProcessorCount()));
                uDPTransportManager.setUnicastOutgoingProcessorCount(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/RTP/UnicastOutgoing/ProcessorCount", element, uDPTransportManager.getUnicastOutgoingProcessorCount()));
                uDPTransportManager.setMulticastIncomingProcessorCount(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/RTP/MulticastIncoming/ProcessorCount", element, uDPTransportManager.getMulticastIncomingProcessorCount()));
                uDPTransportManager.setMulticastOutgoingProcessorCount(XMLUtils.getXMLPropertyInt(xPath, "/Root/VHost/RTP/MulticastOutgoing/ProcessorCount", element, uDPTransportManager.getMulticastOutgoingProcessorCount()));
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(VHostUtils.class).error("loadConfigFile: error parsing vhost config file: (" + string + ") error: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static void loadMP3TagMap(Map map, String string) {
        WMSLoggerFactory.getLogger(ApplicationUtils.class).debug("Loading MP3Tags.xml: " + string);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            XPathFactory xPathFactory = XMLUtils.newXPathFactory();
            XPath xPath = xPathFactory.newXPath();
            String string2 = "/Root/MP3Tags/MP3Tag";
            if (document != null) {
                Element element = document.getDocumentElement();
                XPathExpression xPathExpression = xPath.compile(string2);
                NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node = nodeList.item(i);
                        Element element2 = (Element)node;
                        Node node2 = XMLUtils.getNodeByTagName(element2, "Name");
                        Node node3 = XMLUtils.getNodeByTagName(element2, "ID");
                        if (node2 == null || node3 == null) continue;
                        String string3 = XMLUtils.getNodeValue(node2);
                        String string4 = XMLUtils.getNodeValue(node3);
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("name", string3);
                        hashMap.put("id", string4);
                        if (map.containsKey(string4)) continue;
                        WMSLoggerFactory.getLogger(VHostUtils.class).debug("MP3map " + string3 + "=" + string4);
                        map.put(string4, hashMap);
                    }
                } else {
                    WMSLoggerFactory.getLogger(StreamUtils.class).error("error parsing stream config file: (" + string + ") error: XPath " + string2 + " missing");
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(StreamUtils.class).error("error parsing stream config file: (" + string + ") error: " + exception.toString());
            exception.printStackTrace();
        }
    }
}

