/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.vhost;

import com.wowza.wms.http.IHTTPProvider;
import com.wowza.wms.http.IHTTPProvider2;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.vhost.HostPortConfig;
import com.wowza.wms.vhost.HostPortSSLConfig;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostPort {
    private int port = 0;
    private String sslFactoryClass = "";
    private HostPortSSLConfig sslConfig = null;
    private InetAddress address = null;
    private int processorCount = 1;
    private String domainName = null;
    private String ipAddress = null;
    private HostPortConfig configuation = new HostPortConfig();
    private List<IHTTPProvider> httpProviders = new ArrayList<IHTTPProvider>();
    private List<String> httpStreamerAdapterIDs = null;
    private boolean isSuspended = false;

    public void setDomainName(String string) {
        try {
            this.domainName = string;
            this.address = string.equals("*") ? null : InetAddress.getByName(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HostPort.class).error("setDomainName: " + exception.toString());
        }
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public String getAddressStr() {
        String string = "";
        if (this.address == null) {
            string = "[any]";
        } else if (this.domainName != null) {
            string = this.domainName;
        } else if (this.ipAddress != null) {
            string = this.ipAddress;
        }
        return string;
    }

    public String getAddressRawStr() {
        String string = "";
        if (this.address == null) {
            string = "localhost";
        } else if (this.domainName != null) {
            string = this.domainName;
        } else if (this.ipAddress != null) {
            string = this.ipAddress;
        }
        return string;
    }

    public void setIpAddress(String string) {
        try {
            this.ipAddress = string;
            if (string.equals("*")) {
                this.address = null;
            } else if (string != null) {
                this.address = InetAddress.getByName(string);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(HostPort.class).error("setIpAddress: " + exception.toString());
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getSslFactoryClass() {
        return this.sslFactoryClass;
    }

    public void setSslFactoryClass(String string) {
        this.sslFactoryClass = string;
    }

    public int getProcessorCount() {
        return this.processorCount;
    }

    public void setProcessorCount(int n) {
        this.processorCount = n;
    }

    public String toString(boolean bl) {
        String string = "";
        if (bl) {
            if (this.address == null) {
                string = "[any]";
            } else if (this.domainName != null) {
                string = this.domainName;
            } else if (this.ipAddress != null) {
                string = this.ipAddress;
            }
            string = string + "-" + this.port;
        } else {
            if (this.address == null) {
                string = "[any]";
            } else if (this.domainName != null) {
                string = this.domainName;
            } else if (this.ipAddress != null) {
                string = this.ipAddress;
            }
            string = string + ":" + this.port;
        }
        return string;
    }

    public String toString() {
        return this.toString(false);
    }

    public HostPortConfig getConfiguation() {
        return this.configuation;
    }

    public void configureSocketAcceptor(SocketAcceptorConfig socketAcceptorConfig) {
        this.configuation.configureSocketAcceptor(socketAcceptorConfig);
    }

    public List<IHTTPProvider> getHttpProviders() {
        return this.httpProviders;
    }

    public void addHttpProvider(IHTTPProvider iHTTPProvider) {
        this.httpProviders.add(iHTTPProvider);
    }

    public void addHttpProvider(IHTTPProvider2 iHTTPProvider2) {
        this.httpProviders.add(iHTTPProvider2);
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public void setSuspended(boolean bl) {
        this.isSuspended = bl;
    }

    public List<String> getHTTPStreamerAdapterIDs() {
        return this.httpStreamerAdapterIDs;
    }

    public void addHTTPStreamerAdapterID(String string) {
        if (this.httpStreamerAdapterIDs == null) {
            this.httpStreamerAdapterIDs = new ArrayList<String>();
        }
        this.httpStreamerAdapterIDs.add(string);
    }

    public HostPortSSLConfig getSSLConfig() {
        return this.sslConfig;
    }

    public void setSSLConfig(HostPortSSLConfig hostPortSSLConfig) {
        this.sslConfig = hostPortSSLConfig;
    }
}

