/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.vhost;

import com.wowza.util.NoMBean;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.ThreadPoolExecutorReinit;
import com.wowza.wms.vhost.VHostWorkerThread;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPool {
    private ThreadPoolExecutor threadPool = null;
    private LinkedBlockingQueue queue = null;
    private IVHost vhost = null;
    private String name = "Generic";
    private int threadIndex = 0;

    public ThreadPool(IVHost iVHost, String string) {
        this.vhost = iVHost;
        this.name = string;
    }

    @NoMBean
    public void init(int n) {
        int n2 = 5000;
        class SimpleThreadFactory
        implements ThreadFactory {
            SimpleThreadFactory() {
            }

            public Thread newThread(Runnable runnable) {
                VHostWorkerThread vHostWorkerThread = null;
                try {
                    vHostWorkerThread = new VHostWorkerThread(runnable, ThreadPool.this.vhost);
                    vHostWorkerThread.setPriority(10);
                    vHostWorkerThread.setName(ThreadPool.this.name + "." + ++ThreadPool.this.threadIndex);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(ThreadPool.class).error("SimpleThreadFactory: newThread: " + exception.toString());
                }
                if (vHostWorkerThread == null) {
                    WMSLoggerFactory.getLogger(ThreadPool.class).error("SimpleThreadFactory: newThread: null thread");
                }
                return vHostWorkerThread;
            }
        }
        SimpleThreadFactory simpleThreadFactory = new SimpleThreadFactory();
        this.queue = new LinkedBlockingQueue();
        this.threadPool = new ThreadPoolExecutorReinit(n, n, n2, TimeUnit.MILLISECONDS, this.queue);
        this.threadPool.setThreadFactory(simpleThreadFactory);
    }

    @NoMBean
    public void terminate() {
        if (this.threadPool != null) {
            try {
                this.threadPool.shutdown();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ThreadPool.class).error("terminate: " + exception.toString());
            }
        }
    }

    @NoMBean
    public void execute(Runnable runnable) {
        if (this.threadPool != null) {
            try {
                this.threadPool.execute(runnable);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ThreadPool.class).error("execute: " + exception.toString());
            }
        }
    }

    @NoMBean
    public Executor getExecutor() {
        return this.threadPool;
    }

    public int getActiveCount() {
        return this.threadPool.getActiveCount();
    }

    public int getQueueSize() {
        return this.queue.size();
    }
}

