/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.vhost;

import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.Server;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.IWorkerThreadClear;

public class VHostWorkerThread
extends Thread
implements IWorkerThreadClear {
    IVHost vhost = null;
    boolean nullVHost = false;
    String logContext = null;
    Client client = null;
    IApplicationInstance appInstance = null;

    public VHostWorkerThread(Runnable runnable, IVHost iVHost) {
        super(runnable);
        this.vhost = iVHost;
        this.nullVHost = this.vhost == null;
    }

    public VHostWorkerThread(IVHost iVHost) {
        this.vhost = iVHost;
        this.nullVHost = this.vhost == null;
    }

    public IVHost getVHost() {
        return this.vhost;
    }

    public void reset() {
        this.setClient(null);
        if (this.nullVHost) {
            this.vhost = null;
        }
        WMSLoggerFactory.resetMDC();
    }

    public void clear() {
        this.logContext = null;
        this.client = null;
        this.appInstance = null;
        if (this.nullVHost) {
            this.vhost = null;
        }
        WMSLoggerFactory.resetMDC();
    }

    public void clearContext() {
        this.logContext = null;
    }

    public void updateLoggingValues(String string, IMediaStream iMediaStream) {
        if (string.equals("server")) {
            Server.getInstance().updateLoggingDuration();
        }
        if (this.client != null) {
            IClient iClient = null;
            if (string.equals("stream")) {
                if (iMediaStream != null) {
                    iClient = iMediaStream.getClient();
                }
                if (iClient == null) {
                    iClient = this.client;
                }
            }
            if (string.equals("stream")) {
                ((Client)iClient).updateLoggingValues();
            } else if (string.equals("session")) {
                this.client.updateLoggingValues();
            } else {
                this.client.clearLoggingValues();
            }
            if (string.equals("server")) {
                Server.getInstance().updateLoggingDuration();
            } else if (string.equals("vhost")) {
                this.client.getVHost().updateLoggingDuration();
            } else if (string.equals("application")) {
                if (this.client.getAppInstance() != null) {
                    ((ApplicationInstance)this.client.getAppInstance()).updateLoggingDuration();
                }
            } else if (string.equals("stream")) {
                ((Client)iClient).updateLoggingDuration();
            } else if (string.equals("session")) {
                this.client.updateLoggingDuration();
            }
        } else if (this.appInstance != null) {
            ((ApplicationInstance)this.appInstance).updateLoggingDuration();
        } else {
            Server.getInstance().updateLoggingDuration();
        }
    }

    public void setClient(Client client) {
        this.client = client;
        if (this.client != null && this.nullVHost) {
            this.vhost = client.getVHost();
        }
        this.clearContext();
    }

    public void setAppInstance(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
        if (this.appInstance != null) {
            this.vhost = iApplicationInstance.getVHost();
        }
        this.clearContext();
    }

    public String getLogContext() {
        if (this.logContext == null) {
            IApplicationInstance iApplicationInstance;
            IApplicationInstance iApplicationInstance2 = iApplicationInstance = this.client != null ? this.client.getAppInstance() : this.appInstance;
            if (iApplicationInstance != null) {
                IVHost iVHost = iApplicationInstance.getVHost();
                this.logContext = iVHost.getName() + "." + iApplicationInstance.getApplication().getName() + "." + iApplicationInstance.getName();
            } else {
                this.logContext = this.vhost != null ? this.vhost.getName() : "_Server_";
            }
        }
        return this.logContext;
    }
}

