/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.serialization;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.apache.mina.common.ByteBuffer;

public class ObjectSerializationOutputStream
extends OutputStream
implements ObjectOutput {
    private final DataOutputStream out;
    private int maxObjectSize = Integer.MAX_VALUE;

    public ObjectSerializationOutputStream(OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException("out");
        }
        this.out = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
    }

    public int getMaxObjectSize() {
        return this.maxObjectSize;
    }

    public void setMaxObjectSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxObjectSize: " + n);
        }
        this.maxObjectSize = n;
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(int n) throws IOException {
        this.out.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.out.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    public void writeObject(Object object) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(64, false);
        byteBuffer.setAutoExpand(true);
        byteBuffer.putObject(object);
        int n = byteBuffer.position() - 4;
        if (n > this.maxObjectSize) {
            byteBuffer.release();
            throw new IllegalArgumentException("The encoded object is too big: " + n + " (> " + this.maxObjectSize + ')');
        }
        this.out.write(byteBuffer.array(), 0, byteBuffer.position());
        byteBuffer.release();
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.out.writeBoolean(bl);
    }

    public void writeByte(int n) throws IOException {
        this.out.writeByte(n);
    }

    public void writeBytes(String string) throws IOException {
        this.out.writeBytes(string);
    }

    public void writeChar(int n) throws IOException {
        this.out.writeChar(n);
    }

    public void writeChars(String string) throws IOException {
        this.out.writeChars(string);
    }

    public void writeDouble(double d) throws IOException {
        this.out.writeDouble(d);
    }

    public void writeFloat(float f) throws IOException {
        this.out.writeFloat(f);
    }

    public void writeInt(int n) throws IOException {
        this.out.writeInt(n);
    }

    public void writeLong(long l) throws IOException {
        this.out.writeLong(l);
    }

    public void writeShort(int n) throws IOException {
        this.out.writeShort(n);
    }

    public void writeUTF(String string) throws IOException {
        this.out.writeUTF(string);
    }
}

