/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.codec.support;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.util.Queue;

public abstract class SimpleProtocolEncoderOutput
implements ProtocolEncoderOutput {
    private final Queue bufferQueue = new Queue();

    public Queue getBufferQueue() {
        return this.bufferQueue;
    }

    public void write(ByteBuffer byteBuffer) {
        this.bufferQueue.push(byteBuffer);
    }

    public void mergeAll() {
        ByteBuffer byteBuffer;
        int n = 0;
        int n2 = this.bufferQueue.size();
        if (n2 < 2) {
            return;
        }
        for (int i = n2 - 1; i >= 0; --i) {
            n += ((ByteBuffer)this.bufferQueue.get(i)).remaining();
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n);
        while ((byteBuffer = (ByteBuffer)this.bufferQueue.pop()) != null) {
            byteBuffer2.put(byteBuffer);
            byteBuffer.release();
        }
        byteBuffer2.flip();
        this.bufferQueue.push(byteBuffer2);
    }

    public WriteFuture flush() {
        ByteBuffer byteBuffer;
        Queue queue = this.bufferQueue;
        WriteFuture writeFuture = null;
        if (queue.isEmpty()) {
            return null;
        }
        while ((byteBuffer = (ByteBuffer)queue.pop()) != null) {
            if (!byteBuffer.hasRemaining()) continue;
            writeFuture = this.doFlush(byteBuffer);
        }
        return writeFuture;
    }

    protected abstract WriteFuture doFlush(ByteBuffer var1);
}

