/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.handler.chain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;

public class IoHandlerChain
implements IoHandlerCommand {
    private static volatile int nextId = 0;
    private final int id = nextId++;
    private final String NEXT_COMMAND = IoHandlerChain.class.getName() + '.' + this.id + ".nextCommand";
    private final Map name2entry = new HashMap();
    private final Entry head = new Entry(null, null, "head", this.createHeadCommand());
    private final Entry tail = new Entry(this.head, null, "tail", this.createTailCommand());

    public IoHandlerChain() {
        this.head.nextEntry = this.tail;
    }

    private IoHandlerCommand createHeadCommand() {
        return new IoHandlerCommand(){

            public void execute(IoHandlerCommand.NextCommand nextCommand, IoSession ioSession, Object object) throws Exception {
                nextCommand.execute(ioSession, object);
            }
        };
    }

    private IoHandlerCommand createTailCommand() {
        return new IoHandlerCommand(){

            public void execute(IoHandlerCommand.NextCommand nextCommand, IoSession ioSession, Object object) throws Exception {
                nextCommand = (IoHandlerCommand.NextCommand)ioSession.getAttribute(IoHandlerChain.this.NEXT_COMMAND);
                if (nextCommand != null) {
                    nextCommand.execute(ioSession, object);
                }
            }
        };
    }

    public Entry getEntry(String string) {
        Entry entry = (Entry)this.name2entry.get(string);
        if (entry == null) {
            return null;
        }
        return entry;
    }

    public IoHandlerCommand get(String string) {
        Entry entry = this.getEntry(string);
        if (entry == null) {
            return null;
        }
        return entry.getCommand();
    }

    public IoHandlerCommand.NextCommand getNextCommand(String string) {
        Entry entry = this.getEntry(string);
        if (entry == null) {
            return null;
        }
        return entry.getNextCommand();
    }

    public synchronized void addFirst(String string, IoHandlerCommand ioHandlerCommand) {
        this.checkAddable(string);
        this.register(this.head, string, ioHandlerCommand);
    }

    public synchronized void addLast(String string, IoHandlerCommand ioHandlerCommand) {
        this.checkAddable(string);
        this.register(this.tail.prevEntry, string, ioHandlerCommand);
    }

    public synchronized void addBefore(String string, String string2, IoHandlerCommand ioHandlerCommand) {
        Entry entry = this.checkOldName(string);
        this.checkAddable(string2);
        this.register(entry.prevEntry, string2, ioHandlerCommand);
    }

    public synchronized void addAfter(String string, String string2, IoHandlerCommand ioHandlerCommand) {
        Entry entry = this.checkOldName(string);
        this.checkAddable(string2);
        this.register(entry, string2, ioHandlerCommand);
    }

    public synchronized IoHandlerCommand remove(String string) {
        Entry entry = this.checkOldName(string);
        this.deregister(entry);
        return entry.getCommand();
    }

    public synchronized void clear() throws Exception {
        Iterator iterator = new ArrayList(this.name2entry.keySet()).iterator();
        while (iterator.hasNext()) {
            this.remove((String)iterator.next());
        }
    }

    private void register(Entry entry, String string, IoHandlerCommand ioHandlerCommand) {
        Entry entry2 = new Entry(entry, entry.nextEntry, string, ioHandlerCommand);
        entry.nextEntry.prevEntry = entry2;
        entry.nextEntry = entry2;
        this.name2entry.put(string, entry2);
    }

    private void deregister(Entry entry) {
        Entry entry2 = entry.prevEntry;
        Entry entry3 = entry.nextEntry;
        entry2.nextEntry = entry3;
        entry3.prevEntry = entry2;
        this.name2entry.remove(entry.name);
    }

    private Entry checkOldName(String string) {
        Entry entry = (Entry)this.name2entry.get(string);
        if (entry == null) {
            throw new IllegalArgumentException("Unknown filter name:" + string);
        }
        return entry;
    }

    private void checkAddable(String string) {
        if (this.name2entry.containsKey(string)) {
            throw new IllegalArgumentException("Other filter is using the same name '" + string + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IoHandlerCommand.NextCommand nextCommand, IoSession ioSession, Object object) throws Exception {
        if (nextCommand != null) {
            ioSession.setAttribute(this.NEXT_COMMAND, nextCommand);
        }
        try {
            this.callNextCommand(this.head, ioSession, object);
        }
        finally {
            ioSession.removeAttribute(this.NEXT_COMMAND);
        }
    }

    private void callNextCommand(Entry entry, IoSession ioSession, Object object) throws Exception {
        entry.getCommand().execute(entry.getNextCommand(), ioSession, object);
    }

    public List getAll() {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        Entry entry = this.head.nextEntry;
        while (entry != this.tail) {
            arrayList.add(entry);
            entry = entry.nextEntry;
        }
        return arrayList;
    }

    public List getAllReversed() {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        Entry entry = this.tail.prevEntry;
        while (entry != this.head) {
            arrayList.add(entry);
            entry = entry.prevEntry;
        }
        return arrayList;
    }

    public boolean contains(String string) {
        return this.getEntry(string) != null;
    }

    public boolean contains(IoHandlerCommand ioHandlerCommand) {
        Entry entry = this.head.nextEntry;
        while (entry != this.tail) {
            if (entry.getCommand() == ioHandlerCommand) {
                return true;
            }
            entry = entry.nextEntry;
        }
        return false;
    }

    public boolean contains(Class clazz) {
        Entry entry = this.head.nextEntry;
        while (entry != this.tail) {
            if (clazz.isAssignableFrom(entry.getCommand().getClass())) {
                return true;
            }
            entry = entry.nextEntry;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        boolean bl = true;
        Entry entry = this.head.nextEntry;
        while (entry != this.tail) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append('(');
            stringBuffer.append(entry.getName());
            stringBuffer.append(':');
            stringBuffer.append(entry.getCommand());
            stringBuffer.append(')');
            entry = entry.nextEntry;
        }
        if (bl) {
            stringBuffer.append("empty");
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public class Entry {
        private Entry prevEntry;
        private Entry nextEntry;
        private final String name;
        private final IoHandlerCommand command;
        private final IoHandlerCommand.NextCommand nextCommand;

        private Entry(Entry entry, Entry entry2, String string, IoHandlerCommand ioHandlerCommand) {
            if (ioHandlerCommand == null) {
                throw new NullPointerException("command");
            }
            if (string == null) {
                throw new NullPointerException("name");
            }
            this.prevEntry = entry;
            this.nextEntry = entry2;
            this.name = string;
            this.command = ioHandlerCommand;
            this.nextCommand = new IoHandlerCommand.NextCommand(){

                public void execute(IoSession ioSession, Object object) throws Exception {
                    Entry entry = Entry.this.nextEntry;
                    IoHandlerChain.this.callNextCommand(entry, ioSession, object);
                }
            };
        }

        public String getName() {
            return this.name;
        }

        public IoHandlerCommand getCommand() {
            return this.command;
        }

        public IoHandlerCommand.NextCommand getNextCommand() {
            return this.nextCommand;
        }
    }
}

