/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe.support;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.support.AbstractIoFilterChain;
import org.apache.mina.transport.vmpipe.support.VmPipeSessionImpl;
import org.apache.mina.util.Queue;

public class VmPipeFilterChain
extends AbstractIoFilterChain {
    public VmPipeFilterChain(IoSession ioSession) {
        super(ioSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireMessageReceived(IoSession ioSession, Object object) {
        VmPipeSessionImpl vmPipeSessionImpl = (VmPipeSessionImpl)ioSession;
        Object object2 = vmPipeSessionImpl.lock;
        synchronized (object2) {
            if (!vmPipeSessionImpl.getTrafficMask().isReadable()) {
                Queue queue = vmPipeSessionImpl.pendingDataQueue;
                synchronized (queue) {
                    vmPipeSessionImpl.pendingDataQueue.push(object);
                }
            } else {
                int n = 1;
                if (object instanceof ByteBuffer) {
                    n = ((ByteBuffer)object).remaining();
                }
                vmPipeSessionImpl.increaseReadBytes(n);
                super.fireMessageReceived(vmPipeSessionImpl, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWrite(IoSession ioSession, IoFilter.WriteRequest writeRequest) {
        VmPipeSessionImpl vmPipeSessionImpl = (VmPipeSessionImpl)ioSession;
        Object object = vmPipeSessionImpl.lock;
        synchronized (object) {
            if (vmPipeSessionImpl.isConnected()) {
                if (!vmPipeSessionImpl.getTrafficMask().isWritable()) {
                    Queue queue = vmPipeSessionImpl.pendingDataQueue;
                    synchronized (queue) {
                        vmPipeSessionImpl.pendingDataQueue.push(writeRequest);
                    }
                } else {
                    Object object2 = writeRequest.getMessage();
                    int n = 1;
                    Object object3 = object2;
                    if (object2 instanceof ByteBuffer) {
                        ByteBuffer byteBuffer = (ByteBuffer)object2;
                        byteBuffer.mark();
                        n = byteBuffer.remaining();
                        ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.remaining());
                        byteBuffer2.put(byteBuffer);
                        byteBuffer2.flip();
                        byteBuffer.reset();
                        object3 = byteBuffer2;
                    }
                    vmPipeSessionImpl.increaseWrittenBytes(n);
                    vmPipeSessionImpl.increaseWrittenWriteRequests();
                    vmPipeSessionImpl.getFilterChain().fireMessageSent(vmPipeSessionImpl, writeRequest);
                    vmPipeSessionImpl.remoteSession.getFilterChain().fireMessageReceived(vmPipeSessionImpl.remoteSession, object3);
                }
            } else {
                writeRequest.getFuture().setWritten(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose(IoSession ioSession) {
        VmPipeSessionImpl vmPipeSessionImpl = (VmPipeSessionImpl)ioSession;
        Object object = vmPipeSessionImpl.lock;
        synchronized (object) {
            if (!ioSession.getCloseFuture().isClosed()) {
                vmPipeSessionImpl.getServiceListeners().fireSessionDestroyed(vmPipeSessionImpl);
                vmPipeSessionImpl.remoteSession.close();
            }
        }
    }
}

