/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.integration.liverecord;

import com.wowza.util.FLVUtils;
import com.wowza.util.FileUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.plugin.integration.liverecord.ILiveStreamRecord;
import com.wowza.wms.plugin.integration.liverecord.LiveStreamRecordActionNotifier;
import com.wowza.wms.plugin.integration.liverecord.LiveStreamRecorderBase;
import com.wowza.wms.plugin.integration.liverecord.LiveStreamRecorderWorker;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamActionNotify;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveStreamRecorderFLV
extends LiveStreamRecorderBase
implements ILiveStreamRecord {
    private FileOutputStream ds = null;
    private long startTC = 0L;
    private long timecodeOffset = -1L;
    private boolean waitForKeyFrame = true;
    private long lastSeq = -1L;
    private long lastTC = -1L;
    private int startVideoFrames = 0;
    private int startTotalFrames = 0;
    private boolean isFirstAudio = true;
    private boolean isFirstVideo = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFile() {
        boolean fileOpen = false;
        Object object = this.writeLock;
        synchronized (object) {
            if (this.ds != null) {
                try {
                    this.ds.close();
                    fileOpen = true;
                }
                catch (Exception e) {
                    WMSLoggerFactory.getLogger(LiveStreamRecorderFLV.class).error("LiveStreamRecorder.startRecording: close file: " + e.toString());
                }
            }
            this.ds = null;
        }
        if (fileOpen) {
            File newFile = new File(this.filePath);
            if (this.lastTC != -1L) {
                double durationSecs = (double)this.lastTC / 1000.0;
                if (newFile.exists()) {
                    FLVUtils.writeDuration((File)newFile, (double)durationSecs);
                }
            }
            if (this.stream != null) {
                this.stream.getStreams().getAppInstance().notifyMediaWriterOnWriteComplete(this.stream, newFile);
            }
        }
    }

    private void openFile(File file, boolean append) {
        try {
            this.ds = new FileOutputStream(file, append);
        }
        catch (Exception e) {
            WMSLoggerFactory.getLogger(LiveStreamRecorderFLV.class).error("LiveStreamRecorder.startRecording: open file (" + file + "): " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWorker(boolean wait) {
        Object object = this.writeLock;
        synchronized (object) {
            if (this.worker != null) {
                this.worker.quit();
            }
        }
        if (this.worker != null && wait) {
            while (this.worker.running()) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
                catch (Exception e) {
                    WMSLoggerFactory.getLogger(LiveStreamRecorderFLV.class).error("LiveStreamRecorder.stopWorker: sleep: " + e.toString());
                }
            }
        }
    }

    @Override
    public void startRecording(IMediaStream stream, boolean append) {
        this.startRecording(stream, null, append, null);
    }

    @Override
    public void startRecording(IMediaStream stream, String filePath, boolean append) {
        this.startRecording(stream, filePath, append, null);
    }

    @Override
    public void startRecording(IMediaStream stream, String filePath, boolean append, Map extraMetadata) {
        try {
            this.stopWorker(false);
            this.worker = null;
            this.closeFile();
            this.stream = stream;
            if (filePath == null) {
                File tmp = stream.getStreamFileForWrite(stream.getName(), "flv", stream.getQueryStr());
                this.filePath = tmp.getAbsolutePath();
            } else {
                this.filePath = filePath;
            }
            this.streamNotifier = new LiveStreamRecordActionNotifier(this);
            this.stream.addClientListener((IMediaStreamActionNotify)this.streamNotifier);
            this.timecodeOffset = -1L;
            this.waitForKeyFrame = true;
            this.lastSeq = -1L;
            this.lastTC = -1L;
            this.startTC = 0L;
            this.startVideoFrames = 0;
            this.startTotalFrames = 0;
            boolean localAppend = false;
            File newFile = new File(this.filePath);
            if (append && newFile.exists()) {
                this.startTC = FLVUtils.getLastTC((File)newFile);
                localAppend = true;
            }
            if (!localAppend && newFile.exists()) {
                if (this.versionFile) {
                    FileUtils.versionFile((File)newFile);
                } else {
                    try {
                        newFile.delete();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            this.openFile(newFile, localAppend);
            if (this.ds != null) {
                if (!localAppend) {
                    if (this.stream != null) {
                        this.stream.getStreams().getAppInstance().notifyMediaWriterOnFLVAddMetadata(this.stream, extraMetadata);
                    }
                    FLVUtils.writeHeader((OutputStream)this.ds, (double)0.0, (Map)extraMetadata);
                }
                this.worker = new LiveStreamRecorderWorker(this);
                this.worker.setDaemon(true);
                this.worker.start();
            }
        }
        catch (Exception e) {
            WMSLoggerFactory.getLogger(LiveStreamRecorderFLV.class).error("LiveStreamRecorder.startRecording: " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void stopRecording() {
        try {
            this.stopWorker(true);
            this.worker = null;
        }
        catch (Exception e) {
            WMSLoggerFactory.getLogger(LiveStreamRecorderFLV.class).error("LiveStreamRecorder.stopRecording: " + e.toString());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStream() {
        Object object = this.writeLock;
        synchronized (object) {
            if (this.lastTC != -1L) {
                this.startTC = this.lastTC;
            }
            this.timecodeOffset = -1L;
            this.waitForKeyFrame = true;
            this.lastSeq = -1L;
            this.lastTC = -1L;
            this.startVideoFrames = 0;
            this.startTotalFrames = 0;
            this.isFirstAudio = true;
            this.isFirstVideo = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPublish() {
        Object object = this.writeLock;
        synchronized (object) {
            this.resetStream();
            File newFile = new File(this.filePath);
            this.openFile(newFile, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUnPublish() {
        Object object = this.writeLock;
        synchronized (object) {
            this.closeFile();
            this.resetStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void workStop() {
        Object object = this.writeLock;
        synchronized (object) {
            this.closeFile();
        }
        if (this.streamNotifier != null) {
            this.stream.removeClientListener((IMediaStreamActionNotify)this.streamNotifier);
            this.streamNotifier = null;
        }
    }

    protected List<AMFPacket> getPlayPackets() {
        return this.stream.getPlayPackets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void work() {
        Object object = this.writeLock;
        synchronized (object) {
            int packetType;
            int idx;
            int startIdx;
            int numPackets;
            List<AMFPacket> packets;
            if (this.stream == null || this.ds == null || (packets = this.getPlayPackets()) == null || (numPackets = packets.size()) == 0) return;
            AMFPacket packet = null;
            packet = packets.get(0);
            long startSeq = packet.getSeq();
            int n = startIdx = this.lastSeq == -1L ? 0 : (int)(this.lastSeq - startSeq + 1L);
            if (startIdx < 0) {
                startIdx = 0;
            }
            if (startIdx >= numPackets) return;
            if (this.timecodeOffset == -1L) {
                for (idx = numPackets - 1; idx >= 0; --idx) {
                    packet = packets.get(idx);
                    packetType = packet.getType();
                    if (packetType != 9 && packetType != 8) continue;
                    ++this.startTotalFrames;
                    if (this.isStartOnKeyFrame()) {
                        if (packetType == 9) {
                            ++this.startVideoFrames;
                            if (!FLVUtils.isVideoKeyFrame((AMFPacket)packet)) continue;
                            startIdx = idx;
                            this.timecodeOffset = packet.getAbsTimecode();
                            break;
                        }
                        if (this.startVideoFrames != 0 || this.startTotalFrames <= 20) continue;
                        startIdx = idx;
                        this.timecodeOffset = packet.getAbsTimecode();
                        break;
                    }
                    startIdx = idx;
                    this.timecodeOffset = packet.getAbsTimecode();
                    break;
                }
            }
            if (this.timecodeOffset < 0L) return;
            for (idx = startIdx; idx < numPackets; ++idx) {
                AMFPacket newPacket;
                AMFPacket codecConfigPacket;
                int codec;
                int firstByte;
                long adjTimecode;
                int codec2;
                int secondByte;
                int firstByte2;
                packet = packets.get(idx);
                packetType = packet.getType();
                this.lastSeq = packet.getSeq();
                int size = packet.getSize();
                if (!this.isRecordData() && packetType != 9 && packetType != 8) continue;
                boolean sendFrame = true;
                if (this.waitForKeyFrame && packetType == 9) {
                    sendFrame = false;
                    if (FLVUtils.isVideoKeyFrame((AMFPacket)packet)) {
                        sendFrame = true;
                        this.waitForKeyFrame = false;
                    }
                }
                if (packetType == 9 && size >= 2) {
                    firstByte2 = packet.getFirstByte();
                    secondByte = packet.getSecondByte();
                    if (size == 2 && (firstByte2 & 0x50) == 80 && (secondByte == 0 || secondByte == 1)) {
                        sendFrame = false;
                    }
                    if ((codec2 = FLVUtils.getVideoCodec((int)firstByte2)) == 7 && secondByte != 1) {
                        sendFrame = false;
                    }
                }
                if (packetType == 8 && size >= 2) {
                    firstByte2 = packet.getFirstByte();
                    secondByte = packet.getSecondByte();
                    codec2 = FLVUtils.getAudioCodec((int)firstByte2);
                    if (codec2 == 10 && secondByte != 1) {
                        sendFrame = false;
                    }
                }
                if (!sendFrame || (adjTimecode = packet.getAbsTimecode() - this.timecodeOffset) < 0L) continue;
                this.lastTC = adjTimecode + this.startTC;
                if (packetType == 8) {
                    if (this.isFirstAudio) {
                        firstByte = packet.getFirstByte();
                        codec = FLVUtils.getAudioCodec((int)firstByte);
                        if (codec == 10) {
                            try {
                                codecConfigPacket = this.stream.getAudioCodecConfigPacket(packet.getAbsTimecode());
                                if (codecConfigPacket != null) {
                                    FLVUtils.writeChunk((OutputStream)this.ds, (ByteBuffer)codecConfigPacket.getDataBuffer(), (int)codecConfigPacket.getSize(), (long)this.lastTC, (byte)((byte)codecConfigPacket.getType()));
                                }
                            }
                            catch (Exception e) {
                                WMSLoggerFactory.getLogger(LiveStreamRecorderFLV.class).error("LiveStreamRecorderFLV.extractAACCodecInfoFromStream: " + e.toString());
                            }
                        }
                        this.isFirstAudio = false;
                    }
                } else if (packetType == 9 && this.isFirstVideo) {
                    firstByte = packet.getFirstByte();
                    codec = FLVUtils.getVideoCodec((int)firstByte);
                    if (codec == 7) {
                        try {
                            codecConfigPacket = this.stream.getVideoCodecConfigPacket(packet.getAbsTimecode());
                            if (codecConfigPacket != null) {
                                FLVUtils.writeChunk((OutputStream)this.ds, (ByteBuffer)codecConfigPacket.getDataBuffer(), (int)codecConfigPacket.getSize(), (long)this.lastTC, (byte)((byte)codecConfigPacket.getType()));
                            }
                        }
                        catch (Exception e) {
                            WMSLoggerFactory.getLogger(LiveStreamRecorderFLV.class).error("LiveStreamRecorderFLV.extractH264CodecInfoFromStream: " + e.toString());
                        }
                    }
                    this.isFirstVideo = false;
                }
                if ((packetType == 18 || packetType == 15) && (newPacket = FLVUtils.updateOnCuePointTimecode((AMFPacket)packet, (long)this.lastTC)) != null) {
                    packet = newPacket;
                }
                FLVUtils.writeChunk((OutputStream)this.ds, (ByteBuffer)packet.getDataBuffer(), (int)packet.getSize(), (long)this.lastTC, (byte)((byte)packet.getType()));
            }
            return;
        }
    }
}

