/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.http;

import com.wowza.util.IOPerformanceCounter;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.Client;
import com.wowza.wms.client.ConnectionCounter;
import com.wowza.wms.client.IClient;
import com.wowza.wms.http.HTTPServerVersion;
import com.wowza.wms.http.HTTProvider2Base;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.io.OutputStream;
import java.util.List;
import org.apache.mina.common.IoSession;

public class HTTPServerInfoXMLNew
extends HTTProvider2Base {
    private void outputConnectionInfo(StringBuffer ret, ConnectionCounter counter) {
        ret.append("<ConnectionsCurrent>" + counter.getCurrent() + "</ConnectionsCurrent>");
        ret.append("<ConnectionsTotal>" + counter.getTotal() + "</ConnectionsTotal>");
        ret.append("<ConnectionsTotalAccepted>" + counter.getTotalAccepted() + "</ConnectionsTotalAccepted>");
        ret.append("<ConnectionsTotalRejected>" + counter.getTotalRejected() + "</ConnectionsTotalRejected>");
    }

    public String fixNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public void onHTTPRequest(IVHost inVhost, IHTTPRequest req, IHTTPResponse resp) {
        if (!this.doHTTPAuthentication(inVhost, req, resp)) {
            return;
        }
        StringBuffer ret = new StringBuffer();
        long currTime = System.currentTimeMillis();
        try {
            List vhostNames = VHostSingleton.getVHostNames();
            ret.append("<?xml version=\"1.0\"?>\n<WowzaMediaServerPro>");
            for (String vhostName : vhostNames) {
                IVHost vhost = VHostSingleton.getInstance((String)vhostName);
                if (vhost == null) continue;
                ret.append("<VHost>");
                ret.append("<Name>" + vhostName + "</Name>");
                ret.append("<TimeRunning>" + vhost.getTimeRunningSeconds() + "</TimeRunning>");
                ret.append("<ConnectionsLimit>" + vhost.getConnectionLimit() + "</ConnectionsLimit>");
                this.outputConnectionInfo(ret, vhost.getConnectionCounter());
                List appNames = vhost.getApplicationNames();
                List appFolders = vhost.getApplicationFolderNames();
                for (String applicationName : appFolders) {
                    ret.append("<Application>");
                    ret.append("<Name><![CDATA[" + applicationName + "]]></Name>");
                    boolean appExists = appNames.contains(applicationName);
                    ret.append("<Status>" + (appExists ? "loaded" : "unloaded") + "</Status>");
                    if (appExists) {
                        IApplication application = vhost.getApplication(applicationName);
                        if (application == null) continue;
                        ret.append("<TimeRunning>" + application.getTimeRunningSeconds() + "</TimeRunning>");
                        this.outputConnectionInfo(ret, application.getConnectionCounter());
                        List appInstances = application.getAppInstanceNames();
                        for (String appInstanceName : appInstances) {
                            IApplicationInstance appInstance = application.getAppInstance(appInstanceName);
                            if (appInstance == null) continue;
                            ret.append("<ApplicationInstance>");
                            ret.append("<Name><![CDATA[" + appInstance.getName() + "]]></Name>");
                            ret.append("<TimeRunning>" + appInstance.getTimeRunningSeconds() + "</TimeRunning>");
                            this.outputConnectionInfo(ret, appInstance.getConnectionCounter());
                            List clients = appInstance.getClients();
                            List httpSessions = appInstance.getHTTPStreamerSessions();
                            List rtpSessions = appInstance.getRTPSessions();
                            ret.append("<RTMPConnectionCount>" + appInstance.getConnectionCounter(0).getCurrent() + "</RTMPConnectionCount>");
                            ret.append("<RTPConnectionCount>" + appInstance.getConnectionCounter(1).getCurrent() + "</RTPConnectionCount>");
                            ret.append("<CupertinoConnectionCount>" + appInstance.getConnectionCounter(2).getCurrent() + "</CupertinoConnectionCount>");
                            ret.append("<SmoothConnectionCount>" + appInstance.getConnectionCounter(3).getCurrent() + "</SmoothConnectionCount>");
                            ret.append("<SanJoseConnectionCount>" + appInstance.getConnectionCounter(4).getCurrent() + "</SanJoseConnectionCount>");
                            ret.append("<RTMPSessionCount>" + clients.size() + "</RTMPSessionCount>");
                            ret.append("<HTTPSessionCount>" + httpSessions.size() + "</HTTPSessionCount>");
                            ret.append("<RTPSessionCount>" + rtpSessions.size() + "</RTPSessionCount>");
                            for (IClient client : clients) {
                                IOPerformanceCounter ioPerformance;
                                if (client == null) continue;
                                ret.append("<Client>");
                                ret.append("<ClientId>" + client.getClientId() + "</ClientId>");
                                ret.append("<FlashVersion>" + client.getFlashVer() + "</FlashVersion>");
                                ret.append("<IpAddress>" + client.getIp() + "</IpAddress>");
                                ret.append("<Referrer><![CDATA[" + this.fixNull(client.getReferrer()) + "]]></Referrer>");
                                ret.append("<QueryString><![CDATA[" + this.fixNull(client.getQueryStr()) + "]]></QueryString>");
                                ret.append("<TimeRunning>" + client.getTimeRunningSeconds() + "</TimeRunning>");
                                ret.append("<DateStarted>" + client.getDateStarted() + "</DateStarted>");
                                ret.append("<URI><![CDATA[" + client.getUri() + "]]></URI>");
                                String protocolStr = "unknown";
                                switch (client.getProtocol()) {
                                    case 1: {
                                        protocolStr = client.isEncrypted() ? "RTMPE" : "RTMP";
                                        break;
                                    }
                                    case 3: {
                                        protocolStr = client.isSSL() ? "RTMPS" : (client.isEncrypted() ? "RTMPTE" : "RTMPT");
                                    }
                                }
                                ret.append("<Protocol>" + protocolStr + "</Protocol>");
                                ret.append("<IsSSL>" + client.isSSL() + "</IsSSL>");
                                ret.append("<IsEncrypted>" + client.isEncrypted() + "</IsEncrypted>");
                                ret.append("<Port>" + client.getServerHostPort().getPort() + "</Port>");
                                long lastValidate = client.getLastValidateTime();
                                if (lastValidate <= 0L) {
                                    ret.append("<LastValidateTime>-1</LastValidateTime>");
                                } else {
                                    long incTime = currTime - lastValidate;
                                    if (incTime < 0L) {
                                        incTime = 0L;
                                    }
                                    ret.append("<LastValidateTime>" + incTime + "</LastValidateTime>");
                                }
                                IoSession ioSession = ((Client)client).getIoSession();
                                if (ioSession != null) {
                                    ret.append("<IoSessionBytesSent>" + ioSession.getWrittenBytes() + "</IoSessionBytesSent>");
                                    ret.append("<IoSessionBytesReceived>" + ioSession.getReadBytes() + "</IoSessionBytesReceived>");
                                    long lastIo = currTime - ioSession.getLastIoTime();
                                    if (lastIo < 0L) {
                                        lastIo = 0L;
                                    }
                                    ret.append("<IoSessionLastIo>" + lastIo + "</IoSessionLastIo>");
                                }
                                if ((ioPerformance = client.getMediaIOPerformanceCounter()) != null) {
                                    ret.append("<IoBytesSent>" + ioPerformance.getMessagesOutBytes() + "</IoBytesSent>");
                                    ret.append("<IoBytesReceived>" + ioPerformance.getMessagesInBytes() + "</IoBytesReceived>");
                                }
                                ret.append("</Client>");
                            }
                            for (IHTTPStreamerSession httpSession : httpSessions) {
                                if (httpSession == null) continue;
                                ret.append("<HTTPSession>");
                                ret.append("<SessionId>" + httpSession.getSessionId() + "</SessionId>");
                                ret.append("<IpAddress>" + httpSession.getIpAddress() + "</IpAddress>");
                                ret.append("<Referrer><![CDATA[" + this.fixNull(httpSession.getReferrer()) + "]]></Referrer>");
                                ret.append("<QueryString><![CDATA[" + this.fixNull(httpSession.getQueryStr()) + "]]></QueryString>");
                                ret.append("<TimeRunning>" + httpSession.getTimeRunningSeconds() + "</TimeRunning>");
                                ret.append("<DateStarted>" + httpSession.getElapsedTime().getDateString() + "</DateStarted>");
                                ret.append("<URI><![CDATA[" + httpSession.getUri() + "]]></URI>");
                                ret.append("<Protocol>" + httpSession.getSessionProtocol() + "</Protocol>");
                                ret.append("<SessionType>" + httpSession.getSessionType() + "</SessionType>");
                                ret.append("<Port>" + httpSession.getServerPort() + "</Port>");
                                IOPerformanceCounter ioPerformance = httpSession.getIOPerformanceCounter();
                                if (ioPerformance != null) {
                                    ret.append("<IoBytesSent>" + ioPerformance.getMessagesOutBytes() + "</IoBytesSent>");
                                    ret.append("<IoBytesReceived>" + ioPerformance.getMessagesInBytes() + "</IoBytesReceived>");
                                }
                                ret.append("</HTTPSession>");
                            }
                            for (RTPSession rtpSession : rtpSessions) {
                                if (rtpSession == null) continue;
                                ret.append("<RTPSession>");
                                ret.append("<SessionId>" + rtpSession.getSessionId() + "</SessionId>");
                                ret.append("<IpAddress>" + rtpSession.getIp() + "</IpAddress>");
                                ret.append("<Referrer><![CDATA[" + this.fixNull(rtpSession.getReferrer()) + "]]></Referrer>");
                                ret.append("<QueryString><![CDATA[" + this.fixNull(rtpSession.getQueryStr()) + "]]></QueryString>");
                                ret.append("<TimeRunning>" + rtpSession.getTimeRunningSeconds() + "</TimeRunning>");
                                ret.append("<DateStarted>" + rtpSession.getElapsedTime().getDateString() + "</DateStarted>");
                                ret.append("<URI><![CDATA[" + rtpSession.getUri() + "]]></URI>");
                                ret.append("<Port>" + rtpSession.getServerPort() + "</Port>");
                                IOPerformanceCounter ioPerformance = rtpSession.getIOPerformanceCounter();
                                if (ioPerformance != null) {
                                    ret.append("<IoBytesSent>" + ioPerformance.getMessagesOutBytes() + "</IoBytesSent>");
                                    ret.append("<IoBytesReceived>" + ioPerformance.getMessagesInBytes() + "</IoBytesReceived>");
                                }
                                ret.append("</RTPSession>");
                            }
                            ret.append("</ApplicationInstance>");
                        }
                    }
                    ret.append("</Application>");
                }
                ret.append("</VHost>");
            }
            ret.append("</WowzaMediaServerPro>");
        }
        catch (Exception e) {
            WMSLoggerFactory.getLogger(HTTPServerVersion.class).error("HTTPServerInfoXML.onHTTPRequest: " + e.toString());
            e.printStackTrace();
        }
        try {
            resp.setHeader("Content-Type", "text/xml");
            OutputStream out = resp.getOutputStream();
            byte[] outBytes = ret.toString().getBytes();
            out.write(outBytes);
        }
        catch (Exception e) {
            WMSLoggerFactory.getLogger(HTTPServerVersion.class).error("HTTPServerInfoXML.onHTTPRequest: " + e.toString());
            e.printStackTrace();
        }
    }
}

