/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

class IntHashMap {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private final float loadFactor;

    public IntHashMap() {
        this(20, 0.75f);
    }

    public IntHashMap(int n) {
        this(n, 0.75f);
    }

    public IntHashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    public boolean containsKey(int n) {
        Entry[] entryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.hash == n2) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public Object get(int n) {
        Entry[] entryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.hash == n2) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public Object put(int n, Object object) {
        Entry[] entryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.hash == n2) {
                Object object2 = entry.value;
                entry.value = object;
                return object2;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n3] = entry = new Entry(n2, n, object, entryArray[n3]);
        ++this.count;
        return null;
    }

    public Object remove(int n) {
        Entry[] entryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n2) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n3] = entry.next;
                }
                --this.count;
                Object object = entry.value;
                entry.value = null;
                return object;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public synchronized void clear() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    private static class Entry {
        final int hash;
        final int key;
        Object value;
        Entry next;

        protected Entry(int n, int n2, Object object, Entry entry) {
            this.hash = n;
            this.key = n2;
            this.value = object;
            this.next = entry;
        }
    }
}

